/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.util.Map;
import java.util.Properties;
import ome.api.IAdmin;
import ome.api.IAnalysis;
import ome.api.IConfig;
import ome.api.IContainer;
import ome.api.IDelete;
import ome.api.ILdap;
import ome.api.IMetadata;
import ome.api.IPixels;
import ome.api.IProjection;
import ome.api.IQuery;
import ome.api.IRenderingSettings;
import ome.api.IRepositoryInfo;
import ome.api.ISession;
import ome.api.IShare;
import ome.api.ITypes;
import ome.api.IUpdate;
import ome.api.JobHandle;
import ome.api.RawFileStore;
import ome.api.RawPixelsStore;
import ome.api.Search;
import ome.api.ServiceInterface;
import ome.api.ThumbnailStore;
import ome.conditions.ApiUsageException;
import ome.model.meta.Session;
import ome.system.Login;
import ome.system.OmeroContext;
import ome.system.Server;
import ome.system.SessionInitializer;
import omeis.providers.re.RenderingEngine;
import org.springframework.beans.BeansException;

public class ServiceFactory {
    protected OmeroContext ctx;

    public ServiceFactory() {
        if (this.getDefaultContext() != null) {
            this.ctx = OmeroContext.getInstance(this.getDefaultContext());
        }
    }

    public ServiceFactory(Login login) {
        this.ctx = OmeroContext.getClientContext(login.asProperties());
    }

    public ServiceFactory(Server server) {
        this.ctx = OmeroContext.getClientContext(server.asProperties());
    }

    public ServiceFactory(Server server, Login login) {
        Properties s = server.asProperties();
        Properties l = login.asProperties();
        s.putAll((Map<?, ?>)l);
        this.ctx = OmeroContext.getClientContext(s);
    }

    public ServiceFactory(Properties properties) {
        this.ctx = OmeroContext.getClientContext(properties);
    }

    public ServiceFactory(OmeroContext context) {
        this.ctx = context;
    }

    public ServiceFactory(String contextName) {
        this.ctx = OmeroContext.getInstance(contextName);
    }

    public IAdmin getAdminService() {
        return this.getServiceByClass(IAdmin.class);
    }

    public IAnalysis getAnalysisService() {
        return this.getServiceByClass(IAnalysis.class);
    }

    public IConfig getConfigService() {
        return this.getServiceByClass(IConfig.class);
    }

    public IContainer getContainerService() {
        return this.getServiceByClass(IContainer.class);
    }

    public IDelete getDeleteService() {
        return this.getServiceByClass(IDelete.class);
    }

    public ILdap getLdapService() {
        return this.getServiceByClass(ILdap.class);
    }

    public IPixels getPixelsService() {
        return this.getServiceByClass(IPixels.class);
    }

    public IProjection getProjectionService() {
        return this.getServiceByClass(IProjection.class);
    }

    public IQuery getQueryService() {
        return this.getServiceByClass(IQuery.class);
    }

    public IShare getShareService() {
        return this.getServiceByClass(IShare.class);
    }

    public ITypes getTypesService() {
        return this.getServiceByClass(ITypes.class);
    }

    public IUpdate getUpdateService() {
        return this.getServiceByClass(IUpdate.class);
    }

    public IRenderingSettings getRenderingSettingsService() {
        return this.getServiceByClass(IRenderingSettings.class);
    }

    public IRepositoryInfo getRepositoryInfoService() {
        return this.getServiceByClass(IRepositoryInfo.class);
    }

    public IMetadata getMetadataService() {
        return this.getServiceByClass(IMetadata.class);
    }

    public JobHandle createJobHandle() {
        return this.getServiceByClass(JobHandle.class);
    }

    public RawPixelsStore createRawPixelsStore() {
        return this.getServiceByClass(RawPixelsStore.class);
    }

    public RawFileStore createRawFileStore() {
        return this.getServiceByClass(RawFileStore.class);
    }

    public RenderingEngine createRenderingEngine() {
        return this.getServiceByClass(RenderingEngine.class);
    }

    public Search createSearchService() {
        return this.getServiceByClass(Search.class);
    }

    public ThumbnailStore createThumbnailService() {
        return this.getServiceByClass(ThumbnailStore.class);
    }

    public ISession getSessionService() {
        return this.getServiceByClass(ISession.class);
    }

    public Session getSession() throws ApiUsageException {
        return this.getSessionInitializer().getSession();
    }

    public void setSession(Session session) throws ApiUsageException {
        SessionInitializer si = this.getSessionInitializer();
        si.setSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() throws ApiUsageException {
        ISession is = this.getSessionService();
        SessionInitializer si = this.getSessionInitializer();
        if (si.hasSession()) {
            Session s = si.getSession();
            try {
                is.closeSession(s);
            }
            finally {
                si.setSession(null);
            }
        }
    }

    protected SessionInitializer getSessionInitializer() {
        SessionInitializer si;
        try {
            si = (SessionInitializer)this.ctx.getBean("init");
        }
        catch (Exception e) {
            throw new ApiUsageException("This ServiceFactory is not configured for sessions");
        }
        return si;
    }

    public <T extends ServiceInterface> T getServiceByClass(Class<T> klass) {
        try {
            return (T)((ServiceInterface)klass.cast(this.ctx.getBean(this.getPrefix() + klass.getName())));
        }
        catch (BeansException be) {
            if (be.getCause() instanceof RuntimeException) {
                throw (RuntimeException)be.getCause();
            }
            throw be;
        }
    }

    protected String getPrefix() {
        return "managed-";
    }

    protected String getDefaultContext() {
        return "ome.client";
    }
}

