/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.codomain;

import omeis.providers.re.codomain.CodomainMap;
import omeis.providers.re.codomain.CodomainMapContext;
import omeis.providers.re.codomain.PlaneSlicingMap;

public class PlaneSlicingContext
extends CodomainMapContext {
    public static final int BIT_ZERO = 0;
    public static final int BIT_ONE = 2;
    public static final int BIT_TWO = 4;
    public static final int BIT_THREE = 8;
    public static final int BIT_FOUR = 16;
    public static final int BIT_FIVE = 32;
    public static final int BIT_SIX = 64;
    public static final int BIT_SEVEN = 128;
    public static final int BIT_EIGHT = 255;
    private int upperLimit;
    private int lowerLimit;
    private int planeSelected;
    private int planePrevious;
    private boolean constant;

    private void verifyBitPlanes(int bitPlane) {
        switch (bitPlane) {
            case 0: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 255: {
                return;
            }
        }
        throw new IllegalArgumentException("Not a valid plane.");
    }

    private void verifyInput(int x) {
        if (x < this.intervalStart || x > this.intervalEnd) {
            throw new IllegalArgumentException("Value not in the interval.");
        }
    }

    private PlaneSlicingContext() {
    }

    public PlaneSlicingContext(int planePrevious, int planeSelected, boolean constant) {
        if (planePrevious > planeSelected) {
            throw new IllegalArgumentException("Not a valid plane selection");
        }
        this.verifyBitPlanes(planePrevious);
        this.verifyBitPlanes(planeSelected);
        this.planePrevious = planePrevious;
        this.planeSelected = planeSelected;
        this.constant = constant;
    }

    @Override
    void buildContext() {
    }

    @Override
    CodomainMap getCodomainMap() {
        return new PlaneSlicingMap();
    }

    @Override
    public CodomainMapContext copy() {
        PlaneSlicingContext copy = new PlaneSlicingContext();
        copy.intervalEnd = this.intervalEnd;
        copy.intervalStart = this.intervalStart;
        copy.upperLimit = this.upperLimit;
        copy.lowerLimit = this.lowerLimit;
        copy.planeSelected = this.planeSelected;
        copy.planePrevious = this.planePrevious;
        copy.constant = this.constant;
        return copy;
    }

    public int getPlanePrevious() {
        return this.planePrevious;
    }

    public int getPlaneSelected() {
        return this.planeSelected;
    }

    public boolean IsConstant() {
        return this.constant;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public void setLimits(int lowerLimit, int upperLimit) {
        this.verifyInput(lowerLimit);
        this.verifyInput(upperLimit);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(int v) {
        this.verifyInput(v);
        this.lowerLimit = v;
    }

    public void setUpperLimit(int v) {
        this.verifyInput(v);
        this.upperLimit = v;
    }

    public void setPlanes(int planePrevious, int planeSelected) {
        if (planePrevious > planeSelected) {
            throw new IllegalArgumentException("Not a valid plane selection");
        }
        this.verifyBitPlanes(planePrevious);
        this.verifyBitPlanes(planeSelected);
        this.planePrevious = planePrevious;
        this.planeSelected = planeSelected;
    }

    public void setConstant(boolean b) {
        this.constant = b;
    }
}

