/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ome.conditions.ApiUsageException;
import ome.util.PixelData;

public class ReorderedPixelData
extends PixelData {
    private Integer rowSize;

    public ReorderedPixelData(String pixelsType, ByteBuffer data, int rowSize) {
        super(pixelsType, data);
        this.rowSize = rowSize;
        if (data.capacity() % rowSize != 0) {
            throw new ApiUsageException("Buffer size not divisible by row size.");
        }
    }

    public static int getReorderedPixelOffset(int size, int offset, int rowSize) {
        int stride = offset / rowSize;
        int remainder = rowSize - offset % rowSize;
        return size - stride * rowSize - remainder;
    }

    public double getPixelValueDirect(int offset) {
        offset = ReorderedPixelData.getReorderedPixelOffset(this.data.capacity(), offset, this.rowSize);
        return super.getPixelValueDirect(offset);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public ByteOrder getOrder() {
        return this.data.order();
    }

    public void setOrder(ByteOrder order) {
        this.data.order(order);
    }
}

