/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.LoggerI;
import Ice.OperationInterruptedException;
import Ice.SignalPolicy;
import Ice.StringSeqHolder;
import Ice.Util;
import IceInternal.Ex;

public abstract class Application {
    protected static String _appName;
    protected static Communicator _communicator;
    protected static AppHook _appHook;
    protected static final Object _mutex;
    protected static boolean _callbackInProgress;
    protected static boolean _destroyed;
    protected static boolean _interrupted;
    protected static SignalPolicy _signalPolicy;

    public Application() {
    }

    public Application(SignalPolicy signalPolicy) {
        _signalPolicy = signalPolicy;
    }

    public final int main(String appName, String[] args) {
        return this.main(appName, args, new InitializationData());
    }

    public final int main(String appName, String[] args, String configFile) {
        if (Util.getProcessLogger() instanceof LoggerI) {
            Util.setProcessLogger(new LoggerI(appName, ""));
        }
        InitializationData initData = new InitializationData();
        if (configFile != null) {
            try {
                initData.properties = Util.createProperties();
                initData.properties.load(configFile);
            }
            catch (LocalException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                return 1;
            }
            catch (Exception ex) {
                Util.getProcessLogger().error("unknown exception: " + Ex.toString(ex));
                return 1;
            }
        }
        return this.main(appName, args, initData);
    }

    public final int main(String appName, String[] args, InitializationData initializationData) {
        if (Util.getProcessLogger() instanceof LoggerI) {
            Util.setProcessLogger(new LoggerI(appName, ""));
        }
        if (_communicator != null) {
            Util.getProcessLogger().error("only one instance of the Application class can be used");
            return 1;
        }
        _appName = appName;
        InitializationData initData = initializationData != null ? initializationData.clone() : new InitializationData();
        StringSeqHolder argHolder = new StringSeqHolder(args);
        try {
            initData.properties = Util.createProperties(argHolder, initData.properties);
        }
        catch (LocalException ex) {
            Util.getProcessLogger().error(Ex.toString(ex));
            return 1;
        }
        catch (Exception ex) {
            Util.getProcessLogger().error("unknown exception: " + Ex.toString(ex));
            return 1;
        }
        _appName = initData.properties.getPropertyWithDefault("Ice.ProgramName", _appName);
        if (!initData.properties.getProperty("Ice.ProgramName").equals("") && Util.getProcessLogger() instanceof LoggerI) {
            Util.setProcessLogger(new LoggerI(initData.properties.getProperty("Ice.ProgramName"), ""));
        }
        return this.doMain(argHolder, initData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doMain(StringSeqHolder argHolder, InitializationData initData) {
        int status = 0;
        try {
            _communicator = Util.initialize(argHolder, initData);
            if (_signalPolicy == SignalPolicy.HandleSignals) {
                Application.destroyOnInterrupt();
            }
            status = this.run((String[])argHolder.value);
        }
        catch (LocalException ex) {
            Util.getProcessLogger().error(Ex.toString(ex));
            status = 1;
        }
        catch (Exception ex) {
            Util.getProcessLogger().error("unknown exception: " + Ex.toString(ex));
            status = 1;
        }
        catch (Error err) {
            Util.getProcessLogger().error("Java error: " + Ex.toString(err));
            status = 1;
        }
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Application.defaultInterrupt();
        }
        Object err = _mutex;
        synchronized (err) {
            boolean interrupted = false;
            while (_callbackInProgress) {
                try {
                    _mutex.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (_destroyed) {
                _communicator = null;
            } else {
                _destroyed = true;
            }
        }
        if (_communicator != null) {
            try {
                try {
                    _communicator.destroy();
                }
                catch (OperationInterruptedException ex) {
                    Util.getProcessLogger().error(Ex.toString(ex));
                    _communicator.destroy();
                }
            }
            catch (LocalException ex) {
                Util.getProcessLogger().error(Ex.toString(ex));
                status = 1;
            }
            catch (Exception ex) {
                Util.getProcessLogger().error("unknown exception: " + Ex.toString(ex));
                status = 1;
            }
            _communicator = null;
        }
        Object object = _mutex;
        synchronized (object) {
            if (_appHook != null) {
                _appHook.done();
            }
        }
        return status;
    }

    public abstract int run(String[] var1);

    public static String appName() {
        return _appName;
    }

    public static Communicator communicator() {
        return _communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyOnInterrupt() {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Object object = _mutex;
            synchronized (object) {
                block6: {
                    try {
                        Application.changeHook(new DestroyHook());
                    }
                    catch (IllegalStateException ex) {
                        if (_communicator == null) break block6;
                        _communicator.destroy();
                    }
                }
            }
        }
        Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownOnInterrupt() {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Object object = _mutex;
            synchronized (object) {
                block6: {
                    try {
                        Application.changeHook(new ShutdownHook());
                    }
                    catch (IllegalStateException ex) {
                        if (_communicator == null) break block6;
                        _communicator.shutdown();
                    }
                }
            }
        }
        Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
    }

    public static void setInterruptHook(Thread newHook) {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            try {
                Application.changeHook(new CustomHook(newHook));
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
        }
    }

    public static void defaultInterrupt() {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Application.changeHook(null);
        } else {
            Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean interrupted() {
        Object object = _mutex;
        synchronized (object) {
            return _interrupted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeHook(AppHook newHook) {
        Object object = _mutex;
        synchronized (object) {
            try {
                if (_appHook != null) {
                    Runtime.getRuntime().removeShutdownHook(_appHook);
                    _appHook.done();
                    _appHook = null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (newHook != null) {
                Runtime.getRuntime().addShutdownHook(newHook);
                _appHook = newHook;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setCallbackInProgress(boolean destroy) {
        Object object = _mutex;
        synchronized (object) {
            if (_destroyed) {
                return false;
            }
            _callbackInProgress = true;
            _destroyed = destroy;
            _interrupted = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCallbackInProgress() {
        Object object = _mutex;
        synchronized (object) {
            _callbackInProgress = false;
            _mutex.notify();
        }
    }

    static {
        _mutex = new Object();
        _callbackInProgress = false;
        _destroyed = false;
        _interrupted = false;
        _signalPolicy = SignalPolicy.HandleSignals;
    }

    static class CustomHook
    extends AppHook {
        private Thread _hook;

        CustomHook(Thread hook) {
            this._hook = hook;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(false)) {
                    return;
                }
                this._hook.run();
                Application.clearCallbackInProgress();
            }
        }
    }

    static class ShutdownHook
    extends AppHook {
        ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(false)) {
                    return;
                }
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.shutdown();
                }
                Application.clearCallbackInProgress();
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    static class DestroyHook
    extends AppHook {
        DestroyHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(true)) {
                    return;
                }
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.destroy();
                }
                Application.clearCallbackInProgress();
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    public static class AppHook
    extends Thread {
        protected boolean _done = false;
        protected final Object _doneMutex = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            Object object = this._doneMutex;
            synchronized (object) {
                this._done = true;
                this._doneMutex.notify();
            }
        }
    }
}

