/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.ConnectionI;
import Ice.ContextHelper;
import Ice.EncodingVersion;
import Ice.Exception;
import Ice.FacetNotExistException;
import Ice.FormatType;
import Ice.Identity;
import Ice.ImplicitContextI;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownReplyStatusException;
import Ice.UnknownUserException;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.CallbackBase;
import IceInternal.CollocatedRequestHandler;
import IceInternal.ObserverHelper;
import IceInternal.Protocol;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.Reference;
import IceInternal.RetryException;
import java.util.HashMap;
import java.util.Map;

public class OutgoingAsync
extends ProxyOutgoingAsyncBase {
    private final EncodingVersion _encoding;
    private BasicStream _is;
    private boolean _synchronous;
    private static final Map<String, String> _emptyContext = new HashMap<String, String>();

    public static OutgoingAsync check(AsyncResult r, ObjectPrx prx, String operation) {
        ProxyOutgoingAsyncBase.checkImpl(r, prx, operation);
        try {
            return (OutgoingAsync)r;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Incorrect AsyncResult object for end_" + operation + " method");
        }
    }

    public OutgoingAsync(ObjectPrx prx, String operation, CallbackBase cb) {
        super((ObjectPrxHelperBase)prx, operation, cb);
        this._encoding = Protocol.getCompatibleEncoding(this._proxy.__reference().getEncoding());
        this._is = null;
    }

    public OutgoingAsync(ObjectPrx prx, String operation, CallbackBase cb, BasicStream is, BasicStream os) {
        super((ObjectPrxHelperBase)prx, operation, cb, os);
        this._encoding = Protocol.getCompatibleEncoding(this._proxy.__reference().getEncoding());
        this._is = is;
    }

    public void prepare(String operation, OperationMode mode, Map<String, String> ctx, boolean explicitCtx, boolean synchronous) {
        Protocol.checkSupportedProtocol(Protocol.getCompatibleProtocol(this._proxy.__reference().getProtocol()));
        this._mode = mode;
        this._synchronous = synchronous;
        if (explicitCtx && ctx == null) {
            ctx = _emptyContext;
        }
        this._observer = ObserverHelper.get(this._proxy, operation, ctx);
        switch (this._proxy.__reference().getMode()) {
            case 0: 
            case 1: 
            case 3: {
                this._os.writeBlob(Protocol.requestHdr);
                break;
            }
            case 2: 
            case 4: {
                this._proxy.__getBatchRequestQueue().prepareBatchRequest(this._os);
            }
        }
        Reference ref = this._proxy.__reference();
        ref.getIdentity().__write(this._os);
        String facet = ref.getFacet();
        if (facet == null || facet.length() == 0) {
            this._os.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{facet};
            this._os.writeStringSeq(facetPath);
        }
        this._os.writeString(operation);
        this._os.writeByte((byte)mode.value());
        if (ctx != null) {
            ContextHelper.write(this._os, ctx);
        } else {
            ImplicitContextI implicitContext = ref.getInstance().getImplicitContext();
            Map<String, String> prxContext = ref.getContext();
            if (implicitContext == null) {
                ContextHelper.write(this._os, prxContext);
            } else {
                implicitContext.write(prxContext, this._os);
            }
        }
    }

    @Override
    public boolean sent() {
        return this.sent(!this._proxy.ice_isTwoway());
    }

    @Override
    public int invokeRemote(ConnectionI connection, boolean compress, boolean response) throws RetryException {
        this._cachedConnection = connection;
        return connection.sendAsyncRequest(this, compress, response, 0);
    }

    @Override
    public int invokeCollocated(CollocatedRequestHandler handler) {
        if (!this._proxy.ice_isTwoway() || this._proxy.__reference().getInvocationTimeout() > 0) {
            this._state = (byte)(this._state | 0x10);
        }
        return handler.invokeAsyncRequest(this, 0, this._synchronous);
    }

    @Override
    public void abort(Exception ex) {
        int mode = this._proxy.__reference().getMode();
        if (mode == 2 || mode == 4) {
            this._proxy.__getBatchRequestQueue().abortBatchRequest(this._os);
        }
        super.abort(ex);
    }

    public void invoke() {
        int mode = this._proxy.__reference().getMode();
        if (mode == 2 || mode == 4) {
            this._sentSynchronously = true;
            this._proxy.__getBatchRequestQueue().finishBatchRequest(this._os, this._proxy, this.getOperation());
            this.finished(true);
        } else {
            this.invokeImpl(true);
        }
    }

    @Override
    public final boolean completed(BasicStream is) {
        assert (this._proxy.ice_isTwoway());
        if (this._childObserver != null) {
            this._childObserver.reply(is.size() - 14 - 4);
            this._childObserver.detach();
            this._childObserver = null;
        }
        try {
            if (this._is == null) {
                this._is = new BasicStream(this._instance, Protocol.currentProtocolEncoding);
            }
            this._is.swap(is);
            byte replyStatus = this._is.readByte();
            switch (replyStatus) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this._observer == null) break;
                    this._observer.userException();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    String facet;
                    Identity id = new Identity();
                    id.__read(this._is);
                    String[] facetPath = this._is.readStringSeq();
                    if (facetPath.length > 0) {
                        if (facetPath.length > 1) {
                            throw new MarshalException();
                        }
                        facet = facetPath[0];
                    } else {
                        facet = "";
                    }
                    String operation = this._is.readString();
                    RequestFailedException ex = null;
                    switch (replyStatus) {
                        case 2: {
                            ex = new ObjectNotExistException();
                            break;
                        }
                        case 3: {
                            ex = new FacetNotExistException();
                            break;
                        }
                        case 4: {
                            ex = new OperationNotExistException();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ex.id = id;
                    ex.facet = facet;
                    ex.operation = operation;
                    throw ex;
                }
                case 5: 
                case 6: 
                case 7: {
                    String unknown = this._is.readString();
                    UnknownException ex = null;
                    switch (replyStatus) {
                        case 7: {
                            ex = new UnknownException();
                            break;
                        }
                        case 5: {
                            ex = new UnknownLocalException();
                            break;
                        }
                        case 6: {
                            ex = new UnknownUserException();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    ex.unknown = unknown;
                    throw ex;
                }
                default: {
                    throw new UnknownReplyStatusException();
                }
            }
            return this.finished(replyStatus == 0);
        }
        catch (Exception ex) {
            return this.completed(ex);
        }
    }

    public BasicStream startWriteParams(FormatType format) {
        this._os.startWriteEncaps(this._encoding, format);
        return this._os;
    }

    public void endWriteParams() {
        this._os.endWriteEncaps();
    }

    public void writeEmptyParams() {
        this._os.writeEmptyEncaps(this._encoding);
    }

    public void writeParamEncaps(byte[] encaps) {
        if (encaps == null || encaps.length == 0) {
            this._os.writeEmptyEncaps(this._encoding);
        } else {
            this._os.writeEncaps(encaps);
        }
    }

    public BasicStream startReadParams() {
        this._is.startReadEncaps();
        return this._is;
    }

    public void endReadParams() {
        this._is.endReadEncaps();
    }

    public void readEmptyParams() {
        this._is.skipEmptyEncaps();
    }

    public byte[] readParamEncaps() {
        return this._is.readEncaps(null);
    }

    public final void throwUserException() throws UserException {
        try {
            this._is.startReadEncaps();
            this._is.throwException(null);
        }
        catch (UserException ex) {
            this._is.endReadEncaps();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheMessageBuffers() {
        if (this._proxy.__reference().getInstance().cacheMessageBuffers() > 0) {
            OutgoingAsync outgoingAsync = this;
            synchronized (outgoingAsync) {
                if ((this._state & 0x10) > 0) {
                    return;
                }
                this._state = (byte)(this._state | 0x10);
            }
            if (this._is != null) {
                this._is.reset();
            }
            this._os.reset();
            this._proxy.cacheMessageBuffers(this._is, this._os);
            this._is = null;
            this._os = null;
        }
    }
}

