/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.File;
import java.io.FileWriter;
import java.util.prefs.BackingStoreException;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;

public class IniFile
extends IniPreferences {
    private final File _file;
    private final Mode _mode;

    public IniFile(File file) throws BackingStoreException {
        this(file, Mode.RO);
    }

    public IniFile(File file, Mode mode) throws BackingStoreException {
        super(new Ini());
        this._file = file;
        this._mode = mode;
        if (this._mode == Mode.RO || this._mode != Mode.WO && this._file.exists()) {
            this.sync();
        }
    }

    public File getFile() {
        return this._file;
    }

    public Mode getMode() {
        return this._mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws BackingStoreException {
        if (this._mode == Mode.RO) {
            throw new BackingStoreException("read only instance");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                FileWriter writer = new FileWriter(this._file);
                try {
                    this.getIni().store(writer);
                }
                finally {
                    writer.close();
                }
            }
        }
        catch (Exception x) {
            throw new BackingStoreException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws BackingStoreException {
        if (this._mode == Mode.WO) {
            throw new BackingStoreException("write only instance");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.getIni().load(this._file.toURI().toURL());
            }
        }
        catch (Exception x) {
            throw new BackingStoreException(x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        RO,
        WO,
        RW;

    }
}

