/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Image;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CellVoyagerReader
extends FormatReader {
    private static final String SINGLE_TIFF_PATH_BUILDER = "W%dF%03dT%04dZ%02dC%d.tif";
    private String imageFolder;
    private List<ChannelInfo> channelInfos;
    private List<WellInfo> wells;
    private List<Integer> timePoints;
    private String measurementResultFile;
    private String omeMeasurementFile;

    public CellVoyagerReader() {
        super("CellVoyager", new String[]{"tif", "xml"});
        this.hasCompanionFiles = true;
        this.datasetDescription = "Directory with 2 master files 'MeasurementResult.xml' and 'MeasurementResult.ome.xml', used to stitch together several TIF files.";
        this.domains = new String[]{"Histology", "Light Microscopy", "High-Content Screening (HCS)"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        CoreMetadata cm = (CoreMetadata)this.core.get(this.getSeries());
        int[] zct = this.getZCTCoords(no);
        int[] indices = this.seriesToWellArea(this.getSeries());
        int wellIndex = indices[0];
        int areaIndex = indices[1];
        WellInfo well = this.wells.get(wellIndex);
        AreaInfo area = well.areas.get(areaIndex);
        MinimalTiffReader tiffReader = new MinimalTiffReader();
        for (FieldInfo field : area.fields) {
            String filename = String.format(SINGLE_TIFF_PATH_BUILDER, wellIndex + 1, field.index, zct[2] + 1, zct[0] + 1, zct[1] + 1);
            Location image = new Location(this.imageFolder, filename);
            if (!image.exists()) {
                LOGGER.warn("Could not find file {}", (Object)image);
                continue;
            }
            try {
                tiffReader.setId(image.getAbsolutePath());
                int tw = this.channelInfos.get((int)0).tileWidth;
                int th = this.channelInfos.get((int)0).tileHeight;
                int xbs0 = (int)field.xpixels;
                int ybs0 = (int)field.ypixels;
                if (x + w < xbs0 || xbs0 + tw < x || y + h < ybs0 || ybs0 + th < y) continue;
                int xs0 = Math.max(xbs0 - x, 0);
                int ys0 = Math.max(ybs0 - y, 0);
                int xs1 = Math.max(x - xbs0, 0);
                int ys1 = Math.max(y - ybs0, 0);
                int xe1 = Math.min(tw, x + w - xbs0);
                int ye1 = Math.min(th, y + h - ybs0);
                int w1 = xe1 - xs1;
                int h1 = ye1 - ys1;
                if (w1 <= 0 || h1 <= 0) continue;
                byte[] bytes = tiffReader.openBytes(0, xs1, ys1, w1, h1);
                int nbpp = cm.bitsPerPixel / 8;
                for (int row1 = 0; row1 < h1; ++row1) {
                    int ls1 = nbpp * (row1 * w1);
                    int length = nbpp * w1;
                    int ls0 = nbpp * ((ys0 + row1) * w + xs0);
                    System.arraycopy(bytes, ls1, buf, ls0, length);
                }
            }
            finally {
                tiffReader.close();
            }
        }
        return buf;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 0;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        String localName = new Location(name).getName();
        if (localName.equals("MeasurementResult.xml")) {
            return true;
        }
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        Location xml = new Location(parent, "MeasurementResult.xml");
        if (!xml.exists() && parent != null) {
            if (parent.getParent() == null) {
                return false;
            }
            xml = new Location(parent.getParentFile(), "MeasurementResult.xml");
            if (!xml.exists()) {
                return false;
            }
        }
        return super.isThisType(name, open);
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        Location measurementFolder = new Location(id).getAbsoluteFile();
        if (!measurementFolder.exists()) {
            throw new IOException("File " + id + " does not exist.");
        }
        if (!measurementFolder.isDirectory() && (measurementFolder = measurementFolder.getParentFile()).getName().equals("Image")) {
            measurementFolder = measurementFolder.getParentFile();
        }
        this.imageFolder = new Location(measurementFolder, "Image").getAbsolutePath();
        Location measurementResult = new Location(measurementFolder, "MeasurementResult.xml");
        if (!measurementResult.exists()) {
            throw new IOException("Could not find " + measurementResult + " in folder.");
        }
        this.measurementResultFile = measurementResult.getAbsolutePath();
        Location omeMeasurement = new Location(measurementFolder, "MeasurementResult.ome.xml");
        if (!omeMeasurement.exists()) {
            throw new IOException("Could not find " + omeMeasurement + " in folder.");
        }
        this.omeMeasurementFile = omeMeasurement.getAbsolutePath();
        Document msDocument = null;
        try (RandomAccessInputStream result = new RandomAccessInputStream(this.measurementResultFile);){
            msDocument = XMLTools.parseDOM(result);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        msDocument.getDocumentElement().normalize();
        String fileVersionMajor = CellVoyagerReader.getChildText(msDocument.getDocumentElement(), new String[]{"FileVersion", "Major"});
        String fileVersionMinor = CellVoyagerReader.getChildText(msDocument.getDocumentElement(), new String[]{"FileVersion", "Miner"});
        if (!fileVersionMajor.equals("1") || !fileVersionMinor.equals("0")) {
            LOGGER.warn("Detected a file version " + fileVersionMajor + "." + fileVersionMinor + ". This reader was built by reverse-engineering v1.0 files only. Errors might occur.");
        }
        Document omeDocument = null;
        try (RandomAccessInputStream measurement = new RandomAccessInputStream(this.omeMeasurementFile);){
            omeDocument = XMLTools.parseDOM(measurement);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        omeDocument.getDocumentElement().normalize();
        this.readInfo(msDocument, omeDocument);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (noPixels) {
            return new String[]{this.measurementResultFile, this.omeMeasurementFile};
        }
        int[] indices = this.seriesToWellArea(this.getSeries());
        int wellIndex = indices[0];
        int areaIndex = indices[1];
        AreaInfo area = this.wells.get((int)wellIndex).areas.get(areaIndex);
        int nFields = area.fields.size();
        ArrayList<String> images = new ArrayList<String>();
        images.add(this.measurementResultFile);
        images.add(this.omeMeasurementFile);
        for (Integer timepoint : this.timePoints) {
            for (int zslice = 1; zslice <= this.getSizeZ(); ++zslice) {
                for (int channel = 1; channel <= this.getSizeC(); ++channel) {
                    for (FieldInfo field : area.fields) {
                        String relativePath = String.format(SINGLE_TIFF_PATH_BUILDER, wellIndex + 1, field.index, timepoint, zslice, channel);
                        Location imageFile = new Location(this.imageFolder, relativePath);
                        if (!imageFile.exists()) continue;
                        images.add(imageFile.getAbsolutePath());
                    }
                }
            }
        }
        return images.toArray(new String[images.size()]);
    }

    private int[] seriesToWellArea(int series) {
        int nWell = -1;
        int seriesInc = -1;
        for (WellInfo well : this.wells) {
            ++nWell;
            int nAreas = -1;
            for (AreaInfo area : well.areas) {
                ++nAreas;
                if (series != ++seriesInc) continue;
                return new int[]{nWell, nAreas};
            }
        }
        throw new IllegalStateException("Cannot find a well for series " + series);
    }

    private void readInfo(Document msDocument, Document omeDocument) throws FormatException {
        double objectiveMagnification;
        Element msRoot = msDocument.getDocumentElement();
        double magnification = objectiveMagnification = Double.parseDouble(CellVoyagerReader.getChildText(msRoot, new String[]{"ObjectiveLens", "Magnification"}));
        NodeList nodeList = omeDocument.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap atts;
            Node namedItem;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (namedItem = (atts = node.getAttributes()).getNamedItem("ID")) != null) continue;
            String name = node.getNodeName();
            String id = name + ":" + i;
            if (node.getParentNode().getNodeName().equals("LightSource")) continue;
            ((Element)node).setAttribute("ID", id);
        }
        String[] stringArray = new String[]{"Image", "Pixels"};
        Element pszEl = CellVoyagerReader.getChild(omeDocument.getDocumentElement(), stringArray);
        double physicalSizeZ = Double.parseDouble(pszEl.getAttribute("PhysicalSizeZ"));
        if (physicalSizeZ <= 0.0) {
            pszEl.setAttribute("PhysicalSizeZ", "1");
        }
        OMEXMLService service = null;
        String xml = null;
        try {
            xml = XMLTools.getXML(omeDocument);
        }
        catch (TransformerConfigurationException e2) {
            LOGGER.debug("", (Throwable)e2);
        }
        catch (TransformerException e2) {
            LOGGER.debug("", (Throwable)e2);
        }
        try {
            service = new ServiceFactory().getInstance(OMEXMLService.class);
        }
        catch (DependencyException e1) {
            LOGGER.debug("", (Throwable)e1);
        }
        OMEXMLMetadata omeMD = null;
        try {
            omeMD = service.createOMEXMLMetadata(xml);
        }
        catch (ServiceException e) {
            LOGGER.debug("", (Throwable)e);
        }
        catch (NullPointerException npe) {
            LOGGER.debug("", (Throwable)npe);
            throw npe;
        }
        omeMD.setPixelsPhysicalSizeX(FormatTools.createLength((Double)(omeMD.getPixelsPhysicalSizeX(0).value().doubleValue() / magnification), (Unit)omeMD.getPixelsPhysicalSizeX(0).unit()), 0);
        omeMD.setPixelsPhysicalSizeY(FormatTools.createLength((Double)(omeMD.getPixelsPhysicalSizeY(0).value().doubleValue() / magnification), (Unit)omeMD.getPixelsPhysicalSizeY(0).unit()), 0);
        if (Double.valueOf(this.readFrameInterval(msDocument)) != null) {
            omeMD.setPixelsTimeIncrement(new Time((Number)this.readFrameInterval(msDocument), UNITS.SECOND), 0);
        }
        Element channelsEl = CellVoyagerReader.getChild(msRoot, "Channels");
        List<Element> channelEls = CellVoyagerReader.getChildren(channelsEl, "Channel");
        this.channelInfos = new ArrayList<ChannelInfo>();
        for (Element channelEl : channelEls) {
            boolean isEnabled = Boolean.parseBoolean(CellVoyagerReader.getChildText(channelEl, "IsEnabled"));
            if (!isEnabled) continue;
            ChannelInfo ci = this.readChannel(channelEl);
            this.channelInfos.add(ci);
        }
        Element containerEl = CellVoyagerReader.getChild(msRoot, new String[]{"Attachment", "HolderInfoList", "HolderInfo", "MountedSampleContainer"});
        String type = containerEl.getAttribute("xsi:type");
        boolean plateMetadata = type.equals("WellPlate");
        if (plateMetadata) {
            omeMD.setScreenID(MetadataTools.createLSID((String)"Screen", (int[])new int[]{0}), 0);
            omeMD.setPlateID(MetadataTools.createLSID((String)"Plate", (int[])new int[]{0}), 0);
        } else {
            OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omeMD.getRoot();
            root.removeScreen(root.getScreen(0));
            root.removePlate(root.getPlate(0));
            omeMD.setRoot((MetadataRoot)root);
        }
        omeMD.setProjectID(MetadataTools.createLSID((String)"Project", (int[])new int[]{0}), 0);
        omeMD.setInstrumentID(MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0}), 0);
        double pixelWidth = omeMD.getPixelsPhysicalSizeX(0).value().doubleValue();
        double pixelHeight = omeMD.getPixelsPhysicalSizeY(0).value().doubleValue();
        int tileWidth = this.channelInfos.get((int)0).tileWidth;
        int tileHeight = this.channelInfos.get((int)0).tileHeight;
        boolean sameAreaPerWell = Boolean.parseBoolean(CellVoyagerReader.getChildText(msRoot, "UsesSameAreaParWell"));
        ArrayList<AreaInfo> areas = null;
        if (sameAreaPerWell) {
            Element areasEl = CellVoyagerReader.getChild(msRoot, new String[]{"SameAreaUsingWell", "Areas"});
            List<Element> areaEls = CellVoyagerReader.getChildren(areasEl, "Area");
            int areaIndex = 0;
            areas = new ArrayList<AreaInfo>(areaEls.size());
            int fieldIndex = 1;
            for (Element areaEl : areaEls) {
                AreaInfo area = this.readArea(areaEl, fieldIndex, pixelWidth, pixelHeight, tileWidth, tileHeight);
                area.index = areaIndex++;
                areas.add(area);
                fieldIndex = area.fields.get((int)(area.fields.size() - 1)).index + 1;
            }
        }
        Element wellsEl = CellVoyagerReader.getChild(msRoot, "Wells");
        List<Element> wellEls = CellVoyagerReader.getChildren(wellsEl, "Well");
        this.wells = new ArrayList<WellInfo>();
        for (Element wellEl : wellEls) {
            boolean isWellEnabled = Boolean.parseBoolean(CellVoyagerReader.getChild(wellEl, "IsEnabled").getTextContent());
            if (!isWellEnabled) continue;
            WellInfo wi = this.readWellInfo(wellEl, pixelWidth, pixelHeight, tileWidth, tileHeight);
            if (sameAreaPerWell) {
                wi.areas = areas;
            }
            this.wells.add(wi);
        }
        int nZSlices = Integer.parseInt(CellVoyagerReader.getChildText(msRoot, new String[]{"ZStackConditions", "NumberOfSlices"}));
        this.timePoints = this.readTimePoints(msDocument);
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)omeMD.getRoot();
        Image firstImage = root.getImage(0);
        this.core.clear();
        for (WellInfo well : this.wells) {
            for (AreaInfo area : well.areas) {
                CoreMetadata ms = new CoreMetadata();
                this.core.add(ms);
                if (this.core.size() > 1) {
                    root.addImage(firstImage);
                }
                ms.sizeX = area.width;
                ms.sizeY = area.height;
                ms.sizeZ = nZSlices;
                ms.sizeC = this.channelInfos.size();
                ms.sizeT = this.timePoints.size();
                ms.dimensionOrder = "XYCZT";
                ms.rgb = false;
                ms.imageCount = nZSlices * this.channelInfos.size() * this.timePoints.size();
                switch (omeMD.getPixelsType(0)) {
                    case UINT8: {
                        ms.pixelType = 1;
                        ms.bitsPerPixel = 8;
                        break;
                    }
                    case UINT16: {
                        ms.pixelType = 3;
                        ms.bitsPerPixel = 16;
                        break;
                    }
                    case UINT32: {
                        ms.pixelType = 5;
                        ms.bitsPerPixel = 32;
                        break;
                    }
                    default: {
                        throw new FormatException("Cannot read image with pixel type = " + omeMD.getPixelsType(0));
                    }
                }
                ms.littleEndian = true;
            }
        }
        omeMD.setRoot((MetadataRoot)root);
        MetadataStore store = this.makeFilterMetadata();
        MetadataConverter.convertMetadata((MetadataRetrieve)omeMD, (ome.xml.meta.MetadataStore)store);
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        double pinholeSize = Double.parseDouble(CellVoyagerReader.getChildText(msRoot, new String[]{"PinholeDisk", "PinholeSize_um"}));
        if (plateMetadata) {
            int nrows = Integer.parseInt(CellVoyagerReader.getChildText(containerEl, "RowCount"));
            int ncols = Integer.parseInt(CellVoyagerReader.getChildText(containerEl, "ColumnCount"));
            store.setPlateRows(new PositiveInteger(Integer.valueOf(nrows)), 0);
            store.setPlateColumns(new PositiveInteger(Integer.valueOf(ncols)), 0);
            String plateAcqID = MetadataTools.createLSID((String)"PlateAcquisition", (int[])new int[]{0, 0});
            store.setPlateAcquisitionID(plateAcqID, 0, 0);
            Element dimInfoEl = CellVoyagerReader.getChild(msRoot, "DimensionsInfo");
            int maxNFields = Integer.parseInt(CellVoyagerReader.getChild(dimInfoEl, "F").getAttribute("Max"));
            PositiveInteger fieldCount = FormatTools.getMaxFieldCount((Integer)maxNFields);
            if (fieldCount != null) {
                store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
            }
            String beginTime = CellVoyagerReader.getChildText(msRoot, "BeginTime");
            String endTime = CellVoyagerReader.getChildText(msRoot, "EndTime");
            store.setPlateAcquisitionStartTime(new Timestamp(beginTime), 0, 0);
            store.setPlateAcquisitionEndTime(new Timestamp(endTime), 0, 0);
            store.setPlateName(beginTime, 0);
        } else if (!type.equals("PreparedSlide")) {
            LOGGER.warn("Unexpected acquisition type: {}", (Object)type);
        }
        int seriesIndex = -1;
        int wellIndex = -1;
        for (WellInfo well : this.wells) {
            ++wellIndex;
            int wellNumber = well.number;
            if (plateMetadata) {
                store.setWellID(MetadataTools.createLSID((String)"Well", (int[])new int[]{0, wellIndex}), 0, wellIndex);
                store.setWellRow(new NonNegativeInteger(Integer.valueOf(well.row)), 0, wellIndex);
                store.setWellColumn(new NonNegativeInteger(Integer.valueOf(well.col)), 0, wellIndex);
            }
            int areaIndex = -1;
            for (AreaInfo area : well.areas) {
                String imageID = MetadataTools.createLSID((String)"Image", (int[])new int[]{++seriesIndex});
                store.setImageID(imageID, seriesIndex);
                String imageName = "Well " + wellNumber + " (UID=" + well.UID + ", r=" + well.row + ", c=" + well.col + ") - Area " + ++areaIndex;
                store.setImageName(imageName, seriesIndex);
                if (plateMetadata) {
                    Length posX = new Length((Number)well.centerX, UNITS.REFERENCEFRAME);
                    Length posY = new Length((Number)well.centerY, UNITS.REFERENCEFRAME);
                    String wellSample = MetadataTools.createLSID((String)"WellSample", (int[])new int[]{0, wellIndex, areaIndex});
                    store.setWellSampleID(wellSample, 0, wellIndex, areaIndex);
                    store.setWellSampleImageRef(imageID, 0, wellIndex, areaIndex);
                    store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(area.index)), 0, wellIndex, areaIndex);
                    store.setWellSamplePositionX(posX, 0, wellIndex, areaIndex);
                    store.setWellSamplePositionY(posY, 0, wellIndex, areaIndex);
                    store.setPlateAcquisitionWellSampleRef(wellSample, 0, 0, seriesIndex);
                }
                store.setImageInstrumentRef(MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0}), seriesIndex);
                for (int i = 0; i < this.channelInfos.size(); ++i) {
                    store.setChannelPinholeSize(new Length((Number)pinholeSize, UNITS.MICROMETER), seriesIndex, i);
                    store.setChannelName(this.channelInfos.get((int)i).name, seriesIndex, i);
                    store.setChannelColor(this.channelInfos.get((int)i).color, seriesIndex, i);
                }
            }
        }
    }

    private ChannelInfo readChannel(Element channelEl) {
        String channelName;
        Color channelColor;
        ChannelInfo ci = new ChannelInfo();
        ci.isEnabled = Boolean.parseBoolean(CellVoyagerReader.getChildText(channelEl, "IsEnabled"));
        ci.channelNumber = Integer.parseInt(CellVoyagerReader.getChildText(channelEl, "Number"));
        Element acquisitionSettings = CellVoyagerReader.getChild(channelEl, "AcquisitionSetting");
        Element cameraEl = CellVoyagerReader.getChild(acquisitionSettings, "Camera");
        ci.tileWidth = Integer.parseInt(CellVoyagerReader.getChildText(cameraEl, "EffectiveHorizontalPixels_pixel"));
        ci.tileHeight = Integer.parseInt(CellVoyagerReader.getChildText(cameraEl, "EffectiveVerticalPixels_pixel"));
        ci.unmagnifiedPixelWidth = Double.parseDouble(CellVoyagerReader.getChildText(cameraEl, "HorizonalCellSize_um"));
        ci.unmagnifiedPixelHeight = Double.parseDouble(CellVoyagerReader.getChildText(cameraEl, "VerticalCellSize_um"));
        Element colorElement = CellVoyagerReader.getChild(channelEl, new String[]{"ContrastEnhanceParam", "Color"});
        int r = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "R"));
        int g = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "G"));
        int b = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "B"));
        int a = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "A"));
        ci.color = channelColor = new Color(r, g, b, a);
        String excitationType = CellVoyagerReader.getChild(channelEl, "Excitation").getAttribute("xsi:type");
        String excitationName = CellVoyagerReader.getChildText(channelEl, new String[]{"Excitation", "Name", "Value"});
        String emissionName = CellVoyagerReader.getChildText(channelEl, new String[]{"Emission", "Name", "Value"});
        String fluorophoreName = CellVoyagerReader.getChildText(channelEl, new String[]{"Emission", "FluorescentProbe", "Value"});
        if (null == fluorophoreName) {
            fluorophoreName = "\u00f8";
        }
        ci.name = channelName = "Ex: " + excitationType + "(" + excitationName + ") / Em: " + emissionName + " / Fl: " + fluorophoreName;
        return ci;
    }

    private WellInfo readWellInfo(Element wellEl, double pixelWidth, double pixelHeight, int tileWidth, int tileHeight) {
        WellInfo info = new WellInfo();
        info.UID = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "UniqueID"));
        info.number = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "Number"));
        info.row = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "Row"));
        info.col = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "Column"));
        info.centerX = Double.parseDouble(CellVoyagerReader.getChildText(wellEl, new String[]{"CenterCoord_mm", "X"}));
        info.centerY = Double.parseDouble(CellVoyagerReader.getChildText(wellEl, new String[]{"CenterCoord_mm", "Y"}));
        Element areasEl = CellVoyagerReader.getChild(wellEl, "Areas");
        List<Element> areaEls = CellVoyagerReader.getChildren(areasEl, "Area");
        int areaIndex = 0;
        int fieldIndex = 1;
        for (Element areaEl : areaEls) {
            AreaInfo area = this.readArea(areaEl, fieldIndex, pixelWidth, pixelHeight, tileWidth, tileHeight);
            area.index = areaIndex++;
            info.areas.add(area);
            fieldIndex = area.fields.get((int)(area.fields.size() - 1)).index + 1;
        }
        return info;
    }

    private AreaInfo readArea(Element areaEl, int startingFieldIndex, double pixelWidth, double pixelHeight, int tileWidth, int tileHeight) {
        AreaInfo info = new AreaInfo();
        info.UID = Integer.parseInt(CellVoyagerReader.getChildText(areaEl, "UniqueID"));
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Element fieldsEl = CellVoyagerReader.getChild(areaEl, "Fields");
        List<Element> fieldEls = CellVoyagerReader.getChildren(fieldsEl, "Field");
        for (Element fieldEl : fieldEls) {
            double yum;
            FieldInfo finfo = this.readField(fieldEl);
            info.fields.add(finfo);
            double xum = finfo.x;
            if (xum < xmin) {
                xmin = xum;
            }
            if (xum > xmax) {
                xmax = xum;
            }
            if ((yum = -finfo.y) < ymin) {
                ymin = yum;
            }
            if (!(yum > ymax)) continue;
            ymax = yum;
        }
        for (FieldInfo finfo : info.fields) {
            long xpixels = Math.round((finfo.x - xmin) / pixelWidth);
            long ypixels = Math.round((-ymin - finfo.y) / pixelHeight);
            finfo.xpixels = xpixels;
            finfo.ypixels = ypixels;
            finfo.index = startingFieldIndex++;
        }
        int width = 1 + (int)((xmax - xmin) / pixelWidth);
        int height = 1 + (int)((ymax - ymin) / pixelHeight);
        info.width = width + tileWidth;
        info.height = height + tileHeight;
        return info;
    }

    private FieldInfo readField(Element fieldEl) {
        FieldInfo info = new FieldInfo();
        info.x = Double.parseDouble(CellVoyagerReader.getChildText(fieldEl, "StageX_um"));
        info.y = Double.parseDouble(CellVoyagerReader.getChildText(fieldEl, "StageY_um"));
        return info;
    }

    private List<Integer> readTimePoints(Document document) {
        Element root = document.getDocumentElement();
        int nTimePoints = Integer.parseInt(CellVoyagerReader.getChildText(root, new String[]{"TimelapsCondition", "Iteration"}));
        ArrayList<Integer> timepoints = new ArrayList<Integer>(nTimePoints);
        for (int i = 0; i < nTimePoints; ++i) {
            timepoints.add(i + 1);
        }
        return timepoints;
    }

    private double readFrameInterval(Document document) {
        Element root = document.getDocumentElement();
        double dt = Double.parseDouble(CellVoyagerReader.getChildText(root, new String[]{"TimelapsCondition", "Interval"}));
        return dt;
    }

    private static final Element getChild(Element parent, String childName) {
        return CellVoyagerReader.getChild(parent, new String[]{childName});
    }

    private static final Element getChild(Element parent, String[] path) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!item.getNodeName().equals(path[0])) continue;
            if (path.length == 1) {
                return (Element)item;
            }
            return CellVoyagerReader.getChild((Element)item, Arrays.copyOfRange(path, 1, path.length));
        }
        return null;
    }

    private static final List<Element> getChildren(Element parent, String name) {
        NodeList nodeList = parent.getElementsByTagName(name);
        int nEls = nodeList.getLength();
        ArrayList<Element> children = new ArrayList<Element>(nEls);
        for (int i = 0; i < nEls; ++i) {
            children.add((Element)nodeList.item(i));
        }
        return children;
    }

    private static final String getChildText(Element parent, String[] path) {
        Element child = CellVoyagerReader.getChild(parent, path);
        if (child != null) {
            return child.getTextContent();
        }
        return null;
    }

    private static final String getChildText(Element parent, String childName) {
        return CellVoyagerReader.getChildText(parent, new String[]{childName});
    }

    private static final class WellInfo {
        public List<AreaInfo> areas = new ArrayList<AreaInfo>();
        public double centerY;
        public double centerX;
        public int col;
        public int row;
        public int number;
        public int UID;

        private WellInfo() {
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("Well ID = " + this.UID + '\n');
            str.append("\tnumber = " + this.number + '\n');
            str.append("\trow = " + this.row + '\n');
            str.append("\tcol = " + this.col + '\n');
            str.append("\tcenter X = " + this.centerX + " mm\n");
            str.append("\tcenter Y = " + this.centerY + " mm\n");
            for (AreaInfo areaInfo : this.areas) {
                str.append(areaInfo.toString());
            }
            return str.toString();
        }
    }

    private static final class AreaInfo {
        public int index;
        public int height;
        public int width;
        public List<FieldInfo> fields = new ArrayList<FieldInfo>();
        public int UID;

        private AreaInfo() {
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("\tArea ID = " + this.UID + '\n');
            str.append("\t\ttotal width = " + this.width + " pixels\n");
            str.append("\t\ttotal height = " + this.height + " pixels\n");
            for (FieldInfo fieldInfo : this.fields) {
                str.append(fieldInfo.toString());
            }
            return str.toString();
        }
    }

    private static final class FieldInfo {
        public int index;
        public long ypixels;
        public long xpixels;
        public double y;
        public double x;

        private FieldInfo() {
        }

        public String toString() {
            return "\t\tField index = " + this.index + "\n\t\t\tX = " + this.x + " \u00b5m\n\t\t\tY = " + this.y + " \u00b5m\n\t\t\txi = " + this.xpixels + " pixels\n\t\t\tyi = " + this.ypixels + " pixels\n";
        }
    }

    private static final class ChannelInfo {
        public String name;
        public Color color;
        public int height;
        public int width;
        public boolean isEnabled;
        public double unmagnifiedPixelHeight;
        public double unmagnifiedPixelWidth;
        public int tileHeight;
        public int tileWidth;
        public int channelNumber;

        private ChannelInfo() {
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("Channel " + this.channelNumber + ": \n");
            str.append(" - name: " + this.name + "\n");
            str.append(" - isEnabled: " + this.isEnabled + "\n");
            str.append(" - width: " + this.width + "\n");
            str.append(" - height: " + this.height + "\n");
            str.append(" - tile width: " + this.tileWidth + "\n");
            str.append(" - tile height: " + this.tileHeight + "\n");
            str.append(" - unmagnifiedPixelWidth: " + this.unmagnifiedPixelWidth + "\n");
            str.append(" - unmagnifiedPixelHeight: " + this.unmagnifiedPixelHeight + "\n");
            return str.toString();
        }
    }
}

