/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.meta.MetadataStore;

public class LIMReader
extends FormatReader {
    private static final int PIXELS_OFFSET = 2379;
    private boolean isCompressed;

    public LIMReader() {
        super("Laboratory Imaging", "lim");
        this.domains = new String[]{"Light Microscopy"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(2379L);
        this.readPlane(this.in, x, y, w, h, buf);
        if (this.isRGB()) {
            for (int i = 0; i < buf.length / 3; ++i) {
                byte tmp = buf[i * 3];
                buf[i * 3] = buf[i * 3 + 2];
                buf[i * 3 + 2] = tmp;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.isCompressed = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        m.sizeX = this.in.readShort() & Short.MAX_VALUE;
        m.sizeY = this.in.readShort();
        int bits = this.in.readShort();
        while (bits % 8 != 0) {
            ++bits;
        }
        if (bits % 3 == 0) {
            m.sizeC = 3;
            bits /= 3;
        }
        m.pixelType = FormatTools.pixelTypeFromBytes((int)(bits / 8), (boolean)false, (boolean)false);
        this.isCompressed = this.in.readShort() != 0;
        this.addGlobalMeta("Is compressed", this.isCompressed);
        if (this.isCompressed) {
            throw new UnsupportedCompressionException("Compressed LIM files not supported.");
        }
        m.imageCount = 1;
        m.sizeZ = 1;
        m.sizeT = 1;
        if (this.getSizeC() == 0) {
            m.sizeC = 1;
        }
        m.rgb = this.getSizeC() > 1;
        m.dimensionOrder = "XYZCT";
        m.indexed = false;
        m.falseColor = false;
        m.interleaved = true;
        m.metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

