/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;

public class SimplePCITiffReader
extends BaseTiffReader {
    private static final String MAGIC_STRING = "Created by Hamamatsu Inc.";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final int CUSTOM_BITS = 65531;
    private MinimalTiffReader delegate;
    private String date;
    private Double magnification;
    private String immersion;
    private String cameraType;
    private String cameraName;
    private String binning;
    private ArrayList<Double> exposureTimes;
    private double scaling;

    public SimplePCITiffReader() {
        super("SimplePCI TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        String comment = tp.getComment();
        if (comment == null) {
            return false;
        }
        return comment.trim().startsWith(MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.getSizeC() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        byte[] b = this.delegate.openBytes(no / this.getSizeC(), x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int c = this.getZCTCoords(no)[1];
        ImageTools.splitChannels((byte[])b, (byte[])buf, (int)c, (int)this.getSizeC(), (int)bpp, (boolean)false, (boolean)this.isInterleaved(), (int)(w * h * bpp));
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.delegate != null) {
            this.delegate.close(fileOnly);
        }
        if (!fileOnly) {
            this.delegate = null;
            this.date = null;
            this.magnification = null;
            this.immersion = null;
            this.cameraType = null;
            this.cameraName = null;
            this.binning = null;
            this.exposureTimes = null;
            this.scaling = 0.0;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        String objective;
        int space;
        super.initStandardMetadata();
        this.delegate = new MinimalTiffReader();
        this.delegate.setId(this.currentId);
        this.exposureTimes = new ArrayList();
        String data = ((IFD)this.ifds.get(0)).getComment();
        data = data.substring(data.indexOf("\n") + 1);
        this.date = data.substring(0, data.indexOf("\n"));
        data = data.substring(data.indexOf("\n") + 1);
        data = data.replaceAll("ReadFromDoc", "");
        IniParser parser = new IniParser();
        parser.setCommentDelimiter(";");
        IniList ini = parser.parseINI(new BufferedReader(new StringReader(data)));
        IniTable microscopeTable = ini.getTable(" MICROSCOPE ");
        if (microscopeTable != null && (space = (objective = (String)microscopeTable.get("Objective")).indexOf(32)) != -1) {
            this.magnification = DataTools.parseDouble(objective.substring(0, space - 1));
            this.immersion = objective.substring(space + 1);
        }
        CoreMetadata m = (CoreMetadata)this.core.get(0, 0);
        IniTable cameraTable = ini.getTable(" CAPTURE DEVICE ");
        this.binning = (String)cameraTable.get("Binning") + "x" + (String)cameraTable.get("Binning");
        this.cameraType = (String)cameraTable.get("Camera Type");
        this.cameraName = (String)cameraTable.get("Camera Name");
        String displayDepth = (String)cameraTable.get("Display Depth");
        if (displayDepth != null) {
            m.bitsPerPixel = Integer.parseInt(displayDepth);
        } else {
            String bitDepth = (String)cameraTable.get("Bit Depth");
            if (bitDepth != null && bitDepth.length() > "-bit".length()) {
                bitDepth = bitDepth.substring(0, bitDepth.length() - "-bit".length());
                m.bitsPerPixel = Integer.parseInt(bitDepth);
            } else {
                throw new FormatException("Could not find bits per pixels");
            }
        }
        IniTable captureTable = ini.getTable(" CAPTURE ");
        if (captureTable != null) {
            int index = 1;
            for (int i = 0; i < this.getSizeC(); ++i) {
                if (captureTable.get("c_Filter" + index) != null) {
                    this.exposureTimes.add(DataTools.parseDouble((String)captureTable.get("c_Expos" + index)));
                }
                ++index;
            }
        }
        IniTable calibrationTable = ini.getTable(" CALIBRATION ");
        String units = (String)calibrationTable.get("units");
        this.scaling = Double.parseDouble((String)calibrationTable.get("factor"));
        m.imageCount *= this.getSizeC();
        m.rgb = false;
        if (((IFD)this.ifds.get(0)).containsKey((Object)65531)) {
            m.bitsPerPixel = ((IFD)this.ifds.get(0)).getIFDIntValue(65531);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            HashMap<String, String> iniMap = ini.flattenIntoHashMap();
            this.metadata.putAll(iniMap);
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        if (this.date != null) {
            this.date = DateTools.formatDate(this.date, DATE_FORMAT);
            if (this.date != null) {
                store.setImageAcquisitionDate(new Timestamp(this.date), 0);
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            store.setImageDescription(MAGIC_STRING, 0);
            Length sizeX = FormatTools.getPhysicalSizeX((Double)this.scaling);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)this.scaling);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            store.setObjectiveID(MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0}), 0, 0);
            store.setObjectiveNominalMagnification(this.magnification, 0, 0);
            store.setObjectiveImmersion(MetadataTools.getImmersion((String)this.immersion), 0, 0);
            String detector = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, 0});
            store.setDetectorID(detector, 0, 0);
            store.setDetectorModel(this.cameraType + " " + this.cameraName, 0, 0);
            store.setDetectorType(MetadataTools.getDetectorType((String)"CCD"), 0, 0);
            for (i = 0; i < this.getSizeC(); ++i) {
                store.setDetectorSettingsID(detector, 0, i);
                store.setDetectorSettingsBinning(MetadataTools.getBinning((String)this.binning), 0, i);
            }
            for (i = 0; i < this.getImageCount(); ++i) {
                int[] zct = this.getZCTCoords(i);
                if (zct[1] >= this.exposureTimes.size() || this.exposureTimes.get(zct[1]) == null) continue;
                store.setPlaneExposureTime(new Time((Number)(this.exposureTimes.get(zct[1]) / 1000000.0), UNITS.SECOND), 0, i);
            }
        }
    }
}

