/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;

public class TillVisionReader
extends FormatReader {
    private static final byte[] MARKER_0 = new byte[]{-128, 3, 0};
    private static final byte[] MARKER_1 = new byte[]{-127, 3, 0};
    private static final byte[] MARKER_2 = new byte[]{67, 73, 109, 97, 103, 101, 3, 0};
    private static final byte[] MARKER_3 = new byte[]{-125, 3, 0};
    private static final byte[] DESCRIPTION_MARKER = new byte[]{0, 0, 0, 0, 0, -1};
    private static final String[] DATE_FORMATS = new String[]{"mm/dd/yy HH:mm:ss aa", "mm/dd/yy HH:mm:ss aa", "mm/dd/yy", "HH:mm:ss aa", "HH:mm:ss aa"};
    private String[] pixelsFiles;
    private transient RandomAccessInputStream pixelsStream;
    private Map<Integer, Double> exposureTimes;
    private boolean embeddedImages;
    private long[] embeddedOffset;
    private String[] infFiles;
    private final List<String> imageNames = new ArrayList<String>();
    private final List<String> types = new ArrayList<String>();
    private final List<String> dates = new ArrayList<String>();

    public TillVisionReader() {
        super("TillVision", new String[]{"vws", "pst", "inf"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .vws file and possibly one similarly-named directory";
    }

    public boolean isThisType(String name, boolean open) {
        if (TillVisionReader.checkSuffix((String)name, (String)"vws") || TillVisionReader.checkSuffix((String)name, (String)"pst")) {
            return true;
        }
        String pstFile = name;
        if (name.indexOf(46) != -1) {
            pstFile = pstFile.substring(0, pstFile.lastIndexOf("."));
        }
        pstFile = pstFile + ".pst";
        return new Location(pstFile).exists();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int plane = FormatTools.getPlaneSize((IFormatReader)this);
        if (this.embeddedImages) {
            this.in.seek(this.embeddedOffset[this.getCoreIndex()] + (long)(no * plane));
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.pixelsStream = new RandomAccessInputStream(this.pixelsFiles[this.getCoreIndex()]);
            if ((long)((no + 1) * plane) <= this.pixelsStream.length()) {
                this.pixelsStream.seek(no * plane);
                this.readPlane(this.pixelsStream, x, y, w, h, buf);
            }
            this.pixelsStream.close();
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.pixelsStream != null) {
                this.pixelsStream.close();
            }
            this.pixelsStream = null;
            this.pixelsFiles = null;
            this.infFiles = null;
            this.embeddedOffset = null;
            this.embeddedImages = false;
            this.exposureTimes = null;
            this.imageNames.clear();
            this.types.clear();
            this.dates.clear();
        }
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return !new Location(id.replaceAll(".vws", ".pst")).exists();
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        if (!noPixels && this.pixelsFiles[this.getCoreIndex()] != null) {
            files.add(this.pixelsFiles[this.getCoreIndex()]);
        }
        if (this.infFiles[this.getCoreIndex()] != null) {
            files.add(this.infFiles[this.getCoreIndex()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void initFile(String id) throws FormatException, IOException {
        void var11_32;
        if (!TillVisionReader.checkSuffix((String)id, (String)"vws")) {
            Location pst = new Location(id).getAbsoluteFile();
            String name = pst.getParentFile().getName();
            Location parent = pst.getParentFile().getParentFile();
            Location vwsFile = new Location(parent, name.replaceAll(".pst", ".vws"));
            if (vwsFile.exists() && !vwsFile.isDirectory()) {
                id = vwsFile.getAbsolutePath();
            } else if (vwsFile.isDirectory()) {
                parent = pst.getParentFile();
                String[] list = parent.list(true);
                boolean foundVWS = false;
                for (Object object : list) {
                    if (!TillVisionReader.checkSuffix((String)object, (String)"vws")) continue;
                    id = new Location(parent, (String)object).getAbsolutePath();
                    foundVWS = true;
                    break;
                }
                if (!foundVWS) {
                    throw new FormatException("Could not find .vws file.");
                }
            } else {
                throw new FormatException("Could not find .vws file.");
            }
        }
        super.initFile(id);
        this.exposureTimes = new HashMap<Integer, Double>();
        POIService poi = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", (Throwable)de);
        }
        poi.initialize(id);
        Vector<String> documents = poi.getDocumentList();
        int nImages = 0;
        Hashtable tmpSeriesMetadata = new Hashtable();
        for (String name : documents) {
            LOGGER.debug("Reading {}", (Object)name);
            if (!name.equals("Root Entry" + File.separator + "Contents")) continue;
            RandomAccessInputStream s = poi.getDocumentStream(name);
            try {
                long offset;
                s.order(true);
                boolean specialCImage = false;
                int nFound = 0;
                Object var11_24 = null;
                Location dir = new Location(id).getAbsoluteFile().getParentFile();
                String[] list = dir.list(true);
                boolean hasPST = false;
                for (String f : list) {
                    if (!TillVisionReader.checkSuffix((String)f, (String)"pst")) continue;
                    hasPST = true;
                    break;
                }
                if (!hasPST) {
                    Long[] longArray = this.findImages(s);
                    nFound = longArray.length;
                    if (nFound == 0) {
                        s.seek(13L);
                        short len = s.readShort();
                        String type = s.readString(len);
                        if (type.equals("CImage")) {
                            nFound = 1;
                            Long[] longArray2 = new Long[]{s.getFilePointer() + 6L};
                            specialCImage = true;
                        }
                    }
                    this.embeddedImages = nFound > 0;
                }
                LOGGER.debug("Images are {}embedded", (Object)(this.embeddedImages ? "" : "not "));
                if (this.embeddedImages) {
                    this.core.clear();
                    this.embeddedOffset = new long[nFound];
                    for (int i = 0; i < nFound; ++i) {
                        void var11_28;
                        CoreMetadata ms = new CoreMetadata();
                        this.core.add(ms);
                        s.seek(var11_28[i].longValue());
                        int len = s.read();
                        String imageName = s.readString(len);
                        this.imageNames.add(imageName);
                        if (specialCImage) {
                            s.seek(1280L);
                        } else {
                            while (!s.readString(2).equals("sB")) {
                                s.seek(s.getFilePointer() - 1L);
                            }
                        }
                        s.skipBytes(20);
                        ms.sizeX = s.readInt();
                        ms.sizeY = s.readInt();
                        ms.sizeZ = s.readInt();
                        ms.sizeC = s.readInt();
                        ms.sizeT = s.readInt();
                        ms.pixelType = this.convertPixelType(s.readInt());
                        this.embeddedOffset[i] = specialCImage ? s.getFilePointer() + 27L : s.getFilePointer() + 31L;
                    }
                    if (this.in != null) {
                        this.in.close();
                    }
                    this.in = poi.getDocumentStream(name);
                    break;
                }
                s.seek(0L);
                int lowerBound = 0;
                int upperBound = 4096;
                while (s.getFilePointer() < s.length() - 2L) {
                    LOGGER.debug("  Looking for image at {}", (Object)s.getFilePointer());
                    s.order(false);
                    int nextOffset = this.findNextOffset(s);
                    if (nextOffset < 0 || (long)nextOffset >= s.length()) break;
                    s.seek(nextOffset);
                    s.skipBytes(3);
                    int len = s.readShort();
                    if (len <= 0) continue;
                    this.imageNames.add(s.readString(len));
                    if (s.getFilePointer() + 8L >= s.length()) break;
                    s.skipBytes(6);
                    s.order(true);
                    len = s.readShort();
                    if (nImages == 0 && len > upperBound * 2 && len < upperBound * 4) {
                        lowerBound = 512;
                        upperBound = 16384;
                    }
                    if (len < lowerBound || len > upperBound) continue;
                    s.skipBytes(len);
                }
                s.seek(0L);
                s.order(true);
                while (s.getFilePointer() < s.length() - 2L && (offset = (long)this.findNextOffset(s, DESCRIPTION_MARKER)) >= 0L && offset < s.length() - 2L) {
                    s.seek(offset);
                    short len = s.readShort();
                    if (len <= 0 || len > 4096) continue;
                    String description = s.readString(len);
                    LOGGER.debug("Description: {}", (Object)description);
                    String dateTime = "";
                    String[] lines = description.split("[\r\n]");
                    boolean validLine = false;
                    for (String line : lines) {
                        int colon = (line = line.trim()).indexOf(58);
                        if (colon == -1 || line.startsWith(";")) continue;
                        validLine = true;
                        String key = line.substring(0, colon).trim();
                        String value = line.substring(colon + 1).trim();
                        String metaKey = "Series " + nImages + " " + key;
                        this.addMeta(metaKey, value, tmpSeriesMetadata);
                        if (key.equals("Start time of experiment")) {
                            dateTime = dateTime + " " + value;
                            continue;
                        }
                        if (key.equals("Date")) {
                            dateTime = value + " " + dateTime;
                            continue;
                        }
                        if (key.equals("Exposure time [ms]")) {
                            double exp = Double.parseDouble(value) / 1000.0;
                            this.exposureTimes.put(nImages, exp);
                            continue;
                        }
                        if (!key.equals("Image type")) continue;
                        this.types.add(value);
                    }
                    if (!(dateTime = dateTime.trim()).equals("")) {
                        boolean success = false;
                        for (String format : DATE_FORMATS) {
                            try {
                                dateTime = DateTools.formatDate(dateTime, format, ".");
                                success = true;
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                        this.dates.add(success ? dateTime : "");
                    }
                    if (!validLine) continue;
                    ++nImages;
                }
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
        Location directory = new Location(this.currentId).getAbsoluteFile().getParentFile();
        ArrayList<String> pixelsFile = new ArrayList<String>(nImages);
        if (!this.embeddedImages) {
            if (nImages == 0) {
                throw new FormatException("No images found.");
            }
            String[] files = directory.list(true);
            String name = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1, this.currentId.lastIndexOf("."));
            for (String f : files) {
                Location pst;
                if (!TillVisionReader.checkSuffix((String)f, (String)"pst") || !(pst = new Location(directory, f)).isDirectory() || !f.startsWith(name)) continue;
                Object[] subfiles = pst.list(true);
                Arrays.sort(subfiles);
                for (Object q : subfiles) {
                    if (!TillVisionReader.checkSuffix((String)q, (String)"pst")) continue;
                    String path = f + File.separator + (String)q;
                    if (pixelsFile.size() >= nImages) {
                        LOGGER.warn("Adding {}, no matching acquisition metadata", (Object)path);
                    }
                    pixelsFile.add(path);
                }
            }
            if (pixelsFile.size() == 0) {
                for (String f : files) {
                    if (!TillVisionReader.checkSuffix((String)f, (String)"pst")) continue;
                    pixelsFile.add(new Location(directory, f).getAbsolutePath());
                }
                if (pixelsFile.size() == 0) {
                    throw new FormatException("No image files found.");
                }
            }
        }
        pixelsFile.sort(null);
        int nSeries = this.core.size();
        if (!this.embeddedImages) {
            this.core.clear();
            nSeries = pixelsFile.size();
        }
        this.pixelsFiles = new String[nSeries];
        this.infFiles = new String[nSeries];
        Object[] metadataKeys = tmpSeriesMetadata.keySet().toArray();
        IniParser parser = new IniParser();
        boolean bl = false;
        while (var11_32 < nSeries) {
            CoreMetadata ms;
            if (!this.embeddedImages) {
                String inf;
                ms = new CoreMetadata();
                this.core.add(ms);
                this.setSeries((int)var11_32);
                String file = (String)pixelsFile.get((int)var11_32);
                file = file.replace('/', File.separatorChar);
                String oldFile = file = file.replace('\\', File.separatorChar);
                Location f = new Location(directory, oldFile);
                if (!f.exists() && !(f = new Location(directory, oldFile = oldFile.substring(oldFile.lastIndexOf(File.separator) + 1))).exists()) {
                    throw new FormatException("Could not find pixels file '" + file);
                }
                this.pixelsFiles[var11_32] = file = f.getAbsolutePath();
                int dot = file.lastIndexOf(".");
                this.infFiles[var11_32] = inf = file.substring(0, dot) + ".inf";
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inf), "UTF-8"));
                IniList data = parser.parseINI(reader);
                reader.close();
                IniTable infoTable = data.getTable("Info");
                ms.sizeX = Integer.parseInt((String)infoTable.get("Width"));
                ms.sizeY = Integer.parseInt((String)infoTable.get("Height"));
                ms.sizeC = Integer.parseInt((String)infoTable.get("Bands"));
                ms.sizeZ = Integer.parseInt((String)infoTable.get("Slices"));
                ms.sizeT = Integer.parseInt((String)infoTable.get("Frames"));
                int dataType = Integer.parseInt((String)infoTable.get("Datatype"));
                ms.pixelType = this.convertPixelType(dataType);
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    HashMap<String, String> iniMap = data.flattenIntoHashMap();
                    ms.seriesMetadata.putAll(iniMap);
                }
            } else {
                ms = (CoreMetadata)this.core.get((int)var11_32);
                this.setSeries((int)var11_32);
            }
            ms.imageCount = ms.sizeZ * ms.sizeC * ms.sizeT;
            ms.rgb = false;
            ms.littleEndian = true;
            ms.dimensionOrder = "XYCZT";
            ms.seriesMetadata = new Hashtable();
            for (Object key : metadataKeys) {
                String keyName = key.toString();
                if (!keyName.startsWith("Series " + (int)var11_32 + " ")) continue;
                keyName = keyName.replaceAll("Series " + (int)var11_32 + " ", "");
                ms.seriesMetadata.put(keyName, tmpSeriesMetadata.get(key));
            }
            ++var11_32;
        }
        this.setSeries(0);
        this.populateMetadataStore();
        poi.close();
        poi = null;
    }

    private void populateMetadataStore() throws FormatException {
        int i;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            String date;
            if (i < this.imageNames.size()) {
                store.setImageName(this.imageNames.get(i), i);
            }
            String string = date = i < this.dates.size() ? this.dates.get(i) : "";
            if (date == null || date.equals("")) continue;
            store.setImageAcquisitionDate(new Timestamp(date), i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (i = 0; i < this.getSeriesCount(); ++i) {
                for (int q = 0; q < ((CoreMetadata)this.core.get((int)i)).imageCount; ++q) {
                    if (this.exposureTimes.get(i) == null) continue;
                    store.setPlaneExposureTime(new Time((Number)this.exposureTimes.get(i), UNITS.SECOND), i, q);
                }
                if (i >= this.types.size()) continue;
                store.setExperimentID(MetadataTools.createLSID((String)"Experiment", (int[])new int[]{i}), i);
                store.setExperimentType(MetadataTools.getExperimentType((String)this.types.get(i)), i);
            }
        }
    }

    private int convertPixelType(int type) throws FormatException {
        boolean signed = type % 2 == 1;
        int bytes = type / 2 + (signed ? 1 : 0);
        return FormatTools.pixelTypeFromBytes((int)bytes, (boolean)signed, (boolean)false);
    }

    private int findNextOffset(RandomAccessInputStream s) throws IOException {
        long fp = s.getFilePointer();
        int offset0 = this.findNextOffset(s, MARKER_0);
        s.seek(fp);
        int offset1 = this.findNextOffset(s, MARKER_1);
        s.seek(fp);
        int offset2 = this.findNextOffset(s, MARKER_2);
        s.seek(fp);
        int offset3 = this.findNextOffset(s, MARKER_3);
        if (offset0 < 0) {
            offset0 = Integer.MAX_VALUE;
        }
        if (offset1 < 0) {
            offset1 = Integer.MAX_VALUE;
        }
        if (offset2 < 0) {
            offset2 = Integer.MAX_VALUE;
        }
        if (offset3 < 0) {
            offset3 = Integer.MAX_VALUE;
        }
        if (offset0 < offset1 && offset0 < offset2 && offset0 < offset3) {
            return offset0;
        }
        if (offset1 < offset0 && offset1 < offset2 && offset1 < offset3) {
            return offset1;
        }
        if (offset2 < offset1 && offset2 < offset0 && offset2 < offset3) {
            return offset2;
        }
        if (offset3 < offset1 && offset3 < offset0 && offset3 < offset2) {
            return offset3;
        }
        return -1;
    }

    private int findNextOffset(RandomAccessInputStream s, byte[] marker) throws IOException {
        for (long i = s.getFilePointer(); i < s.length() - (long)marker.length; ++i) {
            s.seek(i);
            boolean found = true;
            for (int q = 0; q < marker.length; ++q) {
                if (marker[q] == s.readByte()) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return (int)(i + (long)marker.length);
        }
        return -1;
    }

    private Long[] findImages(RandomAccessInputStream s) throws IOException {
        ArrayList<Long> offsets = new ArrayList<Long>();
        byte[] buf = new byte[8192];
        int overlap = 128;
        s.read(buf, 0, overlap);
        while (s.getFilePointer() < s.length()) {
            s.read(buf, overlap, buf.length - overlap);
            for (int i = 0; i < buf.length - overlap; ++i) {
                byte len;
                String name;
                long offset;
                if (DataTools.bytesToInt(buf, i, 4, false) != -264241408 || DataTools.bytesToInt(buf, i + 4, 4, false) != 0 || DataTools.bytesToInt(buf, i + 8, 4, false) != 0 || DataTools.bytesToInt(buf, i + 12, 4, false) != 65280) continue;
                int pointer = i + 22;
                short length = DataTools.bytesToShort(buf, pointer, 2, true);
                if (length == 6 && new String(buf, pointer + 2, (int)length, "UTF-8").equals("CImage")) {
                    pointer += length + 4;
                }
                if (DataTools.bytesToInt(buf, pointer, 4, false) != 0x8000400 || offsets.contains(offset = s.getFilePointer() - (long)buf.length + (long)pointer + 4L) || (name = new String(buf, pointer + 5, (int)(len = buf[pointer + 4]), "UTF-8")).indexOf("Palette") >= 0) continue;
                offsets.add(offset);
            }
            System.arraycopy(buf, buf.length - overlap, buf, 0, overlap);
        }
        return offsets.toArray(new Long[offsets.size()]);
    }
}

