/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ome.conditions.ResourceError;
import ome.io.nio.PixelBuffer;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import ome.model.display.QuantumDef;
import ome.model.display.RenderingDef;
import ome.model.enums.Family;
import ome.model.enums.PixelsType;
import ome.model.enums.RenderingModel;
import omeis.providers.re.Optimizations;
import omeis.providers.re.QuantumManager;
import omeis.providers.re.RGBBuffer;
import omeis.providers.re.RGBIntBuffer;
import omeis.providers.re.RenderingStats;
import omeis.providers.re.RenderingStrategy;
import omeis.providers.re.codomain.CodomainChain;
import omeis.providers.re.codomain.CodomainMapContext;
import omeis.providers.re.codomain.ReverseIntensityContext;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.data.PlaneFactory;
import omeis.providers.re.data.RegionDef;
import omeis.providers.re.lut.LutProvider;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumFactory;
import omeis.providers.re.quantum.QuantumStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer {
    private static Logger log = LoggerFactory.getLogger(Renderer.class);
    public static final int MAX_CHANNELS = 8;
    public static final String MODEL_GREYSCALE = "greyscale";
    public static final String MODEL_RGB = "rgb";
    public static final String MODEL_HSB = "rgb";
    @Deprecated
    public static final String PHOTOMETRIC_MONOCHROME = "Monochrome";
    private Pixels metadata;
    private RenderingDef rndDef;
    private PixelBuffer buffer;
    private QuantumManager quantumManager;
    private List<CodomainChain> codomainChains;
    private RenderingStrategy renderingStrategy;
    private RenderingStats stats;
    private Optimizations optimizations = new Optimizations();
    private Map<byte[], Integer> overlays;
    private LutProvider lutProvider;

    private List<ChannelBinding> getOtherBindings(List<ChannelBinding> bindings, ChannelBinding toRemove) {
        if (!bindings.contains(toRemove)) {
            throw new IllegalArgumentException("Channel binding not found in list.");
        }
        ArrayList<ChannelBinding> otherBindings = new ArrayList<ChannelBinding>(bindings.size() - 1);
        for (ChannelBinding binding : bindings) {
            if (binding == toRemove) continue;
            otherBindings.add(binding);
        }
        return otherBindings;
    }

    private boolean isEndColor(int[] color) {
        if (color[0] == 255 && color[1] == 255 && color[2] == 255) {
            return true;
        }
        return color[0] == 0 && color[1] == 0 && color[2] == 0;
    }

    private void checkOptimizations() {
        List<ChannelBinding> channelBindings = this.getChannelBindingsAsList();
        for (ChannelBinding channelBinding : channelBindings) {
            boolean isActive = channelBinding.getActive();
            if (!isActive || channelBinding.getAlpha() == 255) continue;
            log.info("Disabling alphaless rendering and PriColor rendering.");
            this.optimizations.setAlphalessRendering(false);
            return;
        }
        log.info("Enabling alphaless rendering.");
        this.optimizations.setAlphalessRendering(true);
        int channelsActive = 0;
        for (ChannelBinding channelBinding : channelBindings) {
            if (!channelBinding.getActive().booleanValue()) continue;
            ++channelsActive;
            if (this.overlays != null && this.overlays.size() > 0) {
                log.info("Disabling PriColor rendering, have overlays.");
                this.optimizations.setPrimaryColorEnabled(false);
                return;
            }
            if (channelsActive > 3) {
                log.info("Disabling PriColor rendering, active channels > 3");
                this.optimizations.setPrimaryColorEnabled(false);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)channelBinding.getLookupTable())) {
                this.optimizations.setPrimaryColorEnabled(false);
                return;
            }
            boolean isPrimary = false;
            int[] colorArray = Renderer.getColorArray(channelBinding);
            if (this.isEndColor(colorArray)) {
                this.optimizations.setPrimaryColorEnabled(false);
                return;
            }
            for (int value : colorArray) {
                if (value != 0 && value != 255) {
                    log.info("Disabling PriColor rendering, channel color not primary.");
                    this.optimizations.setPrimaryColorEnabled(false);
                    return;
                }
                if (value != 255) continue;
                if (isPrimary) {
                    log.info("Disabling PriColor rendering, duplicate channel color component.");
                    this.optimizations.setPrimaryColorEnabled(false);
                    return;
                }
                isPrimary = true;
            }
            List<ChannelBinding> otherBindings = this.getOtherBindings(channelBindings, channelBinding);
            for (ChannelBinding otherChannelBinding : otherBindings) {
                if (!otherChannelBinding.getActive().booleanValue()) continue;
                int[] otherColorArray = Renderer.getColorArray(otherChannelBinding);
                for (int i = 0; i < colorArray.length; ++i) {
                    if (colorArray[i] != otherColorArray[i] || colorArray[i] == 0) continue;
                    log.info("Disabling PriColor rendering, duplicate channel color.");
                    this.optimizations.setPrimaryColorEnabled(false);
                    return;
                }
            }
        }
        log.info("Enabling primary color rendering.");
        this.optimizations.setPrimaryColorEnabled(true);
    }

    private void checkRegionDef(RegionDef rd) {
        if (rd == null) {
            return;
        }
        int sizeX = this.buffer.getSizeX();
        int sizeY = this.buffer.getSizeY();
        int x = rd.getX();
        int y = rd.getY();
        if (rd.getWidth() + x > sizeX) {
            rd.setWidth(sizeX - x);
        }
        if (rd.getHeight() + y > sizeY) {
            rd.setHeight(sizeY - y);
        }
    }

    private CodomainMapContext convert(ome.model.display.CodomainMapContext ctx) {
        if (ctx instanceof ome.model.display.ReverseIntensityContext) {
            return new ReverseIntensityContext();
        }
        return null;
    }

    public Renderer(QuantumFactory quantumFactory, List<RenderingModel> renderingModels, Pixels pixelsObj, RenderingDef renderingDefObj, PixelBuffer bufferObj, LutProvider lutProvider) {
        this.metadata = pixelsObj;
        this.rndDef = renderingDefObj;
        this.buffer = bufferObj;
        this.lutProvider = lutProvider;
        if (this.metadata == null) {
            throw new NullPointerException("Expecting not null metadata");
        }
        if (this.rndDef == null) {
            throw new NullPointerException("Expecting not null rndDef");
        }
        if (this.buffer == null) {
            throw new NullPointerException("Expecting not null buffer");
        }
        QuantumDef qd = this.rndDef.getQuantization();
        this.quantumManager = new QuantumManager(this.metadata, quantumFactory);
        ChannelBinding[] cBindings = this.getChannelBindings();
        this.quantumManager.initStrategies(qd, cBindings);
        this.codomainChains = new ArrayList<CodomainChain>();
        for (int i = 0; i < cBindings.length; ++i) {
            ChannelBinding cb = cBindings[i];
            List l = cb.collectSpatialDomainEnhancement(null);
            ArrayList<CodomainMapContext> nl = new ArrayList<CodomainMapContext>();
            if (l != null && l.size() > 0) {
                Iterator j = l.iterator();
                while (j.hasNext()) {
                    CodomainMapContext ctx = this.convert((ome.model.display.CodomainMapContext)j.next());
                    if (ctx == null) continue;
                    nl.add(ctx);
                }
            }
            this.codomainChains.add(new CodomainChain(qd.getCdStart(), qd.getCdEnd(), nl));
        }
        this.renderingStrategy = RenderingStrategy.makeNew(this.rndDef.getModel());
        this.checkOptimizations();
    }

    LutProvider getLutProvider() {
        return this.lutProvider;
    }

    public void setModel(RenderingModel model) {
        this.rndDef.setModel(model);
        this.renderingStrategy = RenderingStrategy.makeNew(model);
    }

    public void setDefaultZ(int z) {
        this.rndDef.setDefaultZ(Integer.valueOf(z));
    }

    public void setDefaultT(int t) {
        this.rndDef.setDefaultT(Integer.valueOf(t));
    }

    public void setOverlays(Map<byte[], Integer> overlays) {
        this.overlays = overlays;
        this.checkOptimizations();
    }

    public Map<byte[], Integer> getOverlays() {
        return this.overlays;
    }

    public void updateQuantumManager() {
        QuantumDef qd = this.rndDef.getQuantization();
        ChannelBinding[] cb = this.getChannelBindings();
        this.quantumManager.initStrategies(qd, cb);
    }

    public RGBBuffer render(PlaneDef pd) throws IOException, QuantizationException {
        if (pd == null) {
            throw new NullPointerException("No plane definition.");
        }
        this.checkRegionDef(pd.getRegion());
        this.stats = new RenderingStats(this, pd);
        log.info("Using: '" + this.renderingStrategy.getClass().getName() + "' rendering strategy.");
        RGBBuffer img = this.renderingStrategy.render(this, pd);
        this.stats.stop();
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] renderAsPackedInt(PlaneDef pd, PixelBuffer newBuffer) throws IOException, QuantizationException {
        if (pd == null) {
            throw new NullPointerException("No plane definition.");
        }
        this.checkRegionDef(pd.getRegion());
        this.stats = new RenderingStats(this, pd);
        log.info("Using: '" + this.renderingStrategy.getClass().getName() + "' rendering strategy.");
        PixelBuffer oldBuffer = this.buffer;
        try {
            if (newBuffer != null) {
                this.buffer = newBuffer;
            }
            RGBIntBuffer img = this.renderingStrategy.renderAsPackedInt(this, pd);
            this.stats.stop();
            int[] nArray = img.getDataBuffer();
            return nArray;
        }
        finally {
            this.buffer = oldBuffer;
        }
    }

    public int getImageSize(PlaneDef pd) {
        if (pd == null) {
            throw new NullPointerException("No plane definition.");
        }
        return this.renderingStrategy.getImageSize(pd, this.metadata);
    }

    public String getPlaneDimsAsString(PlaneDef pd) {
        if (pd == null) {
            throw new NullPointerException("No plane definition.");
        }
        return this.renderingStrategy.getPlaneDimsAsString(pd, this.metadata);
    }

    public ChannelBinding[] getChannelBindings() {
        List bindings = this.rndDef.collectWaveRendering(null);
        return bindings.toArray(new ChannelBinding[bindings.size()]);
    }

    public List getCodomainMapContexts() {
        return null;
    }

    public List<ChannelBinding> getChannelBindingsAsList() {
        return this.rndDef.collectWaveRendering(null);
    }

    public RenderingDef getRenderingDef() {
        return this.rndDef;
    }

    public QuantumManager getQuantumManager() {
        return this.quantumManager;
    }

    public PixelBuffer getPixels() {
        return this.buffer;
    }

    public Pixels getMetadata() {
        return this.metadata;
    }

    public PixelsType getPixelsType() {
        return this.metadata.getPixelsType();
    }

    List<CodomainChain> getCodomainChains() {
        return Collections.unmodifiableList(this.codomainChains);
    }

    public CodomainChain getCodomainChain(int channel) {
        return this.codomainChains.get(channel);
    }

    public RenderingStats getStats() {
        return this.stats;
    }

    public void setQuantumStrategy(int bitResolution) {
        RenderingDef rd = this.getRenderingDef();
        QuantumDef qd = rd.getQuantization();
        qd.setBitResolution(Integer.valueOf(bitResolution));
        this.updateQuantumManager();
    }

    public void setCodomainInterval(int start, int end) {
        for (int i = 0; i < this.getPixels().getSizeC(); ++i) {
            CodomainChain c = this.getCodomainChain(i);
            c.setInterval(start, end);
        }
        RenderingDef rd = this.getRenderingDef();
        QuantumDef qd = rd.getQuantization();
        qd.setCdStart(Integer.valueOf(start));
        qd.setCdEnd(Integer.valueOf(end));
        this.updateQuantumManager();
    }

    public void setChannelWindow(int w, double start, double end) {
        QuantumStrategy qs = this.getQuantumManager().getStrategyFor(w);
        qs.setWindow(start, end);
        ChannelBinding[] cb = this.getChannelBindings();
        cb[w].setInputStart(new Double(start));
        cb[w].setInputEnd(new Double(end));
    }

    public void setQuantizationMap(int w, Family family, double coefficient, boolean noiseReduction) {
        QuantumStrategy qs = this.getQuantumManager().getStrategyFor(w);
        qs.setQuantizationMap(family, coefficient, noiseReduction);
        ChannelBinding[] cb = this.getChannelBindings();
        cb[w].setFamily(family);
        cb[w].setCoefficient(Double.valueOf(qs.getCurveCoefficient()));
        cb[w].setNoiseReduction(Boolean.valueOf(noiseReduction));
    }

    public void setRGBA(int w, int red, int green, int blue, int alpha) {
        ChannelBinding[] cb = this.getChannelBindings();
        cb[w].setRed(Integer.valueOf(red));
        cb[w].setGreen(Integer.valueOf(green));
        cb[w].setBlue(Integer.valueOf(blue));
        cb[w].setAlpha(Integer.valueOf(alpha));
        this.checkOptimizations();
    }

    public void setChannelLookupTable(int w, String lookupTable) {
        ChannelBinding[] cb = this.getChannelBindings();
        cb[w].setLookupTable(lookupTable);
        this.checkOptimizations();
    }

    public void setActive(int w, boolean active) {
        ChannelBinding[] cb = this.getChannelBindings();
        cb[w].setActive(Boolean.valueOf(active));
        this.checkOptimizations();
    }

    public Optimizations getOptimizations() {
        return this.optimizations;
    }

    public void close() {
        try {
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
        catch (IOException e) {
            log.error("Buffer did not close successfully.", (Throwable)e);
            throw new ResourceError(e.getMessage() + " Please check server log.");
        }
    }

    public static int[] getColorArray(ChannelBinding channel) {
        int[] colors = new int[]{channel.getRed(), channel.getGreen(), channel.getBlue()};
        return colors;
    }

    public boolean isPixelsTypeSigned() {
        if (this.metadata == null) {
            return false;
        }
        return PlaneFactory.isTypeSigned(this.metadata.getPixelsType());
    }

    public double getPixelsTypeLowerBound(int w) {
        QuantumStrategy qs = this.getQuantumManager().getStrategyFor(w);
        return qs.getPixelsTypeMin();
    }

    public double getPixelsTypeUpperBound(int w) {
        QuantumStrategy qs = this.getQuantumManager().getStrategyFor(w);
        return qs.getPixelsTypeMax();
    }

    public void setResolutionLevel(int resolutionLevel) {
        this.buffer.setResolutionLevel(resolutionLevel);
    }

    public int getResolutionLevel() {
        return this.buffer.getResolutionLevel();
    }

    public int getResolutionLevels() {
        return this.buffer.getResolutionLevels();
    }

    public List<List<Integer>> getResolutionDescriptions() {
        return this.buffer.getResolutionDescriptions();
    }

    public Dimension getTileSize() {
        return this.buffer.getTileSize();
    }
}

