/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.data;

import java.io.IOException;
import loci.formats.FormatTools;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.model.core.Pixels;
import ome.model.enums.PixelsType;
import omeis.providers.re.data.Plane2D;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.data.RegionDef;

public class PlaneFactory {
    @Deprecated
    public static final String BIT = "bit";
    @Deprecated
    public static final String INT8 = "int8";
    @Deprecated
    public static final String INT16 = "int16";
    @Deprecated
    public static final String INT32 = "int32";
    @Deprecated
    public static final String UINT8 = "uint8";
    @Deprecated
    public static final String UINT16 = "uint16";
    @Deprecated
    public static final String UINT32 = "uint32";
    @Deprecated
    public static final String FLOAT_TYPE = "float";
    @Deprecated
    public static final String DOUBLE_TYPE = "double";
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;

    private static int getPixelType(PixelsType type) {
        if (type == null) {
            return -1;
        }
        return FormatTools.pixelTypeFromString((String)type.getValue());
    }

    public static boolean in(PixelsType type, String[] strings) {
        String typeAsString = type.getValue();
        for (int i = 0; i < strings.length; ++i) {
            if (!typeAsString.equals(strings[i])) continue;
            return true;
        }
        return false;
    }

    static int bytesPerPixel(PixelsType type) {
        return FormatTools.getBytesPerPixel((int)PlaneFactory.getPixelType(type));
    }

    public static boolean isTypeSigned(PixelsType type) {
        return FormatTools.isSigned((int)PlaneFactory.getPixelType(type));
    }

    public static Plane2D createPlane(PlaneDef planeDef, int channel, Pixels pixels, PixelBuffer buffer) {
        if (planeDef == null) {
            throw new NullPointerException("Expecting not null planeDef");
        }
        if (pixels == null) {
            throw new NullPointerException("Expecting not null pixels");
        }
        if (buffer == null) {
            throw new NullPointerException("Expecting not null buffer");
        }
        Integer z = planeDef.getZ();
        Integer c = channel;
        Integer t = planeDef.getT();
        Integer stride = planeDef.getStride();
        try {
            RegionDef region = planeDef.getRegion();
            if (region != null) {
                switch (planeDef.getSlice()) {
                    case 0: {
                        return new Plane2D(planeDef, pixels, buffer.getTile(z, c, t, region.getX(), region.getY(), region.getWidth(), region.getHeight()));
                    }
                    case 2: {
                        return new Plane2D(planeDef, pixels, buffer.getStack(c, t));
                    }
                    case 1: {
                        return new Plane2D(planeDef, pixels, buffer.getStack(c, t));
                    }
                }
            } else {
                switch (planeDef.getSlice()) {
                    case 0: {
                        if (stride == null || stride <= 0) {
                            return new Plane2D(planeDef, pixels, buffer.getPlane(z, c, t));
                        }
                        return new Plane2D(planeDef, pixels, buffer.getPlaneRegion(0, 0, pixels.getSizeX(), pixels.getSizeY(), z, c, t, stride));
                    }
                    case 2: {
                        return new Plane2D(planeDef, pixels, buffer.getStack(c, t));
                    }
                    case 1: {
                        return new Plane2D(planeDef, pixels, buffer.getStack(c, t));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (DimensionsOutOfBoundsException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

