/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import hdf.hdf5lib.HDF5Constants;

public final class HDF5IntStorageFeatures
extends HDF5AbstractStorageFeatures {
    private static final byte INTEGER_AUTO_SCALING_FACTOR = 0;
    public static final HDF5IntStorageFeatures INT_NO_COMPRESSION = new HDF5IntStorageFeatures(null, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_NO_COMPRESSION_UNSIGNED = new HDF5IntStorageFeatures(null, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_NO_COMPRESSION_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_NO_COMPRESSION_UNSIGNED_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_NO_COMPRESSION_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_NO_COMPRESSION_UNSIGNED_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_COMPACT = new HDF5IntStorageFeatures(HDF5StorageLayout.COMPACT, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_COMPACT_UNSIGNED = new HDF5IntStorageFeatures(HDF5StorageLayout.COMPACT, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_COMPACT_KEEP = new HDF5IntStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_COMPACT_UNSIGNED_KEEP = new HDF5IntStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_COMPACT_DELETE = new HDF5IntStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_COMPACT_UNSIGNED_DELETE = new HDF5IntStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_CONTIGUOUS = new HDF5IntStorageFeatures(HDF5StorageLayout.CONTIGUOUS, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_CONTIGUOUS_UNSIGNED = new HDF5IntStorageFeatures(HDF5StorageLayout.CONTIGUOUS, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_CONTIGUOUS_KEEP = new HDF5IntStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_CONTIGUOUS_UNSIGNED_KEEP = new HDF5IntStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_CONTIGUOUS_DELETE = new HDF5IntStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_CONTIGUOUS_UNSIGNED_DELETE = new HDF5IntStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_CHUNKED = new HDF5IntStorageFeatures(HDF5StorageLayout.CHUNKED, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_CHUNKED_UNSIGNED = new HDF5IntStorageFeatures(HDF5StorageLayout.CHUNKED, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_CHUNKED_KEEP = new HDF5IntStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_CHUNKED_UNSIGNED_KEEP = new HDF5IntStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_CHUNKED_DELETE = new HDF5IntStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, true);
    public static final HDF5IntStorageFeatures INT_CHUNKED_UNSIGNED_DELETE = new HDF5IntStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1, false);
    public static final HDF5IntStorageFeatures INT_DEFLATE = new HDF5IntStorageFeatures(null, 6, -1, true);
    public static final HDF5IntStorageFeatures INT_SHUFFLE_DEFLATE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT, true, 6, -1, true);
    public static final HDF5IntStorageFeatures INT_DEFLATE_UNSIGNED = new HDF5IntStorageFeatures(null, 6, -1, false);
    public static final HDF5IntStorageFeatures INT_DEFLATE_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, -1, true);
    public static final HDF5IntStorageFeatures INT_DEFLATE_UNSIGNED_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, -1, false);
    public static final HDF5IntStorageFeatures INT_DEFLATE_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, -1, true);
    public static final HDF5IntStorageFeatures INT_DEFLATE_UNSIGNED_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, -1, false);
    public static final HDF5IntStorageFeatures INT_DEFLATE_MAX = new HDF5IntStorageFeatures(null, 9, -1, true);
    public static final HDF5IntStorageFeatures INT_DEFLATE_MAX_UNSIGNED = new HDF5IntStorageFeatures(null, 9, -1, false);
    public static final HDF5IntStorageFeatures INT_DEFLATE_MAX_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 9, -1, true);
    public static final HDF5IntStorageFeatures INT_DEFLATE_MAX_UNSIGNED_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 9, -1, false);
    public static final HDF5IntStorageFeatures INT_DEFLATE_MAX_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 9, -1, true);
    public static final HDF5IntStorageFeatures INT_DEFLATE_MAX_UNSIGNED_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 9, -1, false);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING = new HDF5IntStorageFeatures(null, 0, 0, true);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_UNSIGNED = new HDF5IntStorageFeatures(null, 0, 0, false);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, 0, true);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_UNSIGNED_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, 0, false);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, 0, true);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_UNSIGNED_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, 0, false);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_DEFLATE = new HDF5IntStorageFeatures(null, 6, 0, true);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_DEFLATE_UNSIGNED = new HDF5IntStorageFeatures(null, 6, 0, false);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_DEFLATE_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, 0, true);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_DEFLATE_UNSIGNED_KEEP = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, 0, false);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_DEFLATE_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, 0, true);
    public static final HDF5IntStorageFeatures INT_AUTO_SCALING_DEFLATE_UNSIGNED_DELETE = new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, 0, false);
    private final boolean signed;

    public static HDF5IntStorageFeatureBuilder build() {
        return new HDF5IntStorageFeatureBuilder();
    }

    public static HDF5IntStorageFeatureBuilder build(HDF5AbstractStorageFeatures template) {
        return new HDF5IntStorageFeatureBuilder(template);
    }

    public static HDF5IntStorageFeatures createFromGeneric(HDF5GenericStorageFeatures storageFeatures) {
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED) {
            return INT_CHUNKED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_DELETE) {
            return INT_CHUNKED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_KEEP) {
            return INT_CHUNKED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT) {
            return INT_COMPACT;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_DELETE) {
            return INT_COMPACT_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_KEEP) {
            return INT_COMPACT_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS) {
            return INT_CONTIGUOUS;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_DELETE) {
            return INT_CONTIGUOUS_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_KEEP) {
            return INT_CONTIGUOUS_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION) {
            return INT_NO_COMPRESSION;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_DELETE) {
            return INT_NO_COMPRESSION_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_KEEP) {
            return INT_NO_COMPRESSION_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE) {
            return INT_DEFLATE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_DELETE) {
            return INT_DEFLATE_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_KEEP) {
            return INT_DEFLATE_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX) {
            return INT_DEFLATE_MAX;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_DELETE) {
            return INT_DEFLATE_MAX_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_KEEP) {
            return INT_DEFLATE_MAX_KEEP;
        }
        return new HDF5IntStorageFeatures(storageFeatures.tryGetProposedLayout(), storageFeatures.getDatasetReplacementPolicy(), storageFeatures.getDeflateLevel(), -1, true);
    }

    public static HDF5IntStorageFeatures createUnsignedFromGeneric(HDF5GenericStorageFeatures storageFeatures) {
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED) {
            return INT_CHUNKED_UNSIGNED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_DELETE) {
            return INT_CHUNKED_UNSIGNED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CHUNKED_KEEP) {
            return INT_CHUNKED_UNSIGNED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT) {
            return INT_COMPACT_UNSIGNED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_DELETE) {
            return INT_COMPACT_UNSIGNED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_COMPACT_KEEP) {
            return INT_COMPACT_UNSIGNED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS) {
            return INT_CONTIGUOUS_UNSIGNED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_DELETE) {
            return INT_CONTIGUOUS_UNSIGNED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_CONTIGUOUS_KEEP) {
            return INT_CONTIGUOUS_UNSIGNED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION) {
            return INT_NO_COMPRESSION_UNSIGNED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_DELETE) {
            return INT_NO_COMPRESSION_UNSIGNED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION_KEEP) {
            return INT_NO_COMPRESSION_UNSIGNED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE) {
            return INT_DEFLATE_UNSIGNED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_DELETE) {
            return INT_DEFLATE_UNSIGNED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_KEEP) {
            return INT_DEFLATE_UNSIGNED_KEEP;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX) {
            return INT_DEFLATE_MAX_UNSIGNED;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_DELETE) {
            return INT_DEFLATE_MAX_UNSIGNED_DELETE;
        }
        if (storageFeatures == HDF5GenericStorageFeatures.GENERIC_DEFLATE_MAX_KEEP) {
            return INT_DEFLATE_MAX_UNSIGNED_KEEP;
        }
        return new HDF5IntStorageFeatures(storageFeatures.tryGetProposedLayout(), storageFeatures.getDatasetReplacementPolicy(), storageFeatures.getDeflateLevel(), -1, true);
    }

    public static HDF5IntStorageFeatures createDeflation(int deflationLevel) {
        return HDF5IntStorageFeatures.createDeflation(deflationLevel, false, false, true);
    }

    public static HDF5IntStorageFeatures createDeflationKeep(int deflationLevel) {
        return HDF5IntStorageFeatures.createDeflation(deflationLevel, true, false, true);
    }

    public static HDF5IntStorageFeatures createDeflationDelete(int deflationLevel) {
        return HDF5IntStorageFeatures.createDeflation(deflationLevel, false, true, true);
    }

    public static HDF5IntStorageFeatures createDeflationUnsigned(int deflationLevel) {
        return HDF5IntStorageFeatures.createDeflation(deflationLevel, false, false, false);
    }

    public static HDF5IntStorageFeatures createDeflationUnsignedKeep(int deflationLevel) {
        return HDF5IntStorageFeatures.createDeflation(deflationLevel, true, false, false);
    }

    public static HDF5IntStorageFeatures createDeflationUnsignedDelete(int deflationLevel) {
        return HDF5IntStorageFeatures.createDeflation(deflationLevel, false, true, false);
    }

    private static HDF5IntStorageFeatures createDeflation(int deflationLevel, boolean keepDataSetIfExists, boolean deleteDataSetIfExists, boolean signed) {
        if (signed) {
            return new HDF5IntStorageFeatures(null, HDF5IntStorageFeatures.getDataSetReplacementPolicy(keepDataSetIfExists, deleteDataSetIfExists), HDF5IntStorageFeatures.toByte(deflationLevel), -1, true);
        }
        return new HDF5IntStorageFeatures(null, HDF5IntStorageFeatures.getDataSetReplacementPolicy(keepDataSetIfExists, deleteDataSetIfExists), HDF5IntStorageFeatures.toByte(deflationLevel), -1, false);
    }

    public static HDF5IntStorageFeatures createIntegerScaling(int scalingFactor) {
        return HDF5IntStorageFeatures.createIntegerScaling(scalingFactor, false, true);
    }

    public static HDF5IntStorageFeatures createIntegerScalingKeep(int scalingFactor) {
        return HDF5IntStorageFeatures.createIntegerScaling(scalingFactor, true, true);
    }

    public static HDF5IntStorageFeatures createIntegerScalingUnsigned(int scalingFactor) {
        return HDF5IntStorageFeatures.createIntegerScaling(scalingFactor, false, false);
    }

    public static HDF5IntStorageFeatures createIntegerScalingUnsignedKeep(int scalingFactor) {
        return HDF5IntStorageFeatures.createIntegerScaling(scalingFactor, true, false);
    }

    private static HDF5IntStorageFeatures createIntegerScaling(int scalingFactor, boolean keepExistingDataSetIfExists, boolean signed) {
        if (signed) {
            if (scalingFactor == 0) {
                return keepExistingDataSetIfExists ? INT_AUTO_SCALING_DEFLATE_KEEP : INT_AUTO_SCALING_DEFLATE;
            }
            return new HDF5IntStorageFeatures(null, 0, HDF5IntStorageFeatures.toByte(scalingFactor), true);
        }
        if (scalingFactor == 0) {
            return keepExistingDataSetIfExists ? INT_AUTO_SCALING_DEFLATE_UNSIGNED_KEEP : INT_AUTO_SCALING_DEFLATE_UNSIGNED;
        }
        return new HDF5IntStorageFeatures(null, 0, HDF5IntStorageFeatures.toByte(scalingFactor), false);
    }

    public static HDF5IntStorageFeatures createDeflateAndIntegerScaling(int scalingFactor) {
        return new HDF5IntStorageFeatures(null, 6, HDF5IntStorageFeatures.toByte(scalingFactor), true);
    }

    public static HDF5IntStorageFeatures createDeflateAndIntegerScalingKeep(int scalingFactor) {
        return new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, HDF5IntStorageFeatures.toByte(scalingFactor), true);
    }

    public static HDF5IntStorageFeatures createDeflateAndIntegerScaling(int deflateLevel, byte scalingFactor) {
        return new HDF5IntStorageFeatures(null, HDF5IntStorageFeatures.toByte(deflateLevel), scalingFactor, true);
    }

    public static HDF5IntStorageFeatures createDeflateAndIntegerScalingUnsigned(int deflateLevel, byte scalingFactor) {
        return new HDF5IntStorageFeatures(null, HDF5IntStorageFeatures.toByte(deflateLevel), scalingFactor, false);
    }

    public static HDF5IntStorageFeatures createDeflateAndIntegerScaling(int deflateLevel, byte scalingFactor, boolean keepDataSetIfExists) {
        return new HDF5IntStorageFeatures(null, HDF5IntStorageFeatures.getDataSetReplacementPolicy(keepDataSetIfExists, false), HDF5IntStorageFeatures.toByte(deflateLevel), scalingFactor, true);
    }

    public static HDF5IntStorageFeatures createDeflateAndIntegerScalingUnsigned(int deflateLevel, byte scalingFactor, boolean keepDataSetIfExists) {
        return new HDF5IntStorageFeatures(null, HDF5IntStorageFeatures.getDataSetReplacementPolicy(keepDataSetIfExists, false), HDF5IntStorageFeatures.toByte(deflateLevel), scalingFactor, false);
    }

    public static HDF5IntStorageFeatures createDeflateAndIntegerScalingKeep(int deflateLevel, byte scalingFactor) {
        return new HDF5IntStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, HDF5IntStorageFeatures.toByte(deflateLevel), scalingFactor, true);
    }

    HDF5IntStorageFeatures(HDF5IntStorageFeatureBuilder builder) {
        super(builder.getStorageLayout(), builder.getDatasetReplacementPolicy(), builder.isShuffleBeforeDeflate(), builder.getDeflateLevel(), builder.getScalingFactor());
        this.signed = builder.isSigned();
    }

    HDF5IntStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, byte deflateLevel, byte scalingFactor, boolean signed) {
        this(proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT, deflateLevel, scalingFactor, signed);
    }

    HDF5IntStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy dataSetReplacementPolicy, byte deflateLevel, byte scalingFactor, boolean signed) {
        super(proposedLayoutOrNull, dataSetReplacementPolicy, deflateLevel, scalingFactor);
        this.signed = signed;
    }

    HDF5IntStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy dataSetReplacementPolicy, boolean shuffleBeforeDeflate, byte deflateLevel, byte scalingFactor, boolean signed) {
        super(proposedLayoutOrNull, dataSetReplacementPolicy, shuffleBeforeDeflate, deflateLevel, scalingFactor);
        this.signed = signed;
    }

    public boolean isSigned() {
        return this.signed;
    }

    @Override
    boolean isCompatibleWithDataClass(int dataClassId) {
        return dataClassId == HDF5Constants.H5T_INTEGER;
    }

    public static final class HDF5IntStorageFeatureBuilder
    extends HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder {
        private boolean signed = true;

        public HDF5IntStorageFeatureBuilder() {
        }

        public HDF5IntStorageFeatureBuilder(HDF5AbstractStorageFeatures template) {
            super(template);
            if (template instanceof HDF5IntStorageFeatures) {
                this.signed(((HDF5IntStorageFeatures)template).isSigned());
            }
        }

        boolean isSigned() {
            return this.signed;
        }

        public HDF5IntStorageFeatureBuilder signed(boolean signed) {
            this.signed = signed;
            return this;
        }

        public HDF5IntStorageFeatureBuilder unsigned() {
            this.signed = false;
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder compress(boolean compress) {
            super.compress(compress);
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder compress() {
            super.compress();
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder deflateLevel(byte deflateLevel) {
            super.deflateLevel(deflateLevel);
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder scalingFactor(byte scalingFactor) {
            super.scalingFactor(scalingFactor);
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder noScaling() {
            super.noScaling();
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder shuffleBeforeDeflate(boolean shuffleBeforeDeflate) {
            super.shuffleBeforeDeflate(shuffleBeforeDeflate);
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder shuffleBeforeDeflate() {
            super.shuffleBeforeDeflate();
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder storageLayout(HDF5StorageLayout proposedLayout) {
            super.storageLayout(proposedLayout);
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder compactStorageLayout() {
            super.compactStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder contiguousStorageLayout() {
            super.contiguousStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder chunkedStorageLayout() {
            super.chunkedStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder defaultStorageLayout() {
            this.defaultStorageLayout();
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder datasetReplacementPolicy(HDF5AbstractStorageFeatures.DataSetReplacementPolicy datasetReplacementPolicy) {
            super.datasetReplacementPolicy(datasetReplacementPolicy);
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder datasetReplacementUseWriterDefault() {
            super.datasetReplacementUseWriterDefault();
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder datasetReplacementEnforceKeepExisting() {
            super.datasetReplacementEnforceKeepExisting();
            return this;
        }

        @Override
        public HDF5IntStorageFeatureBuilder datasetReplacementEnforceReplaceWithNew() {
            super.datasetReplacementEnforceReplaceWithNew();
            return this;
        }

        @Override
        public HDF5IntStorageFeatures features() {
            return new HDF5IntStorageFeatures(this);
        }
    }
}

