/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib.exceptions;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;

public class HDF5LibraryException
extends HDF5Exception {
    private final String hdf5ErrorStackString;
    private final String hdf5ErrorStackLastElementString;
    private final long majorErrorNumber;
    private final long minorErrorNumber;

    public HDF5LibraryException() {
        try {
            H5.H5open();
        }
        catch (Exception exception) {}
        this.majorErrorNumber = this._getMajorErrorNumber();
        this.minorErrorNumber = this._getMinorErrorNumber();
        this.detailMessage = this.getMinorError(this.minorErrorNumber);
        this.hdf5ErrorStackString = this.retrieveHDF5ErrorStackAsString();
        this.hdf5ErrorStackLastElementString = HDF5LibraryException.getLastErrorStackElement(this.hdf5ErrorStackString);
    }

    public HDF5LibraryException(String s) {
        super(s);
        try {
            H5.H5open();
        }
        catch (Exception exception) {}
        this.majorErrorNumber = this._getMajorErrorNumber();
        this.minorErrorNumber = this._getMinorErrorNumber();
        this.hdf5ErrorStackString = this.retrieveHDF5ErrorStackAsString();
        this.hdf5ErrorStackLastElementString = HDF5LibraryException.getLastErrorStackElement(this.hdf5ErrorStackString);
    }

    private String retrieveHDF5ErrorStackAsString() {
        String string;
        File tempFile = File.createTempFile("HDF5_error_stack", ".txt");
        try {
            this.printStackTrace0(tempFile.getPath());
            string = new String(Files.readAllBytes(tempFile.toPath()));
            tempFile.delete();
        }
        catch (Throwable throwable) {
            try {
                tempFile.delete();
                throw throwable;
            }
            catch (IOException ex) {
                System.err.println("Cannot create error stack file.");
                ex.printStackTrace();
                return null;
            }
        }
        return string;
    }

    private static String getLastErrorStackElement(String hdf5ErrorStackString) {
        int idx = hdf5ErrorStackString.length() - 3;
        int lastLineBreakIdx = hdf5ErrorStackString.length();
        while (--idx > 0) {
            if (hdf5ErrorStackString.charAt(idx) == '\n') {
                lastLineBreakIdx = idx;
            }
            if (!hdf5ErrorStackString.substring(idx - 1, idx + 3).equals("\n  #")) continue;
            idx += 3;
            while (idx < hdf5ErrorStackString.length() && hdf5ErrorStackString.charAt(idx) != ' ') {
                ++idx;
            }
            return hdf5ErrorStackString.substring(idx + 1, lastLineBreakIdx);
        }
        return null;
    }

    private native long _getMajorErrorNumber();

    private native long _getMinorErrorNumber();

    @Override
    public String getMessage() {
        if (this.hdf5ErrorStackLastElementString != null) {
            return String.valueOf(super.getMessage()) + " [\"" + this.hdf5ErrorStackLastElementString + "\"]";
        }
        return super.getMessage();
    }

    public long getMajorErrorNumber() {
        return this.majorErrorNumber;
    }

    public long getMinorErrorNumber() {
        return this.minorErrorNumber;
    }

    public String getMinorError(long err_code) {
        if (err_code == 0L) {
            return "special zero no error";
        }
        if (err_code == HDF5Constants.H5E_UNINITIALIZED) {
            return "information is unitialized";
        }
        if (err_code == HDF5Constants.H5E_UNSUPPORTED) {
            return "feature is unsupported";
        }
        if (err_code == HDF5Constants.H5E_BADTYPE) {
            return "incorrect type found";
        }
        if (err_code == HDF5Constants.H5E_BADRANGE) {
            return "argument out of range";
        }
        if (err_code == HDF5Constants.H5E_BADVALUE) {
            return "bad value for argument";
        }
        if (err_code == HDF5Constants.H5E_NOSPACE) {
            return "no space available for allocation";
        }
        if (err_code == HDF5Constants.H5E_CANTCOPY) {
            return "unable to copy object";
        }
        if (err_code == HDF5Constants.H5E_CANTFREE) {
            return "unable to free object";
        }
        if (err_code == HDF5Constants.H5E_ALREADYEXISTS) {
            return "Object already exists";
        }
        if (err_code == HDF5Constants.H5E_CANTLOCK) {
            return "Unable to lock object";
        }
        if (err_code == HDF5Constants.H5E_CANTUNLOCK) {
            return "Unable to unlock object";
        }
        if (err_code == HDF5Constants.H5E_FILEEXISTS) {
            return "file already exists";
        }
        if (err_code == HDF5Constants.H5E_FILEOPEN) {
            return "file already open";
        }
        if (err_code == HDF5Constants.H5E_CANTCREATE) {
            return "Can't create file";
        }
        if (err_code == HDF5Constants.H5E_CANTOPENFILE) {
            return "Can't open file";
        }
        if (err_code == HDF5Constants.H5E_CANTCLOSEFILE) {
            return "Can't close file";
        }
        if (err_code == HDF5Constants.H5E_NOTHDF5) {
            return "not an HDF5 format file";
        }
        if (err_code == HDF5Constants.H5E_BADFILE) {
            return "bad file ID accessed";
        }
        if (err_code == HDF5Constants.H5E_TRUNCATED) {
            return "file has been truncated";
        }
        if (err_code == HDF5Constants.H5E_MOUNT) {
            return "file mount error";
        }
        if (err_code == HDF5Constants.H5E_SEEKERROR) {
            return "seek failed";
        }
        if (err_code == HDF5Constants.H5E_READERROR) {
            return "read failed";
        }
        if (err_code == HDF5Constants.H5E_WRITEERROR) {
            return "write failed";
        }
        if (err_code == HDF5Constants.H5E_CLOSEERROR) {
            return "close failed";
        }
        if (err_code == HDF5Constants.H5E_OVERFLOW) {
            return "address overflowed";
        }
        if (err_code == HDF5Constants.H5E_FCNTL) {
            return "file fcntl failed";
        }
        if (err_code == HDF5Constants.H5E_CANTINIT) {
            return "Can't initialize object";
        }
        if (err_code == HDF5Constants.H5E_ALREADYINIT) {
            return "object already initialized";
        }
        if (err_code == HDF5Constants.H5E_CANTRELEASE) {
            return "Can't release object";
        }
        if (err_code == HDF5Constants.H5E_BADATOM) {
            return "Can't find atom information";
        }
        if (err_code == HDF5Constants.H5E_BADGROUP) {
            return "Can't find group information";
        }
        if (err_code == HDF5Constants.H5E_CANTREGISTER) {
            return "Can't register new atom";
        }
        if (err_code == HDF5Constants.H5E_CANTINC) {
            return "Can't increment reference count";
        }
        if (err_code == HDF5Constants.H5E_CANTDEC) {
            return "Can't decrement reference count";
        }
        if (err_code == HDF5Constants.H5E_NOIDS) {
            return "Out of IDs for group";
        }
        if (err_code == HDF5Constants.H5E_CANTFLUSH) {
            return "Can't flush object from cache";
        }
        if (err_code == HDF5Constants.H5E_CANTLOAD) {
            return "Can't load object into cache";
        }
        if (err_code == HDF5Constants.H5E_PROTECT) {
            return "protected object error";
        }
        if (err_code == HDF5Constants.H5E_NOTCACHED) {
            return "object not currently cached";
        }
        if (err_code == HDF5Constants.H5E_NOTFOUND) {
            return "object not found";
        }
        if (err_code == HDF5Constants.H5E_EXISTS) {
            return "object already exists";
        }
        if (err_code == HDF5Constants.H5E_CANTENCODE) {
            return "Can't encode value";
        }
        if (err_code == HDF5Constants.H5E_CANTDECODE) {
            return "Can't decode value";
        }
        if (err_code == HDF5Constants.H5E_CANTSPLIT) {
            return "Can't split node";
        }
        if (err_code == HDF5Constants.H5E_CANTINSERT) {
            return "Can't insert object";
        }
        if (err_code == HDF5Constants.H5E_CANTLIST) {
            return "Can't list node";
        }
        if (err_code == HDF5Constants.H5E_LINKCOUNT) {
            return "bad object header link count";
        }
        if (err_code == HDF5Constants.H5E_VERSION) {
            return "wrong version number";
        }
        if (err_code == HDF5Constants.H5E_ALIGNMENT) {
            return "alignment error";
        }
        if (err_code == HDF5Constants.H5E_BADMESG) {
            return "unrecognized message";
        }
        if (err_code == HDF5Constants.H5E_CANTDELETE) {
            return " Can't delete message";
        }
        if (err_code == HDF5Constants.H5E_CANTOPENOBJ) {
            return "Can't open object";
        }
        if (err_code == HDF5Constants.H5E_COMPLEN) {
            return "name component is too long";
        }
        if (err_code == HDF5Constants.H5E_LINK) {
            return "link count failure";
        }
        if (err_code == HDF5Constants.H5E_CANTCONVERT) {
            return "Can't convert datatypes";
        }
        if (err_code == HDF5Constants.H5E_BADSIZE) {
            return "Bad size for object";
        }
        if (err_code == HDF5Constants.H5E_CANTCLIP) {
            return "Can't clip hyperslab region";
        }
        if (err_code == HDF5Constants.H5E_CANTCOUNT) {
            return "Can't count elements";
        }
        if (err_code == HDF5Constants.H5E_CANTSELECT) {
            return "Can't select hyperslab";
        }
        if (err_code == HDF5Constants.H5E_CANTNEXT) {
            return "Can't move to next iterator location";
        }
        if (err_code == HDF5Constants.H5E_BADSELECT) {
            return "Invalid selection";
        }
        if (err_code == HDF5Constants.H5E_CANTGET) {
            return "Can't get value";
        }
        if (err_code == HDF5Constants.H5E_CANTSET) {
            return "Can't set value";
        }
        if (err_code == HDF5Constants.H5E_DUPCLASS) {
            return "Duplicate class name in parent class";
        }
        if (err_code == HDF5Constants.H5E_MPI) {
            return "some MPI function failed";
        }
        if (err_code == HDF5Constants.H5E_MPIERRSTR) {
            return "MPI Error String";
        }
        if (err_code == HDF5Constants.H5E_NOFILTER) {
            return "requested filter is not available";
        }
        if (err_code == HDF5Constants.H5E_CALLBACK) {
            return "callback failed";
        }
        if (err_code == HDF5Constants.H5E_CANAPPLY) {
            return "error from filter \"can apply\" callback";
        }
        if (err_code == HDF5Constants.H5E_SETLOCAL) {
            return "error from filter \"set local\" callback";
        }
        return "undefined error(" + err_code + ")";
    }

    public String getHDF5ErrorStackAsString() {
        return this.hdf5ErrorStackString;
    }

    @Override
    public void printStackTrace() {
        System.err.println(this);
        System.err.println(this.getHDF5ErrorStackAsString());
        super.printStackTrace();
    }

    public void printStackTrace(File f) {
        if (f == null || !f.exists() || f.isDirectory() || !f.canWrite()) {
            this.printStackTrace();
        } else {
            try {
                FileOutputStream o = new FileOutputStream(f);
                PrintWriter p = new PrintWriter(o);
                p.println(this);
                p.println(this.getHDF5ErrorStackAsString());
                super.printStackTrace(p);
                p.close();
            }
            catch (Exception exception) {
                System.err.println(this);
            }
        }
    }

    private native void printStackTrace0(String var1);
}

