/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz;

import Ice.Communicator;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.Util;
import java.util.concurrent.locks.ReentrantLock;
import ome.services.blitz.Status;
import ome.system.OmeroContext;
import ome.util.messages.InternalMessage;
import ome.util.messages.ShutdownMessage;
import ome.util.messages.UserSignalMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class Entry {
    private static final Logger log = LoggerFactory.getLogger(Entry.class);
    int status = -1;
    final String name;
    final ReentrantLock lock = new ReentrantLock();
    volatile OmeroContext ctx = null;
    volatile Communicator ic = null;

    private static void waitOnStartup() {
        int ms = 10000;
        try {
            String prop = System.getenv("OMERO_STARTUP_WAIT");
            ms = Integer.valueOf(prop);
        }
        catch (Exception e) {
            log.debug(e.toString());
        }
        try {
            log.info(String.format("Waiting %s ms on startup", ms));
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.debug(e.toString());
        }
    }

    public static void main(String[] args) {
        String name = "OMERO.blitz";
        if (args != null && args.length > 0) {
            if ("-s".equals(args[0])) {
                try {
                    new Status(args).run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(1);
                }
                System.exit(0);
            }
            for (String string : args) {
                if (string.startsWith("--Ice.Config")) {
                    System.setProperty("ICE_CONFIG", string.substring(13));
                    continue;
                }
                name = string;
                Entry.waitOnStartup();
            }
        }
        final Entry instance = new Entry(name);
        SignalHandler handler = new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                log.info(sig.getName() + ": Shutdown requested.");
                instance.lock.lock();
                try {
                    instance.status = sig.getNumber();
                    instance.shutdown(true);
                }
                finally {
                    instance.lock.unlock();
                }
            }
        };
        Entry.registerSignal(handler, "INT");
        Entry.registerSignal(handler, "TERM");
        Entry.registerSignal(handler, "BREAK");
        class UserSignalHandler
        implements SignalHandler {
            int signal;

            UserSignalHandler(int signal) {
                this.signal = signal;
            }

            @Override
            public void handle(Signal arg0) {
                try {
                    UserSignalMessage msg = new UserSignalMessage((Object)this, this.signal);
                    instance.ctx.publishMessage((InternalMessage)msg);
                }
                catch (Throwable e) {
                    log.error("Error on user signal " + this.signal, e);
                }
            }
        }
        Entry.registerSignal(new UserSignalHandler(1), "USR1");
        Entry.registerSignal(new UserSignalHandler(2), "USR2");
        instance.start();
    }

    private static void registerSignal(SignalHandler handler, String sig) {
        try {
            Signal.handle(new Signal(sig), handler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Entry(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            log.info("Creating " + this.name + ". Please wait...");
            String ICE_CONFIG = System.getProperty("ICE_CONFIG");
            InitializationData id = new InitializationData();
            id.properties = Util.createProperties();
            if (ICE_CONFIG != null) {
                id.properties.load(ICE_CONFIG);
                for (String k : id.properties.getPropertiesForPrefix("omero").keySet()) {
                    System.setProperty(k, id.properties.getProperty(k));
                }
            }
            this.ctx = OmeroContext.getInstance((String)this.name);
            if (this.ctx.containsBean("Ice.Communicator")) {
                this.ic = (Communicator)this.ctx.getBean("Ice.Communicator");
            } else {
                this.ic = Util.initialize((InitializationData)id);
                String adapterName = (String)this.ctx.getBean("adapterName", String.class);
                ObjectAdapter oa = this.ic.createObjectAdapter(adapterName);
                oa.activate();
            }
            log.info(this.name + " now accepting connections.");
            this.ic.waitForShutdown();
            this.status = 0;
        }
        catch (LocalException e) {
            log.error("Error on startup.", (Throwable)e);
            this.status = 1;
        }
        catch (Exception e) {
            log.error("Error on startup.", (Throwable)e);
            this.status = 2;
        }
        System.out.flush();
        System.err.flush();
        this.lock.lock();
        try {
            this.shutdown(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int status() {
        return this.status;
    }

    public void shutdown(boolean callSystemExit) {
        if (this.ctx != null) {
            try {
                this.ctx.publishMessage((InternalMessage)new ShutdownMessage((Object)this));
                log.info("Calling close on context " + this.name);
                OmeroContext forClose = this.ctx;
                this.ctx = null;
                forClose.closeAll();
                log.info("Finished shutdown.");
            }
            catch (Throwable t) {
                log.error("Error shutting down " + this.name, t);
                this.status = 3;
            }
        }
        if (callSystemExit) {
            System.exit(this.status);
        }
    }
}

