/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import Ice.Identity;
import Ice.TieBase;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ome.conditions.InternalException;
import omero.OverUsageException;
import omero.api._StatefulServiceInterfaceOperations;
import omero.util.IceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServantHolder {
    private static final Logger log = LoggerFactory.getLogger(ServantHolder.class);
    private final Map<String, Ice.Object> servants;
    private final LoadingCache<String, Lock> locks = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Lock>(){

        public Lock load(String key) {
            return new ReentrantLock();
        }
    });
    protected final Map<String, Object> clientIds;
    private final String session;
    private final int servantsPerSession;

    public ServantHolder(String session) {
        this(session, 10000);
    }

    public ServantHolder(String session, int servantsPerSession) {
        MapMaker mapMaker = new MapMaker();
        this.servants = mapMaker.makeMap();
        this.clientIds = mapMaker.makeMap();
        this.session = session;
        this.servantsPerSession = servantsPerSession;
    }

    public String getSession() {
        return this.session;
    }

    public Identity getIdentity(String idName) {
        Identity id = new Identity();
        id.category = this.session;
        id.name = idName;
        return id;
    }

    public void addClientId(String clientId) {
        this.clientIds.put(clientId, Boolean.TRUE);
    }

    public void removeClientId(String clientId) {
        this.clientIds.remove(clientId);
    }

    public Set<String> getClientIds() {
        return this.clientIds.keySet();
    }

    public void acquireLock(String key) {
        try {
            ((Lock)this.locks.get((Object)key)).lock();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void releaseLock(String key) {
        Lock lock = (Lock)this.locks.getIfPresent((Object)key);
        if (lock == null) {
            throw new InternalException("No lock found: " + key);
        }
        lock.unlock();
    }

    public Ice.Object get(Identity id) {
        return this.get(id.name);
    }

    public Object getUntied(Identity id) {
        Ice.Object servantOrTie = this.get(id.name);
        if (servantOrTie instanceof TieBase) {
            return ((TieBase)servantOrTie).ice_delegate();
        }
        return servantOrTie;
    }

    public void put(Identity id, Ice.Object servant) throws OverUsageException {
        int size = this.servants.size();
        if (size >= this.servantsPerSession) {
            String msg = String.format("servantsPerSession reached for %s: %s", this.session, this.servantsPerSession);
            log.error(msg);
            OverUsageException oue = new OverUsageException();
            IceMapper.fillServerError(oue, (Throwable)new ome.conditions.OverUsageException(msg));
            throw oue;
        }
        double percent = 100.0 * (double)size / (double)this.servantsPerSession;
        if (percent > 0.0 && percent % 10.0 == 0.0) {
            log.warn(String.format("%s%% of servants used for session %s", (int)percent, this.session));
        }
        this.put(id.name, servant);
    }

    public Ice.Object remove(Identity id) {
        return this.remove(id.name);
    }

    public List<String> getServantList() {
        return new ArrayList<String>(this.servants.keySet());
    }

    public String getStatefulServiceCount() {
        String list = "";
        List<String> servants = this.getServantList();
        for (String idName : servants) {
            Identity id = this.getIdentity(idName);
            Object servant = this.getUntied(id);
            if (servant == null) continue;
            try {
                if (!(servant instanceof _StatefulServiceInterfaceOperations)) continue;
                list = list + "\n" + idName;
            }
            catch (Exception exception) {}
        }
        return list;
    }

    private void put(String key, Ice.Object servant) {
        Ice.Object old = this.servants.put(key, servant);
        if (old == null) {
            log.debug(String.format("Added %s to %s as %s", servant, this, key));
        } else {
            log.debug(String.format("Replaced %s with %s to %s as %s", old, servant, this, key));
        }
    }

    private Ice.Object remove(String key) {
        Ice.Object servant = this.servants.remove(key);
        log.debug(String.format("Removed %s from %s as %s", servant, this, key));
        return servant;
    }

    private Ice.Object get(String key) {
        return this.servants.get(key);
    }
}

