/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway;

import Ice.ObjectNotExistException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import ome.formats.OMEROMetadataStoreClient;
import omero.ServerError;
import omero.api.ExporterPrx;
import omero.api.ExporterPrxHelper;
import omero.api.IAdminPrx;
import omero.api.IAdminPrxHelper;
import omero.api.IConfigPrx;
import omero.api.IConfigPrxHelper;
import omero.api.IContainerPrx;
import omero.api.IContainerPrxHelper;
import omero.api.IMetadataPrx;
import omero.api.IMetadataPrxHelper;
import omero.api.IPixelsPrx;
import omero.api.IPixelsPrxHelper;
import omero.api.IProjectionPrx;
import omero.api.IProjectionPrxHelper;
import omero.api.IQueryPrx;
import omero.api.IQueryPrxHelper;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRenderingSettingsPrxHelper;
import omero.api.IRepositoryInfoPrx;
import omero.api.IRepositoryInfoPrxHelper;
import omero.api.IRoiPrx;
import omero.api.IRoiPrxHelper;
import omero.api.IScriptPrx;
import omero.api.IScriptPrxHelper;
import omero.api.ISessionPrx;
import omero.api.ITypesPrx;
import omero.api.ITypesPrxHelper;
import omero.api.IUpdatePrx;
import omero.api.IUpdatePrxHelper;
import omero.api.RawFileStorePrx;
import omero.api.RawFileStorePrxHelper;
import omero.api.RawPixelsStorePrx;
import omero.api.RawPixelsStorePrxHelper;
import omero.api.RenderingEnginePrx;
import omero.api.SearchPrx;
import omero.api.SearchPrxHelper;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.api.ThumbnailStorePrxHelper;
import omero.client;
import omero.cmd.CmdCallbackI;
import omero.cmd.DoAll;
import omero.cmd.Request;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.grid.SharedResourcesPrx;
import omero.grid.SharedResourcesPrxHelper;
import omero.log.LogMessage;
import omero.log.Logger;
import omero.model.ExperimenterGroup;
import omero.model.Session;
import omero.sys.Principal;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

class Connector {
    private final int ELAPSED_TIME = 30000;
    private final AtomicLong lastKeepAlive = new AtomicLong(System.currentTimeMillis());
    private final client secureClient;
    private client unsecureClient;
    private ServiceFactoryPrx entryEncrypted;
    private ServiceFactoryPrx entryUnencrypted;
    private final Map<String, ServiceInterfacePrx> statelessServices;
    private final Multimap<String, StatefulServiceInterfacePrx> statefulServices;
    private OMEROMetadataStoreClient importStore;
    private final Multimap<Long, RenderingEnginePrx> reServices;
    private final SecurityContext context;
    private final Cache<String, Connector> derived;
    private String groupName;
    private final Logger logger;
    private String username = null;
    private boolean isSessionLogin = false;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    Connector(SecurityContext context, client client2, ServiceFactoryPrx entryEncrypted, boolean encrypted, boolean sessionLogin, Logger logger) throws Exception {
        this(context, client2, entryEncrypted, encrypted, sessionLogin, null, logger);
    }

    Connector(SecurityContext context, client client2, ServiceFactoryPrx entryEncrypted, boolean encrypted, boolean sessionLogin, String username, Logger logger) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("No Security context.");
        }
        if (client2 == null) {
            throw new IllegalArgumentException("No Server entry point.");
        }
        if (entryEncrypted == null) {
            throw new IllegalArgumentException("No Services entry point.");
        }
        if (!encrypted) {
            this.unsecureClient = client2.createClient(false);
            this.entryUnencrypted = this.unsecureClient.getSession();
        } else {
            this.unsecureClient = null;
            this.entryUnencrypted = null;
        }
        this.username = username;
        this.logger = logger;
        this.secureClient = client2;
        this.entryEncrypted = entryEncrypted;
        this.isSessionLogin = sessionLogin;
        this.context = context;
        MapMaker mapMaker = new MapMaker();
        this.statelessServices = mapMaker.makeMap();
        this.statefulServices = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        this.reServices = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        this.derived = CacheBuilder.newBuilder().build();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    SharedResourcesPrx getSharedResources() throws DSOutOfServiceException {
        return SharedResourcesPrxHelper.uncheckedCast(this.get("omero.grid.SharedResources", true));
    }

    IRenderingSettingsPrx getRenderingSettingsService() throws DSOutOfServiceException {
        return IRenderingSettingsPrxHelper.uncheckedCast(this.get("omero.api.IRenderingSettings", this.unsecureClient == null));
    }

    IRepositoryInfoPrx getRepositoryService() throws DSOutOfServiceException {
        return IRepositoryInfoPrxHelper.uncheckedCast(this.get("omero.api.IRepositoryInfo", this.unsecureClient == null));
    }

    IScriptPrx getScriptService() throws DSOutOfServiceException {
        return IScriptPrxHelper.uncheckedCast(this.get("omero.api.IScript", this.unsecureClient == null));
    }

    IContainerPrx getPojosService() throws DSOutOfServiceException {
        return IContainerPrxHelper.uncheckedCast(this.get("omero.api.IContainer", this.unsecureClient == null));
    }

    IQueryPrx getQueryService() throws DSOutOfServiceException {
        return IQueryPrxHelper.uncheckedCast(this.get("omero.api.IQuery", this.unsecureClient == null));
    }

    IUpdatePrx getUpdateService() throws DSOutOfServiceException {
        return IUpdatePrxHelper.uncheckedCast(this.get("omero.api.IUpdate", this.unsecureClient == null));
    }

    IMetadataPrx getMetadataService() throws DSOutOfServiceException {
        return IMetadataPrxHelper.uncheckedCast(this.get("omero.api.IMetadata", this.unsecureClient == null));
    }

    IRoiPrx getROIService() throws DSOutOfServiceException {
        return IRoiPrxHelper.uncheckedCast(this.get("omero.api.IRoi", this.unsecureClient == null));
    }

    IConfigPrx getConfigService() throws DSOutOfServiceException {
        return IConfigPrxHelper.uncheckedCast(this.get("omero.api.IConfig", this.unsecureClient == null));
    }

    ThumbnailStorePrx getThumbnailService() throws DSOutOfServiceException {
        return ThumbnailStorePrxHelper.uncheckedCast(this.create("omero.api.ThumbnailStore", this.unsecureClient == null));
    }

    ExporterPrx getExporterService() throws DSOutOfServiceException {
        return ExporterPrxHelper.uncheckedCast(this.create("omero.api.Exporter", this.unsecureClient == null));
    }

    RawFileStorePrx getRawFileService() throws DSOutOfServiceException {
        return RawFileStorePrxHelper.uncheckedCast(this.create("omero.api.RawFileStore", this.unsecureClient == null));
    }

    RawPixelsStorePrx getPixelsStore() throws DSOutOfServiceException {
        return RawPixelsStorePrxHelper.uncheckedCast(this.create("omero.api.RawPixelsStore", this.unsecureClient == null));
    }

    IPixelsPrx getPixelsService() throws DSOutOfServiceException {
        return IPixelsPrxHelper.uncheckedCast(this.get("omero.api.IPixels", this.unsecureClient == null));
    }

    ITypesPrx getTypesService() throws DSOutOfServiceException {
        return ITypesPrxHelper.uncheckedCast(this.get("omero.api.ITypes", this.unsecureClient == null));
    }

    SearchPrx getSearchService() throws DSOutOfServiceException {
        return SearchPrxHelper.uncheckedCast(this.create("omero.api.Search", this.unsecureClient == null));
    }

    IProjectionPrx getProjectionService() throws DSOutOfServiceException {
        return IProjectionPrxHelper.uncheckedCast(this.get("omero.api.IProjection", this.unsecureClient == null));
    }

    IAdminPrx getAdminService() throws DSOutOfServiceException {
        return this.getAdminService(this.unsecureClient == null);
    }

    IAdminPrx getAdminService(boolean secure) throws DSOutOfServiceException {
        return IAdminPrxHelper.uncheckedCast(this.get("omero.api.IAdmin", secure));
    }

    OMEROMetadataStoreClient getImportStore() throws DSOutOfServiceException {
        if (this.importStore != null) {
            return this.importStore;
        }
        OMEROMetadataStoreClient importStore = new OMEROMetadataStoreClient();
        try {
            if (this.entryUnencrypted != null) {
                importStore.initialize(this.entryUnencrypted);
            } else {
                importStore.initialize(this.entryEncrypted);
            }
            this.pcs.firePropertyChange("PROP_IMPORTSTORE_CREATED", null, importStore);
            this.importStore = importStore;
            return importStore;
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Failed to create import store", e);
        }
    }

    RenderingEnginePrx getRenderingService(long pixelsID, float compression) throws DSOutOfServiceException, ServerError {
        RenderingEnginePrx prx = null;
        try {
            prx = this.entryUnencrypted != null ? this.entryUnencrypted.createRenderingEngine() : this.entryEncrypted.createRenderingEngine();
            this.pcs.firePropertyChange("PROP_RENDERINGENGINE_CREATED", null, prx);
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Could not get rendering engine", e);
        }
        prx.setCompressionLevel(compression);
        this.reServices.put((Object)pixelsID, (Object)prx);
        return prx;
    }

    void joinSession() throws Throwable {
        String uuid = this.secureClient.getSessionId();
        this.statelessServices.clear();
        this.reServices.clear();
        this.statefulServices.clear();
        this.secureClient.closeSession();
        if (this.unsecureClient != null) {
            this.unsecureClient.closeSession();
        }
        this.entryEncrypted = this.secureClient.joinSession(uuid);
        if (this.unsecureClient != null) {
            this.unsecureClient = null;
            this.entryUnencrypted = null;
            this.unsecureClient = this.secureClient.createClient(false);
            this.entryUnencrypted = this.unsecureClient.getSession();
        }
    }

    long getGroupID() {
        return this.context.getGroupID();
    }

    void close(boolean networkup) {
        this.secureClient.setFastShutdown(!networkup);
        if (this.unsecureClient != null) {
            this.unsecureClient.setFastShutdown(!networkup);
        }
        if (networkup) {
            this.shutDownServices(true);
        }
        String id = this.secureClient.getSessionId();
        String PROP = "PROP_SESSION_CLOSED";
        if (this.isSessionLogin) {
            try {
                this.secureClient.getSession().detachOnDestroy();
                if (this.unsecureClient != null) {
                    this.unsecureClient.getSession().detachOnDestroy();
                }
            }
            catch (ServerError e) {
                this.logger.warn((Object)this, new LogMessage("Could not detach from server session", (Throwable)((Object)e)));
            }
            PROP = "PROP_SESSION_DETACHED";
        }
        this.secureClient.__del__();
        this.pcs.firePropertyChange(PROP, null, id);
        if (this.unsecureClient != null) {
            id = this.unsecureClient.getSessionId();
            this.unsecureClient.__del__();
            this.pcs.firePropertyChange(PROP, null, id);
        }
        if (this.username == null) {
            this.pcs.firePropertyChange("PROP_CONNECTOR_CLOSED", null, id);
        } else {
            this.pcs.firePropertyChange("PROP_CONNECTOR_CLOSED", null, id + "_" + this.username);
        }
        this.closeDerived(networkup);
    }

    void closeImport() {
        this.shutdownImports();
        try {
            this.closeDerived(false);
        }
        catch (Throwable e) {
            this.logger.warn((Object)this, new LogMessage("Exception on closeDerived: ", e));
        }
    }

    void closeDerived(boolean networkup) {
        for (Connector c : this.derived.asMap().values()) {
            try {
                c.close(networkup);
            }
            catch (Throwable e) {
                this.logger.warn((Object)this, String.format("Failed to close(%s) service: %s", networkup, c));
            }
        }
        this.derived.invalidateAll();
    }

    void shutDownServices(boolean rendering) {
        this.shutdownStateful();
        this.shutdownImports();
        if (!rendering) {
            return;
        }
        HashSet tmp = new HashSet(this.reServices.keySet());
        for (Long pixelsId : tmp) {
            this.shutDownRenderingEngine(pixelsId);
        }
    }

    boolean keepSessionAlive() {
        boolean success = true;
        try {
            this.entryEncrypted.keepAllAlive(null);
        }
        catch (Exception e) {
            success = false;
            this.logger.warn((Object)this, new LogMessage("Failed encrypted keep alive: ", e));
        }
        try {
            if (this.entryUnencrypted != null && success) {
                this.entryUnencrypted.keepAllAlive(null);
            }
        }
        catch (Exception e) {
            success = false;
            this.logger.warn((Object)this, new LogMessage("failed unencrypted keep alive: ", e));
        }
        if (success) {
            this.lastKeepAlive.set(System.currentTimeMillis());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(StatefulServiceInterfacePrx proxy) {
        if (proxy == null) {
            return;
        }
        try {
            proxy.close();
        }
        catch (ObjectNotExistException keys) {
            if (proxy instanceof RenderingEnginePrx) {
                this.pcs.firePropertyChange("PROP_RENDERINGENGINE_CLOSED", null, proxy);
                Set keys2 = this.reServices.keySet();
                keys2 = Sets.newHashSet((Iterable)keys2);
                for (Long key : keys2) {
                    this.reServices.remove((Object)key, (Object)proxy);
                }
            } else {
                this.pcs.firePropertyChange("PROP_SERVICE_CLOSED", null, proxy);
                Set keys3 = this.statefulServices.keySet();
                keys3 = Sets.newHashSet((Iterable)keys3);
                for (String key : keys3) {
                    this.statefulServices.remove((Object)key, (Object)proxy);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)this, new LogMessage("Failed to close " + proxy, e));
        }
        finally {
            if (proxy instanceof RenderingEnginePrx) {
                this.pcs.firePropertyChange("PROP_RENDERINGENGINE_CLOSED", null, proxy);
                Set keys = this.reServices.keySet();
                keys = Sets.newHashSet((Iterable)keys);
                for (Long key : keys) {
                    this.reServices.remove((Object)key, (Object)proxy);
                }
            } else {
                this.pcs.firePropertyChange("PROP_SERVICE_CLOSED", null, proxy);
                Set keys = this.statefulServices.keySet();
                keys = Sets.newHashSet((Iterable)keys);
                for (String key : keys) {
                    this.statefulServices.remove((Object)key, (Object)proxy);
                }
            }
        }
    }

    void shutDownRenderingEngine(long pixelsId) {
        Collection proxies = this.reServices.removeAll((Object)pixelsId);
        for (RenderingEnginePrx prx : proxies) {
            this.close(prx);
        }
    }

    void shutdownImports() {
        if (this.importStore != null) {
            try {
                this.importStore.closeServices();
                this.importStore = null;
                this.pcs.firePropertyChange("PROP_IMPORTSTORE_CLOSED", null, this.importStore);
            }
            catch (Exception e) {
                this.logger.warn((Object)this, new LogMessage("Failed to close import store:", e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownStateful() {
        Collection proxies = null;
        Multimap<String, StatefulServiceInterfacePrx> multimap = this.statefulServices;
        synchronized (multimap) {
            proxies = this.statefulServices.values();
            this.statefulServices.clear();
        }
        for (StatefulServiceInterfacePrx prx : proxies) {
            this.close(prx);
            this.pcs.firePropertyChange("PROP_SERVICE_CLOSED", null, prx);
        }
    }

    client getClient() {
        if (this.unsecureClient != null) {
            return this.unsecureClient;
        }
        return this.secureClient;
    }

    CmdCallbackI submit(List<Request> commands, SecurityContext target) throws ServerError {
        if (CollectionUtils.isEmpty(commands)) {
            return null;
        }
        DoAll all = new DoAll();
        all.requests = commands;
        HashMap<String, String> callContext = new HashMap<String, String>();
        if (target != null) {
            callContext.put("omero.group", "" + target.getGroupID());
        }
        if (this.entryUnencrypted != null) {
            return new CmdCallbackI(this.getClient(), this.entryUnencrypted.submit(all, callContext));
        }
        return new CmdCallbackI(this.getClient(), this.entryEncrypted.submit(all, callContext));
    }

    Map<SecurityContext, Set<Long>> getRenderingEngines() {
        HashMap<SecurityContext, Set<Long>> map = new HashMap<SecurityContext, Set<Long>>();
        HashSet<Long> list = new HashSet<Long>();
        Iterator i = this.reServices.keySet().iterator();
        while (i.hasNext()) {
            list.add((Long)i.next());
        }
        map.put(this.context, list);
        return map;
    }

    Connector getConnector(final String userName) throws ExecutionException {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return this;
        }
        return (Connector)this.derived.get((Object)userName, (Callable)new Callable<Connector>(){

            @Override
            public Connector call() throws Exception {
                if (Connector.this.groupName == null) {
                    ExperimenterGroup g = Connector.this.getAdminService().getGroup(Connector.this.context.getGroupID());
                    Connector.this.groupName = g.getName().getValue();
                }
                Principal p = new Principal();
                p.group = Connector.this.groupName;
                p.name = userName;
                p.eventType = "Sessions";
                ISessionPrx prx = Connector.this.entryEncrypted.getSessionService();
                Session session = prx.getSession(Connector.this.secureClient.getSessionId());
                long timeout = session.getTimeToIdle().getValue();
                session = prx.createSessionWithTimeouts(p, 0L, timeout);
                client client2 = new client(Connector.this.context.getServerInformation().getHost(), Connector.this.context.getServerInformation().getPort());
                ServiceFactoryPrx userSession = client2.createSession(session.getUuid().getValue(), session.getUuid().getValue());
                Connector.this.pcs.firePropertyChange("PROP_SESSION_CREATED", null, client2.getSessionId());
                Connector c = new Connector(Connector.this.context.copy(), client2, userSession, Connector.this.unsecureClient == null, Connector.this.isSessionLogin, userName, Connector.this.logger);
                for (PropertyChangeListener l : Connector.this.pcs.getPropertyChangeListeners()) {
                    c.addPropertyChangeListener(l);
                }
                Connector.this.pcs.firePropertyChange("PROP_CONNECTOR_CREATED", null, client2.getSessionId() + "_" + userName);
                Connector.this.logger.debug((Object)this, "Created derived connector: " + userName);
                return c;
            }
        });
    }

    void closeSessionOnExit(boolean closeSession) {
        this.isSessionLogin = !closeSession;
    }

    boolean needsKeepAlive() {
        long last = this.lastKeepAlive.get();
        long elapsed = System.currentTimeMillis() - last;
        return elapsed > 30000L;
    }

    private ServiceInterfacePrx get(String name, boolean secure) throws DSOutOfServiceException {
        try {
            ServiceInterfacePrx prx = this.statelessServices.get(name);
            if (!secure && prx != null) {
                return prx;
            }
            prx = !secure && this.entryUnencrypted != null ? this.entryUnencrypted.getByName(name) : this.entryEncrypted.getByName(name);
            this.statelessServices.put(name, prx);
            this.pcs.firePropertyChange("PROP_STATELESS_SERVICE_CREATED", null, prx);
            return prx;
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Could not load " + name, e);
        }
    }

    private StatefulServiceInterfacePrx create(String name, boolean secure) throws DSOutOfServiceException {
        try {
            StatefulServiceInterfacePrx prx = null;
            prx = !secure && this.entryUnencrypted != null ? this.entryUnencrypted.createByName(name) : this.entryEncrypted.createByName(name);
            this.statefulServices.put((Object)name, (Object)prx);
            this.pcs.firePropertyChange("PROP_SERVICE_CREATED", null, prx);
            return prx;
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Could not create " + name, e);
        }
    }
}

