/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import omero.gateway.model.MaskData;

class MaskClass {
    private Set<Point> points = new HashSet<Point>();
    private int colour;
    private Point min;
    private Point max;
    private int width;
    private int height;

    MaskClass(int value) {
        this.colour = value;
    }

    public Color getColour() {
        return new Color(this.colour);
    }

    byte[] asBytes() throws IOException {
        byte[] data = new byte[(int)Math.ceil((double)this.width * (double)this.height / 8.0)];
        int offset = 0;
        for (int y = this.min.y; y < this.max.y + 1; ++y) {
            for (int x = this.min.x; x < this.max.x + 1; ++x) {
                if (this.points.contains(new Point(x, y))) {
                    this.setBit(data, offset, 1);
                } else {
                    this.setBit(data, offset, 0);
                }
                ++offset;
            }
        }
        return data;
    }

    void add(Point p) {
        if (this.points.size() == 0) {
            this.min = new Point(p);
            this.max = new Point(p);
        } else {
            this.min.x = Math.min(p.x, this.min.x);
            this.min.y = Math.min(p.y, this.min.y);
            this.max.x = Math.max(p.x, this.max.x);
            this.max.y = Math.max(p.y, this.max.y);
        }
        this.width = this.max.x - this.min.x + 1;
        this.height = this.max.y - this.min.y + 1;
        this.points.add(p);
    }

    MaskData asMaskData(int z, int t, int c) throws IOException {
        MaskData mask = new MaskData();
        mask.setX(this.min.x);
        mask.setY(this.min.y);
        mask.setWidth(this.width);
        mask.setHeight(this.height);
        mask.setReadOnly(true);
        mask.setT(t);
        mask.setZ(z);
        mask.setC(c);
        mask.getShapeSettings().setFill(new Color(this.colour));
        mask.setMask(this.asBytes());
        return mask;
    }

    void setBit(byte[] data, int bit, int val) {
        int bytePosition = bit / 8;
        int bitPosition = 7 - bit % 8;
        data[bytePosition] = (byte)((byte)(data[bytePosition] & ~((byte)(1 << bitPosition))) | (byte)(val << bitPosition));
    }

    byte getBit(byte[] data, int bit) {
        int bytePosition = bit / 8;
        int bitPosition = 7 - bit % 8;
        return (byte)(data[bytePosition] & 1 << bitPosition) != 0 ? (byte)1 : 0;
    }
}

