/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.RLong;
import omero.cmd.Chgrp2;
import omero.cmd.Chmod2;
import omero.cmd.Chown2;
import omero.cmd.Delete2;
import omero.cmd.DiskUsage2;
import omero.cmd.Duplicate;
import omero.cmd.FindChildren;
import omero.cmd.FindParents;
import omero.cmd.GraphModify2;
import omero.cmd.GraphQuery;
import omero.cmd.SkipHead;
import omero.cmd.graphs.ChildOption;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.IObject;

public class Requests {
    private static String getModelClassName(Class<? extends IObject> modelClass) {
        if (modelClass != IObject.class) {
            Class<IObject> superclass;
            while ((superclass = modelClass.getSuperclass().asSubclass(IObject.class)) != IObject.class) {
                modelClass = superclass;
            }
        }
        return modelClass.getSimpleName();
    }

    public static ChildOptionBuilder option() {
        return new ChildOptionBuilder();
    }

    public static Chgrp2Builder chgrp() {
        return new Chgrp2Builder();
    }

    public static Chown2Builder chown() {
        return new Chown2Builder();
    }

    public static Chmod2Builder chmod() {
        return new Chmod2Builder();
    }

    public static Delete2Builder delete() {
        return new Delete2Builder();
    }

    public static DuplicateBuilder duplicate() {
        return new DuplicateBuilder();
    }

    public static FindParentsBuilder findParents() {
        return new FindParentsBuilder();
    }

    public static FindChildrenBuilder findChildren() {
        return new FindChildrenBuilder();
    }

    public static SkipHeadBuilder skipHead() {
        return new SkipHeadBuilder();
    }

    public static DiskUsageBuilder diskUsage() {
        return new DiskUsageBuilder();
    }

    public static class DiskUsageBuilder
    extends GraphQueryBuilder<DiskUsageBuilder, DiskUsage2> {
        DiskUsageBuilder() {
            super(new DiskUsage2());
            ((DiskUsage2)((Object)this.assembly)).targetClasses = new ArrayList<String>();
        }

        public DiskUsageBuilder type(Iterable<String> types) {
            for (String type : types) {
                ((DiskUsage2)((Object)this.assembly)).targetClasses.add(type);
            }
            return this;
        }

        public final DiskUsageBuilder type(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((DiskUsage2)((Object)this.assembly)).targetClasses.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public DiskUsageBuilder type(String ... types) {
            return this.type(Arrays.asList(types));
        }
    }

    public static class SkipHeadBuilder
    extends GraphModify2Builder<SkipHeadBuilder, SkipHead> {
        public SkipHeadBuilder() {
            super(new SkipHead());
            ((SkipHead)((Object)this.assembly)).startFrom = new ArrayList<String>();
        }

        public SkipHeadBuilder startFrom(Iterable<String> types) {
            for (String type : types) {
                ((SkipHead)((Object)this.assembly)).startFrom.add(type);
            }
            return this;
        }

        public final SkipHeadBuilder startFrom(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((SkipHead)((Object)this.assembly)).startFrom.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public final SkipHeadBuilder request(GraphModify2 request) {
            ((SkipHead)((Object)this.assembly)).request = request;
            return this;
        }

        public SkipHeadBuilder startFrom(String ... types) {
            return this.startFrom(Arrays.asList(types));
        }

        public final SkipHeadBuilder request(Class<? extends GraphModify2> request) {
            try {
                return this.request(request.newInstance());
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("invalid request class", e);
            }
        }
    }

    public static class FindChildrenBuilder
    extends GraphQueryBuilder<FindChildrenBuilder, FindChildren> {
        public FindChildrenBuilder() {
            super(new FindChildren());
            ((FindChildren)((Object)this.assembly)).typesOfChildren = new ArrayList<String>();
            ((FindChildren)((Object)this.assembly)).stopBefore = new ArrayList<String>();
        }

        public FindChildrenBuilder childType(Iterable<String> types) {
            for (String type : types) {
                ((FindChildren)((Object)this.assembly)).typesOfChildren.add(type);
            }
            return this;
        }

        public final FindChildrenBuilder childType(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((FindChildren)((Object)this.assembly)).typesOfChildren.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public FindChildrenBuilder stopBefore(Iterable<String> types) {
            for (String type : types) {
                ((FindChildren)((Object)this.assembly)).stopBefore.add(type);
            }
            return this;
        }

        public final FindChildrenBuilder stopBefore(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((FindChildren)((Object)this.assembly)).stopBefore.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public FindChildrenBuilder childType(String ... types) {
            return this.childType(Arrays.asList(types));
        }

        public FindChildrenBuilder stopBefore(String ... types) {
            return this.stopBefore(Arrays.asList(types));
        }
    }

    public static class FindParentsBuilder
    extends GraphQueryBuilder<FindParentsBuilder, FindParents> {
        public FindParentsBuilder() {
            super(new FindParents());
            ((FindParents)((Object)this.assembly)).typesOfParents = new ArrayList<String>();
            ((FindParents)((Object)this.assembly)).stopBefore = new ArrayList<String>();
        }

        public FindParentsBuilder parentType(Iterable<String> types) {
            for (String type : types) {
                ((FindParents)((Object)this.assembly)).typesOfParents.add(type);
            }
            return this;
        }

        public final FindParentsBuilder parentType(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((FindParents)((Object)this.assembly)).typesOfParents.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public FindParentsBuilder stopBefore(Iterable<String> types) {
            for (String type : types) {
                ((FindParents)((Object)this.assembly)).stopBefore.add(type);
            }
            return this;
        }

        public final FindParentsBuilder stopBefore(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((FindParents)((Object)this.assembly)).stopBefore.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public FindParentsBuilder parentType(String ... types) {
            return this.parentType(Arrays.asList(types));
        }

        public FindParentsBuilder stopBefore(String ... types) {
            return this.stopBefore(Arrays.asList(types));
        }
    }

    public static class DuplicateBuilder
    extends GraphModify2Builder<DuplicateBuilder, Duplicate> {
        public DuplicateBuilder() {
            super(new Duplicate());
            ((Duplicate)((Object)this.assembly)).typesToDuplicate = new ArrayList<String>();
            ((Duplicate)((Object)this.assembly)).typesToReference = new ArrayList<String>();
            ((Duplicate)((Object)this.assembly)).typesToIgnore = new ArrayList<String>();
        }

        public DuplicateBuilder duplicateType(Iterable<String> types) {
            for (String type : types) {
                ((Duplicate)((Object)this.assembly)).typesToDuplicate.add(type);
            }
            return this;
        }

        public final DuplicateBuilder duplicateType(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((Duplicate)((Object)this.assembly)).typesToDuplicate.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public DuplicateBuilder referenceType(Iterable<String> types) {
            for (String type : types) {
                ((Duplicate)((Object)this.assembly)).typesToReference.add(type);
            }
            return this;
        }

        public final DuplicateBuilder referenceType(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((Duplicate)((Object)this.assembly)).typesToReference.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public DuplicateBuilder ignoreType(Iterable<String> types) {
            for (String type : types) {
                ((Duplicate)((Object)this.assembly)).typesToIgnore.add(type);
            }
            return this;
        }

        public final DuplicateBuilder ignoreType(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((Duplicate)((Object)this.assembly)).typesToIgnore.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public DuplicateBuilder duplicateType(String ... types) {
            return this.duplicateType(Arrays.asList(types));
        }

        public DuplicateBuilder referenceType(String ... types) {
            return this.referenceType(Arrays.asList(types));
        }

        public DuplicateBuilder ignoreType(String ... types) {
            return this.ignoreType(Arrays.asList(types));
        }
    }

    public static class Delete2Builder
    extends GraphModify2Builder<Delete2Builder, Delete2> {
        public Delete2Builder() {
            super(new Delete2());
        }
    }

    public static class Chmod2Builder
    extends GraphModify2Builder<Chmod2Builder, Chmod2> {
        public Chmod2Builder() {
            super(new Chmod2());
        }

        public Chmod2Builder toPerms(String permissions) {
            ((Chmod2)((Object)this.assembly)).permissions = permissions;
            return this;
        }
    }

    public static class Chown2Builder
    extends GraphModify2Builder<Chown2Builder, Chown2> {
        public Chown2Builder() {
            super(new Chown2());
            ((Chown2)((Object)this.assembly)).targetUsers = new ArrayList<Long>();
        }

        public Chown2Builder toUser(long id) {
            ((Chown2)((Object)this.assembly)).userId = id;
            return this;
        }

        public Chown2Builder targetUsers(Iterable<Long> ids) {
            for (Long id : ids) {
                ((Chown2)((Object)this.assembly)).targetUsers.add(id);
            }
            return this;
        }

        public Chown2Builder targetUsers(RLong ... ids) {
            for (RLong id : ids) {
                ((Chown2)((Object)this.assembly)).targetUsers.add(id.getValue());
            }
            return this;
        }

        public Chown2Builder toUser(RLong id) {
            return this.toUser(id.getValue());
        }

        public Chown2Builder toUser(Experimenter user) {
            return this.toUser(user.getId());
        }

        public Chown2Builder targetUsers(Long ... ids) {
            return this.targetUsers(Arrays.asList(ids));
        }

        public Chown2Builder targetUsers(Experimenter user) {
            return this.targetUsers(user.getId());
        }
    }

    public static class Chgrp2Builder
    extends GraphModify2Builder<Chgrp2Builder, Chgrp2> {
        public Chgrp2Builder() {
            super(new Chgrp2());
        }

        public Chgrp2Builder toGroup(long id) {
            ((Chgrp2)((Object)this.assembly)).groupId = id;
            return this;
        }

        public Chgrp2Builder toGroup(RLong id) {
            return this.toGroup(id.getValue());
        }

        public Chgrp2Builder toGroup(ExperimenterGroup group) {
            return this.toGroup(group.getId());
        }
    }

    private static abstract class GraphModify2Builder<B extends GraphModify2Builder<B, R>, R extends GraphModify2>
    extends GraphQueryBuilder<B, R> {
        GraphModify2Builder(R assembly) {
            super(assembly);
            ((GraphModify2)((Object)assembly)).childOptions = new ArrayList<ChildOption>();
        }

        public B option(Iterable<ChildOption> options) {
            for (ChildOption option : options) {
                ((GraphModify2)((Object)this.assembly)).childOptions.add(option);
            }
            return (B)this;
        }

        public B dryRun(boolean dryRun) {
            ((GraphModify2)((Object)this.assembly)).dryRun = dryRun;
            return (B)this;
        }

        public B option(ChildOption ... options) {
            return this.option(Arrays.asList(options));
        }

        public B dryRun() {
            return this.dryRun(true);
        }
    }

    private static abstract class GraphQueryBuilder<B extends GraphQueryBuilder<B, R>, R extends GraphQuery>
    extends Builder<R> {
        private String targetObjectClass = null;
        private SetMultimap<String, Long> allTargets = HashMultimap.create();

        GraphQueryBuilder(R assembly) {
            super(assembly);
            ((GraphQuery)((Object)assembly)).targetObjects = new HashMap<String, List<Long>>();
        }

        @Override
        public R build() {
            ((GraphQuery)((Object)this.assembly)).targetObjects.clear();
            for (Map.Entry target : this.allTargets.asMap().entrySet()) {
                ((GraphQuery)((Object)this.assembly)).targetObjects.put((String)target.getKey(), new ArrayList((Collection)target.getValue()));
            }
            return (R)((Object)((GraphQuery)((Object)super.build())));
        }

        public B target(Map<String, ? extends Iterable<Long>> targets) {
            for (Map.Entry<String, ? extends Iterable<Long>> classAndIds : targets.entrySet()) {
                this.allTargets.putAll((Object)classAndIds.getKey(), classAndIds.getValue());
            }
            return (B)this;
        }

        public B target(String targetClass) {
            this.targetObjectClass = targetClass;
            return (B)this;
        }

        public B id(Iterable<Long> ids) {
            if (this.targetObjectClass == null) {
                throw new IllegalStateException("must first use target(String) to set class name");
            }
            this.allTargets.putAll((Object)this.targetObjectClass, ids);
            return (B)this;
        }

        public B id(RLong ... ids) {
            if (this.targetObjectClass == null) {
                throw new IllegalStateException("must first use target(String) to set class name");
            }
            for (RLong id : ids) {
                this.allTargets.put((Object)this.targetObjectClass, (Object)id.getValue());
            }
            return (B)this;
        }

        public B target(IObject ... targets) {
            for (IObject target : targets) {
                ((GraphQueryBuilder)this.target(target.getClass())).id(target.getId());
            }
            return (B)this;
        }

        public B target(Multimap<String, Long> targets) {
            return this.target(targets.asMap());
        }

        public B target(Class<? extends IObject> targetClass) {
            return this.target(Requests.getModelClassName(targetClass));
        }

        public B id(Long ... ids) {
            return this.id(Arrays.asList(ids));
        }
    }

    public static class ChildOptionBuilder
    extends Builder<ChildOption> {
        private ChildOptionBuilder() {
            super(new ChildOption());
            ((ChildOption)((Object)this.assembly)).includeType = new ArrayList<String>();
            ((ChildOption)((Object)this.assembly)).excludeType = new ArrayList<String>();
            ((ChildOption)((Object)this.assembly)).includeNs = new ArrayList<String>();
            ((ChildOption)((Object)this.assembly)).excludeNs = new ArrayList<String>();
        }

        public ChildOptionBuilder includeType(Iterable<String> types) {
            for (String type : types) {
                ((ChildOption)((Object)this.assembly)).includeType.add(type);
            }
            return this;
        }

        public ChildOptionBuilder includeType(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((ChildOption)((Object)this.assembly)).includeType.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public ChildOptionBuilder excludeType(Iterable<String> types) {
            for (String type : types) {
                ((ChildOption)((Object)this.assembly)).excludeType.add(type);
            }
            return this;
        }

        public final ChildOptionBuilder excludeType(Class<? extends IObject> ... types) {
            for (Class<? extends IObject> type : types) {
                ((ChildOption)((Object)this.assembly)).excludeType.add(Requests.getModelClassName(type));
            }
            return this;
        }

        public ChildOptionBuilder includeNs(Iterable<String> namespaces) {
            for (String namespace : namespaces) {
                ((ChildOption)((Object)this.assembly)).includeNs.add(namespace);
            }
            return this;
        }

        public ChildOptionBuilder excludeNs(Iterable<String> namespaces) {
            for (String namespace : namespaces) {
                ((ChildOption)((Object)this.assembly)).excludeNs.add(namespace);
            }
            return this;
        }

        public ChildOptionBuilder includeType(String ... types) {
            return this.includeType(Arrays.asList(types));
        }

        public ChildOptionBuilder excludeType(String ... types) {
            return this.excludeType(Arrays.asList(types));
        }

        public ChildOptionBuilder includeNs(String ... namespaces) {
            return this.includeNs(Arrays.asList(namespaces));
        }

        public ChildOptionBuilder excludeNs(String ... namespaces) {
            return this.excludeNs(Arrays.asList(namespaces));
        }
    }

    private static abstract class Builder<X> {
        protected X assembly;

        Builder(X newAssembly) {
            this.assembly = newAssembly;
        }

        public X build() {
            return this.assembly;
        }
    }
}

