/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import ome.annotations.RolesAllowed;
import ome.api.IUpdate;
import ome.api.ServiceInterface;
import ome.api.local.LocalAdmin;
import ome.api.local.LocalQuery;
import ome.api.local.LocalUpdate;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel1Service;
import ome.model.IObject;
import ome.services.fulltext.FullTextBridge;
import ome.services.search.IndexWatcher;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.tools.hibernate.ReloadFilter;
import ome.tools.hibernate.UpdateFilter;
import ome.util.Filterable;
import ome.util.Utils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=false)
public class UpdateImpl
extends AbstractLevel1Service
implements LocalUpdate {
    private final Logger log = LoggerFactory.getLogger(UpdateImpl.class);
    protected transient LocalAdmin localAdmin;
    protected transient LocalQuery localQuery;
    protected transient Executor executor;
    protected transient SessionManager sessionManager;
    protected transient FullTextBridge fullTextBridge;
    protected transient IndexWatcher indexWatcher;

    public final void setAdminService(LocalAdmin admin) {
        this.getBeanHelper().throwIfAlreadySet(this.localAdmin, admin);
        this.localAdmin = admin;
    }

    public final void setQueryService(LocalQuery query) {
        this.getBeanHelper().throwIfAlreadySet(this.localQuery, query);
        this.localQuery = query;
    }

    public void setExecutor(Executor executor) {
        this.getBeanHelper().throwIfAlreadySet(this.executor, executor);
        this.executor = executor;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.getBeanHelper().throwIfAlreadySet(this.sessionManager, sessionManager);
        this.sessionManager = sessionManager;
    }

    public void setFullTextBridge(FullTextBridge fullTextBridge) {
        this.getBeanHelper().throwIfAlreadySet(this.fullTextBridge, fullTextBridge);
        this.fullTextBridge = fullTextBridge;
    }

    public void setIndexWatcher(IndexWatcher indexWatcher) {
        this.getBeanHelper().throwIfAlreadySet(this.indexWatcher, indexWatcher);
        this.indexWatcher = indexWatcher;
    }

    public Class<? extends ServiceInterface> getServiceInterface() {
        return IUpdate.class;
    }

    @Override
    @RolesAllowed(value={"user"})
    public void flush() {
        this.session().flush();
    }

    @RolesAllowed(value={"user"})
    public void saveObject(IObject graph) {
        this.doAction(graph, new UpdateAction<IObject>(){

            @Override
            public IObject run(IObject value, UpdateFilter filter, Session s) {
                return UpdateImpl.this.internalMerge(value, filter, s);
            }
        });
    }

    @RolesAllowed(value={"user"})
    public IObject saveAndReturnObject(IObject graph) {
        return this.doAction(graph, new UpdateAction<IObject>(){

            @Override
            public IObject run(IObject value, UpdateFilter filter, Session s) {
                return UpdateImpl.this.internalMerge(value, filter, s);
            }
        });
    }

    @RolesAllowed(value={"user"})
    public void saveCollection(Collection graph) {
        this.doAction(graph, new UpdateAction<Collection>(){

            @Override
            public Collection run(Collection value, UpdateFilter filter, Session s) {
                for (Object o : value) {
                    IObject obj = (IObject)o;
                    obj = UpdateImpl.this.internalMerge(obj, filter, s);
                }
                return null;
            }
        });
    }

    @RolesAllowed(value={"user"})
    public IObject[] saveAndReturnArray(IObject[] graph) {
        return this.doAction(graph, new UpdateAction<IObject[]>(){

            @Override
            public IObject[] run(IObject[] value, UpdateFilter filter, Session s) {
                IObject[] copy = new IObject[value.length];
                for (int i = 0; i < value.length; ++i) {
                    copy[i] = UpdateImpl.this.internalMerge(value[i], filter, s);
                }
                return copy;
            }
        });
    }

    @RolesAllowed(value={"user"})
    public List<Long> saveAndReturnIds(IObject[] graph) {
        if (graph == null || graph.length == 0) {
            return Collections.emptyList();
        }
        final ArrayList<Long> ids = new ArrayList<Long>(graph.length);
        ReloadFilter filter = new ReloadFilter(this.session());
        this.doAction(graph, filter, new UpdateAction<IObject[]>(){

            @Override
            public IObject[] run(IObject[] value, UpdateFilter filter, Session s) {
                for (int i = 0; i < value.length; ++i) {
                    ids.add(i, UpdateImpl.this.internalSave(value[i], (ReloadFilter)filter, s));
                }
                return null;
            }
        });
        return ids;
    }

    @RolesAllowed(value={"user"})
    public void saveArray(IObject[] graph) {
        this.doAction(graph, new UpdateAction<IObject[]>(){

            @Override
            public IObject[] run(IObject[] value, UpdateFilter filter, Session s) {
                IObject[] copy = new IObject[value.length];
                for (int i = 0; i < value.length; ++i) {
                    copy[i] = UpdateImpl.this.internalMerge(value[i], filter, s);
                }
                return copy;
            }
        });
    }

    @RolesAllowed(value={"user"})
    public void deleteObject(IObject row) {
        if (row == null) {
            return;
        }
        if (row.getId() == null) {
            throw new ApiUsageException("Non-managed IObject entity cannot be deleted. Must have an id.");
        }
        try {
            this.doAction(row, new UpdateAction<IObject>(){

                @Override
                public IObject run(IObject value, UpdateFilter filter, Session s) {
                    UpdateImpl.this.internalDelete(value, filter, s);
                    return null;
                }
            });
        }
        catch (InvalidDataAccessApiUsageException idaaue) {
            throw new ApiUsageException("Cannot delete " + row + "\nOriginal message: " + idaaue.getMessage() + "\nConsider using IDelete instead.");
        }
    }

    @RolesAllowed(value={"system"})
    public void indexObject(IObject row) {
        if (row == null || row.getId() == null) {
            throw new ValidationException("Non-managed object cannot be indexed.");
        }
        EventContext ec = this.localAdmin.getEventContextQuiet();
        long userId = ec.getCurrentUserId();
        long groupId = ec.getCurrentGroupId();
        long sessionId = ec.getCurrentSessionId();
        if (groupId == -1L) {
            groupId = this.localAdmin.getDefaultGroup(userId).getId();
        }
        this.log.debug("Awaiting indexing of {}.", (Object)row);
        try {
            if (!this.indexWatcher.indexObject(row, userId, groupId, sessionId).tryAcquire(1L, TimeUnit.MINUTES)) {
                this.log.info("Timed out while awaiting indexing of {}.", (Object)row);
                throw new InternalException("indexing did not occur within a reasonable time");
            }
        }
        catch (InterruptedException ie) {
            this.log.warn("unexpectedly awoken", (Throwable)ie);
        }
    }

    private void beforeUpdate(Object argument, UpdateFilter filter) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument to save cannot be null.");
        }
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Saving event before merge. ");
        }
    }

    protected Long internalSave(IObject obj, ReloadFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Internal save. ");
        }
        IObject result = (IObject)filter.filter((String)null, (Filterable)obj);
        Long id = (Long)session.save((Object)result);
        return id;
    }

    protected IObject internalMerge(IObject obj, UpdateFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Internal merge. ");
        }
        Long previousId = obj.getId();
        IObject result = (IObject)filter.filter((String)null, (Filterable)obj);
        result = (IObject)session.merge((Object)result);
        Long currentId = result.getId();
        if (previousId != null && previousId != currentId) {
            if (this.getBeanHelper().getLogger().isDebugEnabled()) {
                this.getBeanHelper().getLogger().debug("attempt to save deleted object: " + obj);
            }
            throw new ValidationException("object no longer exists in database");
        }
        return result;
    }

    protected void internalDelete(IObject obj, UpdateFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Internal delete. ");
        }
        session.delete(session.load(Utils.trueClass(obj.getClass()), (Serializable)obj.getId()));
    }

    private void afterUpdate(UpdateFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Post-save cleanup. ");
        }
        session.flush();
        filter.unloadReplacedObjects();
    }

    private <T> T doAction(T graph, UpdateAction<T> action) {
        UpdateFilter filter = new UpdateFilter();
        return this.doAction(graph, filter, action);
    }

    private <T> T doAction(T graph, UpdateFilter filter, UpdateAction<T> action) {
        Session session = this.session();
        this.beforeUpdate(graph, filter);
        T retVal = action.run(graph, filter, session);
        this.afterUpdate(filter, session);
        return retVal;
    }

    private Session session() {
        return SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)false);
    }

    private abstract class UpdateAction<T> {
        private UpdateAction() {
        }

        public abstract T run(T var1, UpdateFilter var2, Session var3);
    }
}

