/*
 * Decompiled with CFR 0.152.
 */
package ome.security;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class KeyAndTrustStoreConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger((String)"omero.security");
    private static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private String keyStore = null;
    private String keyStorePassword = null;
    private String trustStore = null;
    private String trustStorePassword = null;

    public void afterPropertiesSet() throws Exception {
        String oldTrustStore = System.getProperty(JAVAX_NET_SSL_TRUST_STORE, "");
        String oldKeyStore = System.getProperty(JAVAX_NET_SSL_KEY_STORE, "");
        if (oldTrustStore != null) {
            if (oldTrustStore.equals(this.trustStore)) {
                log.debug("Found duplicate trust store: " + oldTrustStore);
            } else if (oldTrustStore.length() > 0) {
                log.warn("Overwriting existing trust store: " + oldTrustStore);
            }
        }
        if (StringUtils.isEmpty((String)this.trustStore)) {
            log.warn("trustStore property is empty, not setting");
        } else {
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE, this.trustStore);
        }
        if (StringUtils.isEmpty((String)this.trustStorePassword)) {
            log.warn("trustStorePassword property is empty, not setting");
        } else {
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, this.trustStorePassword);
        }
        if (oldKeyStore != null) {
            if (oldKeyStore.equals(this.keyStore)) {
                log.debug("Found duplicate trust store: " + oldKeyStore);
            } else if (oldKeyStore.length() > 0) {
                log.warn("Overwriting existing key store: " + oldKeyStore);
            }
        }
        System.setProperty(JAVAX_NET_SSL_KEY_STORE, this.keyStore);
        System.setProperty(JAVAX_NET_SSL_KEY_STORE_PASSWORD, this.keyStorePassword);
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public void setTrustStorePassword(String password) {
        this.trustStorePassword = password;
    }

    public void setKeyStorePassword(String password) {
        this.keyStorePassword = password;
    }
}

