/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth.providers;

import ome.conditions.ApiUsageException;
import ome.logic.LdapImpl;
import ome.model.meta.Experimenter;
import ome.security.auth.ConfigurablePasswordProvider;
import ome.security.auth.PasswordUtil;
import org.springframework.util.Assert;

public class LdapPasswordProvider431
extends ConfigurablePasswordProvider {
    protected final LdapImpl ldapUtil;

    public LdapPasswordProvider431(PasswordUtil util, LdapImpl ldap) {
        super(util);
        Assert.notNull((Object)ldap);
        this.ldapUtil = ldap;
    }

    public LdapPasswordProvider431(PasswordUtil util, LdapImpl ldap, boolean ignoreUnknown) {
        super(util, ignoreUnknown);
        Assert.notNull((Object)ldap);
        this.ldapUtil = ldap;
    }

    @Override
    public boolean hasPassword(String user) {
        String dn;
        Long id;
        return this.ldapUtil.getSetting() && (id = this.util.userId(user)) != null && (dn = this.ldapUtil.lookupLdapAuthExperimenter(id)) != null;
    }

    @Override
    public Boolean checkPassword(String user, String password, boolean readOnly) {
        if (!this.ldapUtil.getSetting()) {
            return null;
        }
        Long id = this.util.userId(user);
        if (null == id) {
            try {
                if (readOnly) {
                    throw new IllegalStateException("Cannot create user!");
                }
                Experimenter experimenter = this.ldapUtil.createUser(user, password);
                if (experimenter != null) {
                    this.loginAttempt(user, true);
                    return true;
                }
            }
            catch (ApiUsageException e) {
                this.log.info(String.format("Default choice on create user: %s (%s)", new Object[]{user, e}));
            }
        } else {
            try {
                String dn = this.ldapUtil.lookupLdapAuthExperimenter(id);
                if (dn != null) {
                    return this.loginAttempt(user, this.ldapUtil.validatePassword(dn, password));
                }
            }
            catch (ApiUsageException e) {
                this.log.warn("Default choice on check ldap password: " + user, (Throwable)e);
            }
        }
        return super.checkPassword(user, password, readOnly);
    }
}

