/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ome.conditions.ApiUsageException;
import ome.conditions.GroupSecurityViolation;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.model.meta.Session;
import ome.security.ACLVoter;
import ome.security.SecurityFilter;
import ome.security.SystemTypes;
import ome.security.basic.BasicEventContext;
import ome.security.basic.CurrentDetails;
import ome.security.basic.LightAdminPrivileges;
import ome.security.basic.TokenHolder;
import ome.security.policy.DefaultPolicyService;
import ome.security.policy.PolicyService;
import ome.services.sessions.SessionProvider;
import ome.services.util.ReadOnlyStatus;
import ome.system.EventContext;
import ome.system.Roles;
import ome.tools.hibernate.HibernateUtils;
import ome.util.PermDetails;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BasicACLVoter
implements ACLVoter {
    private static final Logger log = LoggerFactory.getLogger(BasicACLVoter.class);
    protected final CurrentDetails currentUser;
    protected final SystemTypes sysTypes;
    protected final TokenHolder tokenHolder;
    protected final SecurityFilter securityFilter;
    protected final PolicyService policyService;
    protected final Roles roles;
    private Set<Class<? extends IObject>> chgrpPermittedClasses = Collections.emptySet();
    private Set<Class<? extends IObject>> chownPermittedClasses = Collections.emptySet();
    private final LightAdminPrivileges adminPrivileges;
    private final SessionProvider sessionProvider;
    private final boolean isReadOnlyDb;
    private final Set<String> managedRepoUuids;
    private final Set<String> scriptRepoUuids;
    private final String fileRepoSecretKey;

    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter) {
        this(cd, sysTypes, tokenHolder, securityFilter, new DefaultPolicyService(), new Roles());
    }

    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter, SessionProvider sessionProvider, ReadOnlyStatus readOnly) {
        this(cd, sysTypes, tokenHolder, securityFilter, new DefaultPolicyService(), new Roles(), sessionProvider, readOnly);
    }

    @Deprecated
    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter, PolicyService policyService) {
        this(cd, sysTypes, tokenHolder, securityFilter, policyService, new Roles());
    }

    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter, PolicyService policyService, Roles roles) {
        this(cd, sysTypes, tokenHolder, securityFilter, policyService, roles, new LightAdminPrivileges(roles), null, new ReadOnlyStatus(false, false), new HashSet<String>(), new HashSet<String>(), UUID.randomUUID().toString());
        log.info("assuming read-write repository");
    }

    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter, PolicyService policyService, Roles roles, SessionProvider sessionProvider, ReadOnlyStatus readOnly) {
        this(cd, sysTypes, tokenHolder, securityFilter, policyService, roles, new LightAdminPrivileges(roles), sessionProvider, readOnly, new HashSet<String>(), new HashSet<String>(), UUID.randomUUID().toString());
    }

    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter, PolicyService policyService, Roles roles, LightAdminPrivileges adminPrivileges, SessionProvider sessionProvider, ReadOnlyStatus readOnly, Set<String> managedRepoUuids, Set<String> scriptRepoUuids, String fileRepoSecretKey) {
        this.currentUser = cd;
        this.sysTypes = sysTypes;
        this.securityFilter = securityFilter;
        this.tokenHolder = tokenHolder;
        this.roles = roles;
        this.policyService = policyService;
        this.adminPrivileges = adminPrivileges;
        this.sessionProvider = sessionProvider;
        this.isReadOnlyDb = readOnly.isReadOnlyDb();
        this.managedRepoUuids = managedRepoUuids;
        this.scriptRepoUuids = scriptRepoUuids;
        this.fileRepoSecretKey = fileRepoSecretKey;
    }

    @Override
    public boolean allowChmod(IObject iObject) {
        if (iObject == null) {
            throw new ApiUsageException("Object can't be null");
        }
        if (this.isReadOnlyDb) {
            return false;
        }
        Long ownerId = HibernateUtils.nullSafeOwnerId(iObject);
        Long groupId = iObject instanceof ExperimenterGroup ? iObject.getId() : HibernateUtils.nullSafeGroupId(iObject);
        EventContext ec = this.currentUser.getCurrentEventContext();
        if (ec.getCurrentUserId().equals(ownerId) || ec.getLeaderOfGroupsList().contains(groupId)) {
            return true;
        }
        if (!ec.isCurrentUserAdmin()) {
            return false;
        }
        Set privileges = ec.getCurrentAdminPrivileges();
        if (this.sysTypes.isSystemType(iObject.getClass())) {
            if (iObject instanceof Experimenter) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyUser"));
            }
            if (iObject instanceof ExperimenterGroup) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroup"));
            }
            if (iObject instanceof GroupExperimenterMap) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroupMembership"));
            }
            return true;
        }
        if (iObject instanceof OriginalFile) {
            String repo = ((OriginalFile)iObject).getRepo();
            if (repo != null) {
                if (this.managedRepoUuids.contains(repo)) {
                    return privileges.contains(this.adminPrivileges.getPrivilege("WriteManagedRepo"));
                }
                if (this.scriptRepoUuids.contains(repo)) {
                    return privileges.contains(this.adminPrivileges.getPrivilege("WriteScriptRepo"));
                }
            }
            return privileges.contains(this.adminPrivileges.getPrivilege("WriteFile"));
        }
        return privileges.contains(this.adminPrivileges.getPrivilege("WriteOwned"));
    }

    @Override
    public boolean allowLoad(org.hibernate.Session session, Class<? extends IObject> klass, Details d, long id) {
        Assert.notNull(klass);
        BasicEventContext ec = this.currentUser.current();
        if (klass == Session.class) {
            Session queriedSession;
            Experimenter sessionOwnerQueried;
            Session currentSession = this.sessionProvider.findSessionById((long)ec.getCurrentSessionId(), session);
            Experimenter sessionOwnerCurrent = currentSession.getSudoer();
            if (sessionOwnerCurrent == null) {
                sessionOwnerCurrent = currentSession.getOwner();
            }
            if ((sessionOwnerQueried = (queriedSession = this.sessionProvider.findSessionById(id, session)).getSudoer()) == null) {
                sessionOwnerQueried = queriedSession.getOwner();
            }
            if (sessionOwnerCurrent.getId().equals(sessionOwnerQueried.getId())) {
                return true;
            }
            return ec.getCurrentAdminPrivileges().contains(this.adminPrivileges.getPrivilege("ReadSession"));
        }
        if (d == null || this.sysTypes.isSystemType(klass)) {
            return true;
        }
        boolean rv = false;
        rv = this.sysTypes.isInSystemGroup(d) || this.sysTypes.isInUserGroup(d) ? true : this.securityFilter.passesFilter(session, d, (EventContext)ec);
        if (ec.getCurrentGroupId() < 0L) {
            ExperimenterGroup g = d.getGroup();
            if (g == null) {
                log.warn(String.format("Group null while loading %s:%s", klass.getName(), id));
            }
            if (g != null) {
                Long gid = g.getId();
                Permissions p = g.getDetails().getPermissions();
                if (p == null) {
                    log.warn(String.format("Permissions null for group %s while loading %s:%s", gid, klass.getName(), id));
                } else {
                    ec.setPermissionsForGroup(gid, p);
                }
            }
        }
        return rv;
    }

    @Override
    public void throwLoadViolation(IObject iObject) throws SecurityViolation {
        Assert.notNull((Object)iObject);
        throw new SecurityViolation("Cannot read " + iObject);
    }

    @Override
    public boolean allowCreation(IObject iObject) {
        Assert.notNull((Object)iObject);
        if (this.isReadOnlyDb) {
            return false;
        }
        Class<?> cls = iObject.getClass();
        boolean sysType = this.sysTypes.isSystemType(cls);
        EventContext ec = this.currentUser.getCurrentEventContext();
        if (this.tokenHolder.hasPrivilegedToken(iObject)) {
            return true;
        }
        if (!sysType) {
            OriginalFile file;
            if (ec.getCurrentUserId().longValue() == this.roles.getGuestId()) {
                return false;
            }
            return !(iObject instanceof OriginalFile) || (file = (OriginalFile)iObject).getRepo() == null || file.getName().startsWith(this.fileRepoSecretKey);
        }
        if (ec.isCurrentUserAdmin()) {
            Set privileges = ec.getCurrentAdminPrivileges();
            if (iObject instanceof Experimenter) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyUser"));
            }
            if (iObject instanceof ExperimenterGroup) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroup"));
            }
            if (iObject instanceof GroupExperimenterMap) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroupMembership"));
            }
            return true;
        }
        return false;
    }

    @Override
    public void throwCreationViolation(IObject iObject) throws SecurityViolation {
        Assert.notNull((Object)iObject);
        boolean sysType = this.sysTypes.isSystemType(iObject.getClass());
        if (sysType) {
            throw new SecurityViolation(iObject + " is a System-type, and may be created only through privileged APIs.");
        }
        if (iObject instanceof OriginalFile && ((OriginalFile)iObject).getRepo() != null) {
            throw new SecurityViolation("cannot set repo property of " + iObject + " via ORM");
        }
        if (this.currentUser.isGraphCritical(iObject.getDetails())) {
            throw new GroupSecurityViolation(iObject + "-insertion violates group-security.");
        }
        throw new SecurityViolation("not permitted to create " + iObject);
    }

    @Override
    public boolean allowAnnotate(IObject iObject, Details trustedDetails) {
        BasicEventContext c = this.currentUser.current();
        return 1 == this.allowUpdateOrDelete(c, iObject, trustedDetails, Scope.ANNOTATE);
    }

    @Override
    public boolean allowUpdate(IObject iObject, Details trustedDetails) {
        BasicEventContext c = this.currentUser.current();
        return 1 == this.allowUpdateOrDelete(c, iObject, trustedDetails, Scope.EDIT);
    }

    @Override
    public void throwUpdateViolation(IObject iObject) throws SecurityViolation {
        Assert.notNull((Object)iObject);
        boolean sysType = this.sysTypes.isSystemType(iObject.getClass());
        if (!sysType && this.currentUser.isGraphCritical(iObject.getDetails())) {
            throw new GroupSecurityViolation(iObject + "-modification violates group-security.");
        }
        throw new SecurityViolation("Updating " + iObject + " not allowed.");
    }

    @Override
    public boolean allowDelete(IObject iObject, Details trustedDetails) {
        BasicEventContext c = this.currentUser.current();
        return 1 == this.allowUpdateOrDelete(c, iObject, trustedDetails, Scope.DELETE);
    }

    @Override
    public void throwDeleteViolation(IObject iObject) throws SecurityViolation {
        Assert.notNull((Object)iObject);
        throw new SecurityViolation("Deleting " + iObject + " not allowed.");
    }

    boolean owner(Long o, EventContext c) {
        return o != null && o.equals(c.getCurrentUserId());
    }

    boolean owner(Details d, EventContext c) {
        Long o = d.getOwner() == null ? null : d.getOwner().getId();
        return o != null && o.equals(c.getCurrentUserId());
    }

    boolean member(Long g, EventContext c) {
        return g != null && c.getMemberOfGroupsList().contains(g);
    }

    boolean member(Details d, EventContext c) {
        Long g = d.getGroup() == null ? null : d.getGroup().getId();
        return this.member(g, c);
    }

    boolean leader(Long g, EventContext c) {
        return g != null && c.getLeaderOfGroupsList().contains(g);
    }

    boolean leader(Details d, EventContext c) {
        Long g = d.getGroup() == null ? null : d.getGroup().getId();
        return this.leader(g, c);
    }

    private int allowUpdateOrDelete(BasicEventContext c, IObject iObject, Details trustedDetails, Scope ... scopes) {
        boolean sysTypeOrUsrGroup;
        int rv = 0;
        if (iObject == null) {
            throw new IllegalArgumentException("null object");
        }
        if (this.isReadOnlyDb) {
            return rv;
        }
        Details d = trustedDetails;
        if (d == null) {
            throw new InternalException("trustedDetails are null!");
        }
        boolean sysType = this.sysTypes.isSystemType(iObject.getClass());
        boolean bl = sysTypeOrUsrGroup = sysType || this.sysTypes.isInUserGroup(d);
        if (this.tokenHolder.hasPrivilegedToken(iObject)) {
            return 1;
        }
        if (!sysTypeOrUsrGroup && this.currentUser.isGraphCritical(d)) {
            Boolean belongs = null;
            Long uid = c.getCurrentUserId();
            for (int i = 0; i < scopes.length; ++i) {
                if (!scopes[i].equals((Object)Scope.LINK) && !scopes[i].equals((Object)Scope.ANNOTATE)) continue;
                if (belongs == null) {
                    belongs = this.objectBelongsToUser(iObject, uid);
                }
                if (belongs.booleanValue()) continue;
                scopes[i] = null;
            }
        }
        Set privileges = c.getCurrentAdminPrivileges();
        if (LightAdminPrivileges.getAllPrivileges().equals((Object)privileges)) {
            for (int i = 0; i < scopes.length; ++i) {
                if (scopes[i] == null) continue;
                rv |= 1 << i;
            }
            return rv;
        }
        boolean isDir = iObject instanceof OriginalFile && "Directory".equals(((OriginalFile)iObject).getMimetype());
        Permissions grpPermissions = null;
        if (d.getGroup() != null) {
            Long gid = d.getGroup().getId();
            grpPermissions = !isDir && this.roles.getUserGroupId() == gid.longValue() ? new Permissions(Permissions.PRIVATE) : c.getPermissionsForGroup(gid);
        }
        if (grpPermissions == null && this.roles.getUserGroupId() != c.getCurrentGroupId().longValue()) {
            grpPermissions = c.getCurrentGroupPermissions();
        }
        if (grpPermissions == null || grpPermissions == Permissions.DUMMY) {
            grpPermissions = new Permissions(Permissions.EMPTY);
        }
        boolean owner = this.owner(d, (EventContext)c);
        boolean leader = this.leader(d, (EventContext)c);
        boolean member = this.member(d, (EventContext)c);
        for (int i = 0; i < scopes.length; ++i) {
            boolean isLinkageScope;
            Scope scope = scopes[i];
            if (scope == null) continue;
            boolean hasLightAdminPrivilege = false;
            if (!sysType) {
                if (c.getCurrentUserId().longValue() == this.roles.getGuestId()) {
                    return 0;
                }
                if (iObject instanceof OriginalFile) {
                    String repo = ((OriginalFile)iObject).getRepo();
                    if (repo != null) {
                        if (this.managedRepoUuids.contains(repo)) {
                            if (privileges.contains(this.adminPrivileges.getPrivilege(scope == Scope.DELETE ? "DeleteManagedRepo" : "WriteManagedRepo"))) {
                                hasLightAdminPrivilege = true;
                            }
                        } else if (this.scriptRepoUuids.contains(repo)) {
                            if (privileges.contains(this.adminPrivileges.getPrivilege(scope == Scope.DELETE ? "DeleteScriptRepo" : "WriteScriptRepo"))) {
                                hasLightAdminPrivilege = true;
                            }
                        } else if (privileges.contains(this.adminPrivileges.getPrivilege(scope == Scope.DELETE ? "DeleteFile" : "WriteFile"))) {
                            hasLightAdminPrivilege = true;
                        }
                    } else if (privileges.contains(this.adminPrivileges.getPrivilege(scope == Scope.DELETE ? "DeleteFile" : "WriteFile"))) {
                        hasLightAdminPrivilege = true;
                    }
                } else if (privileges.contains(this.adminPrivileges.getPrivilege(scope == Scope.DELETE ? "DeleteOwned" : "WriteOwned"))) {
                    hasLightAdminPrivilege = true;
                }
            } else if (iObject instanceof Experimenter) {
                if (privileges.contains(this.adminPrivileges.getPrivilege("ModifyUser"))) {
                    hasLightAdminPrivilege = true;
                }
            } else if (iObject instanceof ExperimenterGroup) {
                if (privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroup"))) {
                    hasLightAdminPrivilege = true;
                }
            } else if (iObject instanceof GroupExperimenterMap) {
                if (privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroupMembership"))) {
                    hasLightAdminPrivilege = true;
                }
            } else if (c.isCurrentUserAdmin()) {
                hasLightAdminPrivilege = true;
            }
            boolean bl2 = isLinkageScope = scopes[i].equals((Object)Scope.LINK) || scopes[i].equals((Object)Scope.ANNOTATE);
            if (hasLightAdminPrivilege) {
                rv |= 1 << i;
                continue;
            }
            if (sysType) {
                if (!isLinkageScope) continue;
                rv |= 1 << i;
                continue;
            }
            if (leader) {
                rv |= 1 << i;
                continue;
            }
            if (grpPermissions == null) {
                throw new InternalException("Permissions are null! Security system failure -- refusing to continue. The Permissions should be set to a default value.");
            }
            if (grpPermissions.isGranted(Permissions.Role.WORLD, scope.right)) {
                rv |= 1 << i;
                continue;
            }
            if (owner && grpPermissions.isGranted(Permissions.Role.USER, scope.right)) {
                rv |= 1 << i;
                continue;
            }
            if (member && grpPermissions.isGranted(Permissions.Role.GROUP, scope.right)) {
                rv |= 1 << i;
                continue;
            }
            if (!isLinkageScope || !this.sysTypes.isInSystemGroup(d) && (!this.sysTypes.isInUserGroup(d) || isDir)) continue;
            rv |= 1 << i;
        }
        return rv;
    }

    @Override
    public Set<String> restrictions(IObject object) {
        return this.policyService.listActiveRestrictions(object);
    }

    @Override
    public void setPermittedClasses(Map<Integer, Set<Class<? extends IObject>>> objectClassesPermitted) {
        Set<Class<? extends IObject>> chgrpPermittedClasses = objectClassesPermitted.get(4);
        Set<Class<? extends IObject>> chownPermittedClasses = objectClassesPermitted.get(5);
        if (CollectionUtils.isNotEmpty(chgrpPermittedClasses)) {
            this.chgrpPermittedClasses = chgrpPermittedClasses;
        }
        if (CollectionUtils.isNotEmpty(chownPermittedClasses)) {
            this.chownPermittedClasses = chownPermittedClasses;
        }
    }

    private int addChgrpChownRestrictionBits(Class<? extends IObject> objectClass, Details details, int allow) {
        boolean isPermitted;
        if (this.isReadOnlyDb) {
            return allow;
        }
        EventContext ec = this.currentUser.getCurrentEventContext();
        Set privileges = ec.getCurrentAdminPrivileges();
        boolean isChgrpPrivilege = privileges.contains(this.adminPrivileges.getPrivilege("Chgrp"));
        boolean isChownPrivilege = privileges.contains(this.adminPrivileges.getPrivilege("Chown"));
        int chgrpBit = 16;
        int chownBit = 32;
        if (isChgrpPrivilege || details.getOwner() != null && ec.getCurrentUserId().equals(details.getOwner().getId())) {
            allow |= 0x10;
        }
        if (isChownPrivilege || details.getGroup() != null && ec.getLeaderOfGroupsList().contains(details.getGroup().getId())) {
            allow |= 0x20;
        }
        if ((allow & 0x10) > 0 && !this.chgrpPermittedClasses.isEmpty()) {
            isPermitted = false;
            for (Class<? extends IObject> permittedClass : this.chgrpPermittedClasses) {
                if (!permittedClass.isAssignableFrom(objectClass)) continue;
                isPermitted = true;
                break;
            }
            if (!isPermitted) {
                allow &= 0xFFFFFFEF;
            }
        }
        if ((allow & 0x20) > 0 && !this.chownPermittedClasses.isEmpty()) {
            isPermitted = false;
            for (Class<? extends IObject> permittedClass : this.chownPermittedClasses) {
                if (!permittedClass.isAssignableFrom(objectClass)) continue;
                isPermitted = true;
                break;
            }
            if (!isPermitted) {
                allow &= 0xFFFFFFDF;
            }
        }
        return allow;
    }

    @Override
    public void postProcess(IObject object) {
        if (object.isLoaded()) {
            if (object instanceof PermDetails && !(object = ((PermDetails)object).getInternalContext()).isLoaded()) {
                return;
            }
            Details details = object.getDetails();
            this.currentUser.applyContext(details, !(object instanceof ExperimenterGroup));
            BasicEventContext c = this.currentUser.current();
            Permissions p = details.getPermissions();
            int allow = this.allowUpdateOrDelete(c, object, details, Scope.LINK, Scope.EDIT, Scope.DELETE, Scope.ANNOTATE);
            allow = this.addChgrpChownRestrictionBits(object.getClass(), details, allow);
            Permissions copy = new Permissions(p);
            copy.copyRestrictions(allow, this.restrictions(object));
            details.setPermissions(copy);
        }
    }

    private boolean objectBelongsToUser(IObject iObject, Long uid) {
        Experimenter e = iObject.getDetails().getOwner();
        if (e == null) {
            if (iObject.getId() == null) {
                return true;
            }
            throw new NullPointerException("Null owner for " + iObject);
        }
        Long oid = e.getId();
        return uid.equals(oid);
    }

    private static enum Scope {
        ANNOTATE(Permissions.Right.ANNOTATE),
        DELETE(Permissions.Right.WRITE),
        EDIT(Permissions.Right.WRITE),
        LINK(Permissions.Right.WRITE),
        CHGRP(Permissions.Right.WRITE),
        CHOWN(Permissions.Right.WRITE);

        final Permissions.Right right;

        private Scope(Permissions.Right right) {
            this.right = right;
        }
    }
}

