/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import ome.security.ACLEventListener;
import ome.security.ACLVoter;
import ome.security.basic.CurrentDetails;
import ome.security.basic.EventLogListener;
import ome.security.basic.MergeEventListener;
import ome.security.basic.OmeroInterceptor;
import ome.security.basic.SaveEventListener;
import ome.security.basic.TokenHolder;
import ome.security.basic.UpdateEventListener;
import ome.tools.hibernate.EventMethodInterceptor;
import ome.tools.hibernate.ReloadingRefreshEventListener;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.event.EventListeners;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class EventListenersFactoryBean
extends AbstractFactoryBean {
    private final EventListeners eventListeners = new EventListeners();
    private final Map<String, LinkedList<Object>> map = new HashMap<String, LinkedList<Object>>();
    private final CurrentDetails cd;
    private final TokenHolder th;
    private final ACLVoter voter;
    private final OmeroInterceptor interceptor;
    protected boolean debugAll = false;

    public EventListenersFactoryBean(CurrentDetails cd, TokenHolder th, ACLVoter voter, OmeroInterceptor interceptor) {
        this.cd = cd;
        this.th = th;
        this.voter = voter;
        this.interceptor = interceptor;
    }

    public Class getObjectType() {
        return Map.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected Object createInstance() throws Exception {
        this.put("auto-flush", this.eventListeners.getAutoFlushEventListeners());
        this.put("merge", this.eventListeners.getMergeEventListeners());
        this.put("create", this.eventListeners.getPersistEventListeners());
        this.put("create-onflush", this.eventListeners.getPersistOnFlushEventListeners());
        this.put("delete", this.eventListeners.getDeleteEventListeners());
        this.put("dirty-check", this.eventListeners.getDirtyCheckEventListeners());
        this.put("evict", this.eventListeners.getEvictEventListeners());
        this.put("flush", this.eventListeners.getFlushEventListeners());
        this.put("flush-entity", this.eventListeners.getFlushEntityEventListeners());
        this.put("load", this.eventListeners.getLoadEventListeners());
        this.put("load-collection", this.eventListeners.getInitializeCollectionEventListeners());
        this.put("lock", this.eventListeners.getLockEventListeners());
        this.put("refresh", this.eventListeners.getRefreshEventListeners());
        this.put("replicate", this.eventListeners.getReplicateEventListeners());
        this.put("save-update", this.eventListeners.getSaveOrUpdateEventListeners());
        this.put("save", this.eventListeners.getSaveEventListeners());
        this.put("update", this.eventListeners.getUpdateEventListeners());
        this.put("pre-load", this.eventListeners.getPreLoadEventListeners());
        this.put("pre-update", this.eventListeners.getPreUpdateEventListeners());
        this.put("pre-delete", this.eventListeners.getPreDeleteEventListeners());
        this.put("pre-insert", this.eventListeners.getPreInsertEventListeners());
        this.put("post-load", this.eventListeners.getPostLoadEventListeners());
        this.put("post-update", this.eventListeners.getPostUpdateEventListeners());
        this.put("post-delete", this.eventListeners.getPostDeleteEventListeners());
        this.put("post-insert", this.eventListeners.getPostInsertEventListeners());
        this.put("post-commit-update", this.eventListeners.getPostCommitUpdateEventListeners());
        this.put("post-commit-delete", this.eventListeners.getPostCommitDeleteEventListeners());
        this.put("post-commit-insert", this.eventListeners.getPostCommitInsertEventListeners());
        this.assertHasAllKeys();
        this.overrides();
        this.additions();
        return this.map;
    }

    public void setDebugAll(boolean debug) {
        this.debugAll = debug;
    }

    protected void overrides() {
        this.override("merge", (Object)new MergeEventListener(this.cd, this.th));
        this.override("save", (Object)new SaveEventListener(this.cd, this.th));
        this.override(new String[]{"replicate", "update"}, this.getDisablingProxy());
    }

    protected void additions() {
        this.prepend("refresh", new ReloadingRefreshEventListener());
        Iterator<String> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            final String k = key = iterator.next();
            EventMethodInterceptor emi = new EventMethodInterceptor(new EventMethodInterceptor.DisableAction(){

                @Override
                protected boolean disabled(MethodInvocation mi) {
                    return EventListenersFactoryBean.this.cd.isDisabled(k);
                }
            });
            this.append(key, this.getProxy(new Advice[]{emi}));
        }
        if (this.voter != null) {
            ACLEventListener acl = new ACLEventListener(this.voter);
            this.append("post-load", acl);
            this.append("pre-insert", acl);
            this.append("pre-update", acl);
            this.append("pre-delete", acl);
        }
        EventLogListener ell = new EventLogListener(this.cd);
        this.append("post-insert", ell);
        this.append("post-update", ell);
        this.append("post-delete", ell);
        UpdateEventListener uel = new UpdateEventListener(this.cd);
        this.append("pre-update", uel);
        if (this.debugAll) {
            Object debug = this.getDebuggingProxy();
            for (String key : this.map.keySet()) {
                this.map.get(key).add(debug);
            }
        }
    }

    private void assertHasAllKeys() {
    }

    private Class[] allInterfaces() {
        HashSet<Class> set = new HashSet<Class>();
        for (String str : this.map.keySet()) {
            Class iface = this.eventListeners.getListenerClassFor(str);
            if (iface == null) {
                this.logger.warn((Object)("No interface found for " + str));
                continue;
            }
            set.add(iface);
        }
        return set.toArray(new Class[set.size()]);
    }

    private Object getDisablingProxy() {
        EventMethodInterceptor disable = new EventMethodInterceptor(new EventMethodInterceptor.DisableAction());
        return this.getProxy(new Advice[]{disable});
    }

    private Object getDebuggingProxy() {
        EventMethodInterceptor debug = new EventMethodInterceptor();
        debug.setDebug(true);
        return this.getProxy(new Advice[]{debug});
    }

    private Object getProxy(Advice ... adviceArray) {
        ProxyFactory factory = new ProxyFactory();
        factory.setInterfaces(this.allInterfaces());
        for (Advice advice : adviceArray) {
            factory.addAdvice(advice);
        }
        return factory.getProxy();
    }

    protected void override(String[] keys, Object object) {
        for (String key : keys) {
            this.override(key, object);
        }
    }

    protected void override(String key, Object object) {
        this.put(key, null);
        this.append(key, object);
    }

    protected void append(String key, Object ... objs) {
        LinkedList<Object> l = this.map.get(key);
        if (l == null) {
            this.put(key, null);
            l = this.map.get(key);
        }
        if (objs == null) {
            return;
        }
        for (Object object : objs) {
            l.addLast(object);
        }
    }

    protected void prepend(String key, Object ... objs) {
        LinkedList<Object> l = this.map.get(key);
        if (l == null) {
            this.put(key, null);
            l = this.map.get(key);
        }
        if (objs == null) {
            return;
        }
        for (Object object : objs) {
            l.addFirst(object);
        }
    }

    protected void put(String key, Object[] objs) {
        LinkedList list = new LinkedList();
        if (objs != null) {
            Collections.addAll(list, objs);
        }
        this.map.put(key, list);
    }
}

