/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import ome.model.enums.AdminPrivilege;
import ome.security.basic.CurrentDetails;
import ome.security.basic.LightAdminPrivileges;
import ome.system.EventContext;
import ome.system.Roles;
import ome.util.PrivilegedStringTypeDescriptor;

public class PropertyFilterInitializer {
    private final CurrentDetails currentDetails;
    private final DataSource dataSource;
    private final AdminPrivilege privilegeReadSession;
    private final Roles roles;

    private boolean isFullAdmin(long sessionOwnerId) {
        if (this.currentDetails.size() == 0) {
            return true;
        }
        EventContext ec = this.currentDetails.getCurrentEventContext();
        Long currentUserId = ec.getCurrentUserId();
        if (currentUserId == null) {
            return true;
        }
        if (ec.getCurrentAdminPrivileges().contains(this.privilegeReadSession)) {
            return true;
        }
        return sessionOwnerId == currentUserId;
    }

    private boolean isRelatedUser(long experimenterId) {
        if (this.currentDetails.size() == 0) {
            return true;
        }
        if (experimenterId == this.roles.getRootId() || experimenterId == this.roles.getGuestId()) {
            return true;
        }
        EventContext ec = this.currentDetails.getCurrentEventContext();
        Long currentUserId = ec.getCurrentUserId();
        if (currentUserId == null) {
            return true;
        }
        if (ec.isCurrentUserAdmin() || !ec.getLeaderOfGroupsList().isEmpty()) {
            return true;
        }
        if (experimenterId == currentUserId) {
            return true;
        }
        boolean isFellowMember = false;
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement statement = connection.prepareStatement("SELECT 1 FROM GroupExperimenterMap m1 WHERE m1.child = ? AND m1.parent <> ? AND EXISTS (SELECT 1 FROM GroupExperimenterMap m2 WHERE m2.child = ? AND m1.parent = m2.parent) AND EXISTS (SELECT 1 FROM ExperimenterGroup g WHERE m1.parent = g.id AND g.permissions & 64 = 64)");
            statement.setLong(1, experimenterId);
            statement.setLong(2, this.roles.getUserGroupId());
            statement.setLong(3, currentUserId);
            statement.setMaxRows(1);
            isFellowMember = statement.executeQuery().next();
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return isFellowMember;
    }

    public PropertyFilterInitializer(LightAdminPrivileges adminPrivileges, CurrentDetails currentDetails, DataSource dataSource, Roles roles) {
        this.currentDetails = currentDetails;
        this.dataSource = dataSource;
        this.privilegeReadSession = adminPrivileges.getPrivilege("ReadSession");
        this.roles = roles;
        PrivilegedStringTypeDescriptor.setFilter((PrivilegedStringTypeDescriptor.Filter)PrivilegedStringTypeDescriptor.Filter.FULL_ADMIN, this::isFullAdmin);
        PrivilegedStringTypeDescriptor.setFilter((PrivilegedStringTypeDescriptor.Filter)PrivilegedStringTypeDescriptor.Filter.RELATED_USER, this::isRelatedUser);
    }
}

