/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete;

import com.google.common.collect.SetMultimap;
import ome.io.nio.AbstractFileSystemService;
import ome.services.delete.files.FileDeleter;
import ome.system.OmeroContext;
import ome.tools.hibernate.ExtendedMetadata;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Deletion {
    private static final Logger log = LoggerFactory.getLogger(Deletion.class);
    private final OmeroContext ctx;
    private final AbstractFileSystemService afs;

    public Deletion(AbstractFileSystemService afs, OmeroContext ctx) {
        this.afs = afs;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFiles(SetMultimap<String, Long> deleteTargets) {
        Slf4JStopWatch sw = new Slf4JStopWatch();
        try {
            FileDeleter files = new FileDeleter(this.ctx, this.afs, deleteTargets);
            files.run();
            if (files.getFailedFilesCount() > 0) {
                log.warn(files.getWarning());
            }
        }
        finally {
            sw.stop("omero.delete.binary");
        }
    }

    public static class Builder
    extends AbstractFactoryBean<Deletion>
    implements ApplicationContextAware {
        protected OmeroContext ctx;
        protected AbstractFileSystemService afs;
        protected ExtendedMetadata em;

        public Builder(AbstractFileSystemService afs, ExtendedMetadata em) {
            this.afs = afs;
            this.em = em;
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            this.ctx = (OmeroContext)ctx;
        }

        protected Deletion createInstance() throws Exception {
            return new Deletion(this.afs, this.ctx);
        }

        public Class<? extends Deletion> getObjectType() {
            return Deletion.class;
        }
    }
}

