/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import ome.model.IObject;
import ome.model.meta.EventLog;
import ome.services.fulltext.ParserSession;
import ome.util.DetailsFieldBridge;
import org.apache.commons.lang.StringUtils;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.FieldBridge;
import org.quartz.DateBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;

public class FullTextIndexer2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullTextIndexer2.class);
    private static final int BATCH_SIZE = 256;
    private static final int OPTIMIZE_COUNT = 4096;
    private static final String JOB_GROUP = FullTextIndexer2.class.getSimpleName();
    private final Collection<String> actions;
    private final Collection<Class<? extends IObject>> includeTypes;
    private final Scheduler scheduler;
    private final SessionFactory sessionFactory;
    private final FieldBridge bridge;
    private final String countKey;
    private boolean isIndexerDisabled;
    private final AtomicReference<JobKey[]> jobs = new AtomicReference();
    private final SetMultimap<String, Long> toIndex = HashMultimap.create();
    private final SetMultimap<String, Long> toPurge = HashMultimap.create();
    private final Map<Class<? extends IObject>, Integer> purgeCounts = new HashMap<Class<? extends IObject>, Integer>();
    private long eventLogId = -1L;

    public FullTextIndexer2(Scheduler scheduler, SessionFactory sessionFactory, FieldBridge bridge, String countKey, String actionsList, String includeTypesList) {
        this.scheduler = scheduler;
        this.sessionFactory = sessionFactory;
        this.bridge = bridge;
        this.countKey = countKey;
        this.actions = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)actionsList));
        if (this.actions.isEmpty()) {
            throw new IllegalArgumentException("event log actions must be specified");
        }
        ImmutableSet.Builder includeTypes = ImmutableSet.builder();
        for (String className : Splitter.on((char)',').trimResults().split((CharSequence)includeTypesList)) {
            try {
                includeTypes.add(Class.forName(className).asSubclass(IObject.class));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new IllegalArgumentException("include types must be a comma-separated list of model object types", e);
            }
        }
        this.includeTypes = includeTypes.build();
    }

    public void setCronExpression(String cronExpression) {
        this.isIndexerDisabled = StringUtils.isBlank((String)cronExpression);
    }

    private void register(Step step, TriggerBuilder<Trigger> trigger, String message) {
        try {
            this.scheduler.scheduleJob(trigger.forJob(this.jobs.get()[step.ordinal()]).build());
            LOGGER.debug("registered job {} for {}", (Object)step, (Object)message);
        }
        catch (NullPointerException npe) {
            LOGGER.debug("indexer is not running: not registering job {}", (Object)step);
        }
        catch (Throwable t) {
            LOGGER.error("failed to register job {} so indexing may have stopped", (Object)step, (Object)t);
        }
    }

    private void register(Step step) {
        this.register(step, (TriggerBuilder<Trigger>)TriggerBuilder.newTrigger().startNow(), "immediate execution");
    }

    private void register(Step step, Event reason) {
        Date when = reason.getWhen();
        this.register(step, (TriggerBuilder<Trigger>)TriggerBuilder.newTrigger().startAt(when), "execution at " + when);
    }

    public void start() {
        if (this.isIndexerDisabled) {
            LOGGER.info("not starting indexer: the configured cron expression is blank");
            return;
        }
        JobKey[] newJobs = new JobKey[Step.values().length];
        if (!this.jobs.compareAndSet(null, newJobs)) {
            LOGGER.warn("not starting indexer: it is already running");
            return;
        }
        LOGGER.info("starting indexer");
        Converter nameConverter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        try {
            for (Step step : Step.values()) {
                JobKey job;
                MethodInvokingJobDetailFactoryBean factory = new MethodInvokingJobDetailFactoryBean();
                factory.setGroup(JOB_GROUP);
                factory.setName(step.toString());
                factory.setTargetObject((Object)this);
                factory.setTargetMethod((String)nameConverter.convert((Object)step.name()));
                factory.setConcurrent(false);
                factory.afterPropertiesSet();
                JobDetail jobDetail = factory.getObject();
                newJobs[step.ordinal()] = job = jobDetail.getKey();
                LOGGER.debug("adding job {}", (Object)job);
                this.scheduler.addJob(jobDetail, false);
            }
            this.register(Step.OPTIMIZE, Event.STARTUP);
        }
        catch (Throwable t) {
            LOGGER.error("failed to start indexer", t);
        }
    }

    public void stop() {
        JobKey[] oldJobs = this.jobs.getAndSet(null);
        if (oldJobs == null) {
            if (this.isIndexerDisabled) {
                LOGGER.info("not stopping indexer: the configured cron expression is blank");
            } else {
                LOGGER.warn("not stopping indexer: it is not running");
            }
            return;
        }
        try {
            for (JobKey job : oldJobs) {
                LOGGER.debug("deleting job {}", (Object)job);
                this.scheduler.deleteJob(job);
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to stop indexer promptly", t);
        }
        LOGGER.info("stopped indexer");
    }

    private boolean isIncluded(Class<? extends IObject> entityClass) {
        for (Class<? extends IObject> includeType : this.includeTypes) {
            if (!includeType.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return false;
    }

    private void removeObsoleteEntries(SetMultimap<String, Long> entities, org.hibernate.Session session) {
        String entityType;
        HashMultimap obsoleteEntries = HashMultimap.create();
        String hql = "SELECT DISTINCT entityId FROM EventLog WHERE id > :id AND entityType = :type AND entityId IN (:ids) AND action IN (:actions)";
        for (Map.Entry entityOneType : entities.asMap().entrySet()) {
            Collection entityIds;
            block5: {
                entityType = (String)entityOneType.getKey();
                entityIds = (Collection)entityOneType.getValue();
                try {
                    if (!this.isIncluded(Class.forName(entityType).asSubclass(IObject.class))) {
                    }
                    break block5;
                }
                catch (ClassCastException | ReflectiveOperationException e) {
                    LOGGER.warn("unknown entity type in event log: {}", (Object)entityType, (Object)e);
                    obsoleteEntries.putAll((Object)entityType, (Iterable)entityIds);
                }
                continue;
            }
            Query query = session.createQuery("SELECT DISTINCT entityId FROM EventLog WHERE id > :id AND entityType = :type AND entityId IN (:ids) AND action IN (:actions)");
            query.setParameter("id", (Object)this.eventLogId);
            query.setParameter("type", (Object)entityType);
            query.setParameterList("ids", entityIds);
            query.setParameterList("actions", this.actions);
            List entityIdsObsolete = query.list();
            obsoleteEntries.putAll((Object)entityType, (Iterable)entityIdsObsolete);
        }
        for (Map.Entry obsoleteEntry : obsoleteEntries.entries()) {
            entityType = (String)obsoleteEntry.getKey();
            Long entityId = (Long)obsoleteEntry.getValue();
            LOGGER.debug("skipping {}:{}", (Object)entityType, (Object)entityId);
            entities.remove((Object)entityType, (Object)entityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        Session session = this.sessionFactory.openSession();
        UnresolvableObjectException hibernateQueryError = null;
        boolean isNothingNew = false;
        try {
            LOGGER.debug("adding any new REINDEX entries");
            session.setFlushMode(FlushMode.COMMIT);
            Transaction transaction = session.beginTransaction();
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    try (Statement stmt = connection.createStatement();){
                        stmt.execute("SELECT updated_entities_note_reindex()");
                    }
                }
            });
            transaction.commit();
            LOGGER.debug("reviewing event log for new entries");
            session.setFlushMode(FlushMode.MANUAL);
            transaction = session.beginTransaction();
            session.doWork(new Work(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Connection connection) throws SQLException {
                    stmt.setString(1, FullTextIndexer2.this.countKey);
                    try (PreparedStatement stmt = connection.prepareStatement("SELECT value FROM configuration WHERE name = ?");){
                        ResultSet results = stmt.executeQuery();
                        if (results.next()) {
                            try {
                                FullTextIndexer2.this.eventLogId = Long.parseLong(results.getString(1));
                            }
                            catch (NullPointerException | NumberFormatException runtimeException) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
            String hql = "FROM EventLog WHERE id > :id AND action IN (:actions) ORDER BY id";
            Query query = session.createQuery("FROM EventLog WHERE id > :id AND action IN (:actions) ORDER BY id");
            query.setMaxResults(256);
            query.setParameter("id", (Object)this.eventLogId);
            query.setParameterList("actions", this.actions);
            List logEntries = query.list();
            isNothingNew = logEntries.isEmpty();
            if (isNothingNew) {
                LOGGER.debug("no new event log entries");
            } else {
                LOGGER.debug("reviewing {} event log entries", (Object)logEntries.size());
                for (EventLog logEntry : logEntries) {
                    if ("DELETE".equals(logEntry.getAction())) {
                        this.toIndex.remove((Object)logEntry.getEntityType(), (Object)logEntry.getEntityId());
                        this.toPurge.put((Object)logEntry.getEntityType(), (Object)logEntry.getEntityId());
                    } else {
                        this.toIndex.put((Object)logEntry.getEntityType(), (Object)logEntry.getEntityId());
                    }
                    this.eventLogId = logEntry.getId();
                }
                LOGGER.debug("looking ahead for which log entries are obsolete");
                this.removeObsoleteEntries(this.toIndex, (org.hibernate.Session)session);
                this.removeObsoleteEntries(this.toPurge, (org.hibernate.Session)session);
            }
            transaction.rollback();
        }
        catch (UnresolvableObjectException uoe) {
            hibernateQueryError = uoe;
        }
        finally {
            session.close();
        }
        try {
            if (hibernateQueryError != null) {
                this.toIndex.clear();
                this.toPurge.clear();
                LOGGER.info("Hibernate query failed, aborting this indexer run", (Throwable)hibernateQueryError);
                this.register(Step.PREPARE, Event.HIBERNATE_QUERY_ERROR);
            } else if (!this.toIndex.isEmpty()) {
                this.register(Step.INDEX);
            } else if (!this.toPurge.isEmpty()) {
                this.register(Step.PURGE);
            } else if (!isNothingNew) {
                this.register(Step.NOTE);
            } else {
                boolean isOptimize = false;
                for (int count : this.purgeCounts.values()) {
                    if (count < 4096) continue;
                    isOptimize = true;
                    break;
                }
                if (isOptimize) {
                    this.register(Step.OPTIMIZE);
                } else {
                    this.register(Step.PREPARE, Event.NOTHING_NEW_TO_INDEX);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to continue indexer", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index() {
        LOGGER.info("indexing objects: count = {}", (Object)this.toIndex.size());
        if (!DetailsFieldBridge.tryLock()) {
            LOGGER.info("failed to lock field bridge so will wait awhile");
            try {
                this.register(Step.INDEX, Event.FIELD_BRIDGE_CONTENTION);
            }
            catch (Throwable t) {
                LOGGER.error("failed to continue indexer", t);
            }
            return;
        }
        DetailsFieldBridge.setFieldBridge((FieldBridge)this.bridge);
        ParserSession parserSession = new ParserSession();
        Session session = this.sessionFactory.openSession();
        UnresolvableObjectException hibernateQueryError = null;
        Throwable bridgeException = null;
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((org.hibernate.Session)session);
            fullTextSession.setCacheMode(CacheMode.IGNORE);
            fullTextSession.setFlushMode(FlushMode.COMMIT);
            Transaction transaction = fullTextSession.beginTransaction();
            for (Map.Entry typeAndIds : this.toIndex.asMap().entrySet()) {
                String entityType = (String)typeAndIds.getKey();
                Collection entityIds = (Collection)typeAndIds.getValue();
                String hql = "FROM " + entityType + " WHERE id IN (:ids)";
                Query query = fullTextSession.createQuery(hql);
                query.setParameterList("ids", entityIds);
                query.setReadOnly(true);
                for (Object entity : query.list()) {
                    Class entityClass = Hibernate.getClass(entity);
                    if (this.isIncluded(entityClass)) {
                        LOGGER.debug("indexing {}:{}", (Object)entityType, (Object)((IObject)entity).getId());
                        fullTextSession.index(entity);
                        continue;
                    }
                    LOGGER.debug("skipping {}:{}", (Object)entityType, (Object)((IObject)entity).getId());
                }
            }
            transaction.commit();
            this.toIndex.clear();
        }
        catch (UnresolvableObjectException uoe) {
            hibernateQueryError = uoe;
        }
        catch (BridgeException be) {
            bridgeException = be.getCause();
            LOGGER.info("bridge failed, will retry indexing", bridgeException);
        }
        finally {
            DetailsFieldBridge.unlock();
            session.close();
            parserSession.closeParsedFiles();
        }
        try {
            if (hibernateQueryError != null) {
                this.toIndex.clear();
                this.toPurge.clear();
                LOGGER.info("Hibernate query failed, aborting this indexer run", (Throwable)hibernateQueryError);
                this.register(Step.PREPARE, Event.HIBERNATE_QUERY_ERROR);
            } else if (bridgeException != null) {
                this.register(Step.INDEX_RETRY);
            } else if (!this.toPurge.isEmpty()) {
                this.register(Step.PURGE);
            } else {
                this.register(Step.NOTE);
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to continue indexer", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexRetry() {
        LOGGER.info("indexing objects: count = {} (retry)", (Object)this.toIndex.size());
        if (!DetailsFieldBridge.tryLock()) {
            LOGGER.info("failed to lock field bridge so will wait awhile");
            try {
                this.register(Step.INDEX_RETRY, Event.FIELD_BRIDGE_CONTENTION);
            }
            catch (Throwable t) {
                LOGGER.error("failed to continue indexer", t);
            }
            return;
        }
        DetailsFieldBridge.setFieldBridge((FieldBridge)this.bridge);
        ParserSession parserSession = new ParserSession();
        Session session = this.sessionFactory.openSession();
        UnresolvableObjectException hibernateQueryError = null;
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((org.hibernate.Session)session);
            fullTextSession.setCacheMode(CacheMode.IGNORE);
            fullTextSession.setFlushMode(FlushMode.COMMIT);
            for (Map.Entry typeAndIds : this.toIndex.asMap().entrySet()) {
                String entityType = (String)typeAndIds.getKey();
                Collection entityIds = (Collection)typeAndIds.getValue();
                Iterator iterator = entityIds.iterator();
                while (iterator.hasNext()) {
                    long entityId = (Long)iterator.next();
                    Transaction transaction = fullTextSession.beginTransaction();
                    String hql = "FROM " + entityType + " WHERE id = :id";
                    Query query = fullTextSession.createQuery(hql);
                    query.setLong("id", entityId);
                    query.setReadOnly(true);
                    Object entity = query.uniqueResult();
                    if (entity != null) {
                        Class entityClass = Hibernate.getClass((Object)entity);
                        if (this.isIncluded(entityClass)) {
                            LOGGER.debug("indexing {}:{}", (Object)entityType, (Object)((IObject)entity).getId());
                            try {
                                fullTextSession.index(entity);
                            }
                            catch (BridgeException be) {
                                LOGGER.warn("failed to index {}:{}", new Object[]{entityType, ((IObject)entity).getId(), be.getCause()});
                            }
                        } else {
                            LOGGER.debug("skipping {}:{}", (Object)entityType, (Object)((IObject)entity).getId());
                        }
                    }
                    transaction.commit();
                }
            }
            this.toIndex.clear();
        }
        catch (UnresolvableObjectException uoe) {
            hibernateQueryError = uoe;
        }
        finally {
            DetailsFieldBridge.unlock();
            session.close();
            parserSession.closeParsedFiles();
        }
        try {
            if (hibernateQueryError != null) {
                this.toIndex.clear();
                this.toPurge.clear();
                LOGGER.info("Hibernate query failed, aborting this indexer run", (Throwable)hibernateQueryError);
                this.register(Step.PREPARE, Event.HIBERNATE_QUERY_ERROR);
            } else if (!this.toPurge.isEmpty()) {
                this.register(Step.PURGE);
            } else {
                this.register(Step.NOTE);
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to continue indexer", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        UnresolvableObjectException hibernateQueryError;
        block19: {
            LOGGER.info("purging objects: count = {}", (Object)this.toPurge.size());
            if (!DetailsFieldBridge.tryLock()) {
                LOGGER.info("failed to lock field bridge so will wait awhile");
                try {
                    this.register(Step.PURGE, Event.FIELD_BRIDGE_CONTENTION);
                }
                catch (Throwable t) {
                    LOGGER.error("failed to continue indexer", t);
                }
                return;
            }
            DetailsFieldBridge.setFieldBridge((FieldBridge)this.bridge);
            Session session = this.sessionFactory.openSession();
            hibernateQueryError = null;
            try {
                FullTextSession fullTextSession = Search.getFullTextSession((org.hibernate.Session)session);
                fullTextSession.setCacheMode(CacheMode.IGNORE);
                fullTextSession.setFlushMode(FlushMode.COMMIT);
                Transaction transaction = fullTextSession.beginTransaction();
                for (Map.Entry typeAndIds : this.toPurge.asMap().entrySet()) {
                    Class<IObject> entityClass;
                    String entityType = (String)typeAndIds.getKey();
                    Collection entityIds = (Collection)typeAndIds.getValue();
                    try {
                        entityClass = Class.forName(entityType).asSubclass(IObject.class);
                    }
                    catch (ClassCastException | ReflectiveOperationException e) {
                        LOGGER.warn("unknown entity type in event log: {}", (Object)entityType, (Object)e);
                        continue;
                    }
                    for (Long entityId : entityIds) {
                        LOGGER.debug("purging {}:{}", (Object)entityType, (Object)entityId);
                        fullTextSession.purge(entityClass, (Serializable)entityId);
                    }
                    if (!this.isIncluded(entityClass)) continue;
                    Integer count = this.purgeCounts.get(entityClass);
                    this.purgeCounts.put(entityClass, entityIds.size() + (count == null ? 0 : count));
                }
                transaction.commit();
                this.toPurge.clear();
            }
            catch (UnresolvableObjectException uoe) {
                hibernateQueryError = uoe;
            }
            catch (BridgeException be) {
                if (be.getCause() instanceof UnresolvableObjectException) {
                    hibernateQueryError = (UnresolvableObjectException)be.getCause();
                    break block19;
                }
                throw be;
            }
            finally {
                DetailsFieldBridge.unlock();
                session.close();
            }
        }
        try {
            if (hibernateQueryError != null) {
                this.toIndex.clear();
                this.toPurge.clear();
                LOGGER.info("Hibernate query failed, aborting this indexer run", (Throwable)hibernateQueryError);
                this.register(Step.PREPARE, Event.HIBERNATE_QUERY_ERROR);
            } else {
                this.register(Step.NOTE);
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to continue indexer", t);
        }
    }

    public void note() {
        LOGGER.debug("noting event log entries as processed");
        try (Session session = this.sessionFactory.openSession();){
            session.setFlushMode(FlushMode.COMMIT);
            Transaction transaction = session.beginTransaction();
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    PreparedStatement stmt = connection.prepareStatement("UPDATE configuration SET value = ? WHERE name = ?");
                    stmt.setString(1, Long.toString(FullTextIndexer2.this.eventLogId));
                    stmt.setString(2, FullTextIndexer2.this.countKey);
                    try {
                        stmt.execute();
                        if (stmt.getUpdateCount() == 0) {
                            stmt.close();
                            stmt = connection.prepareStatement("INSERT INTO configuration (name, value) VALUES (?, ?)");
                            stmt.setString(1, FullTextIndexer2.this.countKey);
                            stmt.setString(2, Long.toString(FullTextIndexer2.this.eventLogId));
                            stmt.execute();
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
            });
            transaction.commit();
        }
        try {
            this.register(Step.PREPARE);
        }
        catch (Throwable t) {
            LOGGER.error("failed to continue indexer", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        try (Session session = this.sessionFactory.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((org.hibernate.Session)session);
            fullTextSession.setCacheMode(CacheMode.IGNORE);
            fullTextSession.setFlushMode(FlushMode.COMMIT);
            Transaction transaction = fullTextSession.beginTransaction();
            SearchFactory searchFactory = fullTextSession.getSearchFactory();
            if (this.purgeCounts.isEmpty()) {
                LOGGER.info("defragmenting whole search index");
                searchFactory.optimize();
            } else {
                for (Map.Entry<Class<? extends IObject>, Integer> purgeCount : this.purgeCounts.entrySet()) {
                    if (purgeCount.getValue() < 4096) continue;
                    Class<? extends IObject> entityClass = purgeCount.getKey();
                    LOGGER.info("defragmenting search index for {}", entityClass);
                    searchFactory.optimize(entityClass);
                    this.purgeCounts.remove(entityClass);
                    break;
                }
            }
            transaction.commit();
        }
        try {
            this.register(Step.PREPARE);
        }
        catch (Throwable t) {
            LOGGER.error("failed to continue indexer", t);
        }
    }

    private static enum Event {
        STARTUP(20),
        FIELD_BRIDGE_CONTENTION(5),
        HIBERNATE_QUERY_ERROR(10),
        NOTHING_NEW_TO_INDEX(2);

        private final int seconds;

        private Event(int seconds) {
            this.seconds = seconds;
        }

        private Date getWhen() {
            return DateBuilder.futureDate((int)this.seconds, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND);
        }
    }

    private static enum Step {
        PREPARE,
        INDEX,
        INDEX_RETRY,
        PURGE,
        NOTE,
        OPTIMIZE;

    }
}

