/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import ome.services.util.BeanInstantiationGuard;
import ome.services.util.ReadOnlyStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanInstantiationSubstituter
extends BeanInstantiationGuard {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanInstantiationSubstituter.class);
    private final String substituteClass;

    public BeanInstantiationSubstituter(ReadOnlyStatus readOnly, String targetName, String substituteClass) {
        super(readOnly, targetName);
        this.substituteClass = substituteClass;
    }

    @Override
    protected void setBeanDefinitionForReadOnly(BeanDefinitionRegistry registry) {
        LOGGER.info("in read-only state so setting Spring bean named {} to instantiate {}", (Object)this.targetName, (Object)this.substituteClass);
        registry.getBeanDefinition(this.targetName).setBeanClassName(this.substituteClass);
    }
}

