/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SleepTimer {
    private static volatile Semaphore SHARED_SEMAPHORE = new Semaphore(0);

    public static boolean sleepFor(long milliseconds) {
        Semaphore semaphoreCopy = SHARED_SEMAPHORE;
        if (semaphoreCopy == null) {
            return true;
        }
        try {
            return semaphoreCopy.tryAcquire(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    public void destroy() {
        Semaphore semaphoreCopy = SHARED_SEMAPHORE;
        if (semaphoreCopy != null) {
            SHARED_SEMAPHORE = null;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (semaphoreCopy.hasQueuedThreads()) {
                semaphoreCopy.release();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

