/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.util.function.Consumer;
import ome.security.SecuritySystem;
import ome.system.EventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutSetter.class);
    private final SecuritySystem securitySystem;
    private final int timeout;
    private final int timeoutAdmin;

    public TimeoutSetter(SecuritySystem securitySystem, int timeout, int timeoutAdmin) {
        if (timeout < 1 || timeoutAdmin < 1) {
            throw new IllegalArgumentException("query timeouts must be strictly positive");
        }
        this.securitySystem = securitySystem;
        this.timeout = timeout;
        this.timeoutAdmin = timeoutAdmin;
        if (timeout == timeoutAdmin) {
            LOGGER.info("Query timeout set to {}s for all users.", (Object)timeout);
        } else {
            LOGGER.info("Query timeout set to {}s and for administrators to {}s.", (Object)timeout, (Object)timeoutAdmin);
        }
    }

    public void setTimeout(Consumer<Integer> query) {
        EventContext ec = this.securitySystem.getEventContext();
        int selectedTimeout = ec.isCurrentUserAdmin() ? this.timeoutAdmin : this.timeout;
        query.accept(selectedTimeout);
        Long userId = ec.getCurrentUserId();
        if (userId == null) {
            LOGGER.debug("Set timeout for unknown user's query to {}s.", (Object)selectedTimeout);
        } else {
            LOGGER.debug("Set timeout for user {}'s query to {}s.", (Object)userId, (Object)selectedTimeout);
        }
    }
}

