/*
 * Decompiled with CFR 0.152.
 */
package ome.model.annotations;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;

@Entity
@DiscriminatorValue(value="/basic/text/")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public abstract class TextAnnotation
extends Annotation
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "textannotation_owner_filter";
    public static final String GROUP_FILTER = "textannotation_group_filter";
    public static final String EVENT_FILTER = "textannotation_event_filter";
    public static final String PERMS_FILTER = "textannotation_perms_filter";
    protected String textValue = null;
    public static final String TEXTVALUE = "ome.model.annotations.TextAnnotation_textValue";
    public static final Set<String> FIELDS;

    public TextAnnotation() {
        this(null, true);
    }

    protected TextAnnotation(Long id) {
        this(id, true);
    }

    public TextAnnotation(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="textValue", updatable=true)
    public String getTextValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.textValue = textValue;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.textValue = (String)__filter.filter(TEXTVALUE, this.textValue);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(TEXTVALUE)) {
            return this.getTextValue();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(TEXTVALUE)) {
            this.setTextValue((String)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.textValue = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(TEXTVALUE);
        raw.addAll(Annotation.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

