/*
 * Decompiled with CFR 0.152.
 */
package ome.model.enums;

import java.util.HashMap;
import java.util.Map;
import ome.model.units.UnitEnum;

public enum UnitsPower implements UnitEnum
{
    YOTTAWATT("YW"),
    ZETTAWATT("ZW"),
    EXAWATT("EW"),
    PETAWATT("PW"),
    TERAWATT("TW"),
    GIGAWATT("GW"),
    MEGAWATT("MW"),
    KILOWATT("kW"),
    HECTOWATT("hW"),
    DECAWATT("daW"),
    WATT("W"),
    DECIWATT("dW"),
    CENTIWATT("cW"),
    MILLIWATT("mW"),
    MICROWATT("\u00b5W"),
    NANOWATT("nW"),
    PICOWATT("pW"),
    FEMTOWATT("fW"),
    ATTOWATT("aW"),
    ZEPTOWATT("zW"),
    YOCTOWATT("yW");

    private static final Map<String, UnitsPower> bySymbol;
    protected String symbol;

    private UnitsPower(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static UnitsPower bySymbol(String symbol) {
        return bySymbol.get(symbol);
    }

    static {
        bySymbol = new HashMap<String, UnitsPower>();
        for (UnitsPower t : UnitsPower.values()) {
            bySymbol.put(t.symbol, t);
        }
    }
}

