/*
 * Decompiled with CFR 0.152.
 */
package ome.model.jobs;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.jobs.Job;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@PrimaryKeyJoinColumn(name="job_id")
@Table(name="importjob")
@ForeignKey(name="FKimportjob_job_id_job")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
@Deprecated
public class ImportJob
extends Job
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "importjob_owner_filter";
    public static final String GROUP_FILTER = "importjob_group_filter";
    public static final String EVENT_FILTER = "importjob_event_filter";
    public static final String PERMS_FILTER = "importjob_perms_filter";
    protected String imageName = null;
    protected String imageDescription = null;
    public static final String IMAGENAME = "ome.model.jobs.ImportJob_imageName";
    public static final String IMAGEDESCRIPTION = "ome.model.jobs.ImportJob_imageDescription";
    public static final Set<String> FIELDS;

    public ImportJob() {
        this(null, true);
    }

    protected ImportJob(Long id) {
        this(id, true);
    }

    public ImportJob(Long id, boolean loaded) {
        super(id, loaded);
    }

    public ImportJob(String _imageName, String _imageDescription) {
        this(null, true);
        this.setImageName(_imageName);
        this.setImageDescription(_imageDescription);
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="imageName", updatable=true)
    public String getImageName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.imageName;
    }

    public void setImageName(String imageName) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.imageName = imageName;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="imageDescription", updatable=true)
    public String getImageDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.imageDescription;
    }

    public void setImageDescription(String imageDescription) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.imageDescription = imageDescription;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public ImportJob newInstance() {
        return new ImportJob();
    }

    public ImportJob proxy() {
        return new ImportJob(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.imageName = (String)__filter.filter(IMAGENAME, this.imageName);
            this.imageDescription = (String)__filter.filter(IMAGEDESCRIPTION, this.imageDescription);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(IMAGENAME)) {
            return this.getImageName();
        }
        if (field.equals(IMAGEDESCRIPTION)) {
            return this.getImageDescription();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(IMAGENAME)) {
            this.setImageName((String)value);
        } else if (field.equals(IMAGEDESCRIPTION)) {
            this.setImageDescription((String)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.imageName = null;
        this.imageDescription = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(IMAGENAME);
        raw.addAll(Job.FIELDS);
        raw.add(IMAGEDESCRIPTION);
        raw.addAll(Job.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

