/*
 * Decompiled with CFR 0.152.
 */
package ome.model.jobs;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.internal.NamedValue;
import ome.model.jobs.Job;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@PrimaryKeyJoinColumn(name="job_id")
@Table(name="metadataimportjob")
@ForeignKey(name="FKmetadataimportjob_job_id_job")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class MetadataImportJob
extends Job
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "metadataimportjob_owner_filter";
    public static final String GROUP_FILTER = "metadataimportjob_group_filter";
    public static final String EVENT_FILTER = "metadataimportjob_event_filter";
    public static final String PERMS_FILTER = "metadataimportjob_perms_filter";
    protected List<NamedValue> versionInfo = null;
    public static final String VERSIONINFO = "ome.model.jobs.MetadataImportJob_versionInfo";
    public static final Set<String> FIELDS;

    public MetadataImportJob() {
        this(null, true);
    }

    protected MetadataImportJob(Long id) {
        this(id, true);
    }

    public MetadataImportJob(Long id, boolean loaded) {
        super(id, loaded);
    }

    public void setVersionInfo(List<NamedValue> map) {
        this.versionInfo = map;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn(name="index")
    @CollectionTable(name="metadataimportjob_versionInfo", joinColumns={@JoinColumn(name="metadataimportjob_id")})
    @Column(name="versionInfo", nullable=false)
    @ForeignKey(name="FKmetadataimportjob_versionInfo_map")
    public List<NamedValue> getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public MetadataImportJob newInstance() {
        return new MetadataImportJob();
    }

    public MetadataImportJob proxy() {
        return new MetadataImportJob(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.versionInfo = (List)__filter.filter(VERSIONINFO, this.versionInfo);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(VERSIONINFO)) {
            return this.getVersionInfo();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(VERSIONINFO)) {
            this.setVersionInfo((List)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.versionInfo = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(VERSIONINFO);
        raw.addAll(Job.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

