/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IGlobal;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.Session;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@PrimaryKeyJoinColumn(name="session_id")
@Table(name="share")
@ForeignKey(name="FKshare_session_id_session")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Share
extends Session
implements Serializable,
IObject,
IGlobal,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    protected ExperimenterGroup group = null;
    protected Long itemCount = null;
    protected Boolean active = null;
    protected byte[] data = null;
    public static final String GROUP = "ome.model.meta.Share_group";
    public static final String ITEMCOUNT = "ome.model.meta.Share_itemCount";
    public static final String ACTIVE = "ome.model.meta.Share_active";
    public static final String DATA = "ome.model.meta.Share_data";
    public static final Set<String> FIELDS;

    public Share() {
        this(null, true);
    }

    protected Share(Long id) {
        this(id, true);
    }

    public Share(Long id, boolean loaded) {
        super(id, loaded);
    }

    public Share(ExperimenterGroup _group, Long _itemCount, Boolean _active, byte[] _data) {
        this(null, true);
        this.setGroup(_group);
        this.setItemCount(_itemCount);
        this.setActive(_active);
        this.setData(_data);
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ExperimenterGroup.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="\"group\"", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKshare_group_experimentergroup")
    public ExperimenterGroup getGroup() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.group;
    }

    public void setGroup(ExperimenterGroup group) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.group = group;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="itemCount", updatable=true)
    public Long getItemCount() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.itemCount;
    }

    public void setItemCount(Long itemCount) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.itemCount = itemCount;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="active", updatable=true)
    public Boolean getActive() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.active = active;
    }

    @Column(columnDefinition="bytea", nullable=false, unique=false, name="data", updatable=true)
    public byte[] getData() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.data;
    }

    public void setData(byte[] data) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.data = data;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    @Override
    public Share newInstance() {
        return new Share();
    }

    @Override
    public Share proxy() {
        return new Share(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.group = (ExperimenterGroup)__filter.filter(GROUP, this.group);
            this.itemCount = (Long)__filter.filter(ITEMCOUNT, this.itemCount);
            this.active = (Boolean)__filter.filter(ACTIVE, this.active);
            this.data = (byte[])__filter.filter(DATA, this.data);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(GROUP)) {
            return this.getGroup();
        }
        if (field.equals(ITEMCOUNT)) {
            return this.getItemCount();
        }
        if (field.equals(ACTIVE)) {
            return this.getActive();
        }
        if (field.equals(DATA)) {
            return this.getData();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(GROUP)) {
            this.setGroup((ExperimenterGroup)value);
        } else if (field.equals(ITEMCOUNT)) {
            this.setItemCount((Long)value);
        } else if (field.equals(ACTIVE)) {
            this.setActive((Boolean)value);
        } else if (field.equals(DATA)) {
            this.setData((byte[])value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.group = null;
        this.itemCount = null;
        this.active = null;
        this.data = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(GROUP);
        raw.addAll(Session.FIELDS);
        raw.add(ITEMCOUNT);
        raw.addAll(Session.FIELDS);
        raw.add(ACTIVE);
        raw.addAll(Session.FIELDS);
        raw.add(DATA);
        raw.addAll(Session.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

