/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import ome.model.enums.UnitsFrequency;
import ome.model.units.Unit;
import ome.util.Filter;
import ome.util.Filterable;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsFrequencyEnumHandler;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class Frequency
implements Serializable,
Filterable,
Unit {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "ome.model.units.Frequency_value";
    public static final String UNIT = "ome.model.units.Frequency_unit";
    private double value;
    private UnitsFrequency unit = null;

    public static ome.xml.model.enums.UnitsFrequency makeFrequencyUnitXML(String unit) {
        try {
            return ome.xml.model.enums.UnitsFrequency.fromString((String)unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Frequency unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Frequency makeFrequencyXML(double d, String unit) {
        ome.units.unit.Unit units = UnitsFrequencyEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsFrequency)Frequency.makeFrequencyUnitXML(unit));
        return new ome.units.quantity.Frequency((Number)d, units);
    }

    public static ome.units.quantity.Frequency convertFrequency(Frequency t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = t.getUnit().getSymbol();
        ome.xml.model.enums.UnitsFrequency units = Frequency.makeFrequencyUnitXML(u);
        ome.units.unit.Unit units2 = UnitsFrequencyEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsFrequency)units);
        return new ome.units.quantity.Frequency((Number)v, units2);
    }

    public static Frequency convertFrequency(Frequency value, ome.units.unit.Unit<ome.units.quantity.Frequency> ul) {
        return Frequency.convertFrequency(value, ul.getSymbol());
    }

    public static Frequency convertFrequency(Frequency value, String target) {
        String source = value.getUnit().getSymbol();
        if (target.equals(source)) {
            return value;
        }
        throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit().getSymbol(), source));
    }

    @Deprecated
    public Frequency() {
    }

    public Frequency(double d, String u) {
        this.value = d;
        this.unit = UnitsFrequency.valueOf(u);
    }

    public Frequency(double d, UnitsFrequency u) {
        this.value = d;
        this.unit = u;
    }

    public Frequency(double d, ome.units.unit.Unit<ome.units.quantity.Frequency> unit) {
        this(d, UnitsFrequency.bySymbol(unit.getSymbol()));
    }

    public Frequency(ome.units.quantity.Frequency value) {
        this(value.value().doubleValue(), UnitsFrequency.bySymbol(value.unit().getSymbol()));
    }

    @Override
    @Column(name="value", nullable=false)
    public double getValue() {
        return this.value;
    }

    @Override
    @Column(name="unit", nullable=false, unique=false, insertable=true, updatable=true)
    @Type(type="ome.model.units.GenericEnumType", parameters={@Parameter(name="unit", value="FREQUENCY")})
    public UnitsFrequency getUnit() {
        return this.unit;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void setUnit(UnitsFrequency unit) {
        this.unit = unit;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.unit = (UnitsFrequency)filter.filter(UNIT, this.unit);
        this.value = (Double)filter.filter(VALUE, this.value);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Frequency(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Frequency other = (Frequency)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

