/*
 * Decompiled with CFR 0.152.
 */
package ome.util.actions;

import com.google.common.collect.Iterables;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.InternalException;
import ome.util.SqlAction;
import ome.util.actions.PsqlStrings;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;

public class PostgresSqlAction
extends SqlAction.Impl {
    private final JdbcTemplate jdbc;
    private final NamedParameterJdbcTemplate namedJdbc;
    private static final String synchronizeJobsSql = PsqlStrings.getString("sql_action.sync_jobs");
    @Deprecated
    public static final String insertFormatSql = PsqlStrings.getString("sql_action.insert_format");
    private static final String logLoaderQuerySql = PsqlStrings.getString("sql_action.log_loader_query");
    private static final String logLoaderInsertSql = PsqlStrings.getString("sql_action.log_loader_insert");
    private static final String logLoaderUpdateSql = PsqlStrings.getString("sql_action.log_loader_update");
    private static final String logLoaderDeleteSql = PsqlStrings.getString("sql_action.log_loader_delete");

    public PostgresSqlAction(JdbcTemplate jdbc) {
        this.jdbc = jdbc;
        this.namedJdbc = new NamedParameterJdbcTemplate((JdbcOperations)jdbc);
    }

    @Override
    protected JdbcTemplate _jdbc() {
        return this.jdbc;
    }

    @Override
    protected NamedParameterJdbcTemplate _namedJdbc() {
        return this.namedJdbc;
    }

    @Override
    protected String _lookup(String key) {
        return PsqlStrings.getString("sql_action." + key);
    }

    @Override
    public String rewriteHql(String query, String key, Object value) {
        return query;
    }

    @Override
    public void prepareSession(long eventId, long userId, long groupId) {
        SimpleJdbcCall call = new SimpleJdbcCall(this._jdbc()).withFunctionName("_prepare_session").withoutProcedureColumnMetaDataAccess().declareParameters(new SqlParameter[]{new SqlParameter("_event_id", -5), new SqlParameter("_user_id", -5), new SqlParameter("_group_id", -5)});
        MapSqlParameterSource in = new MapSqlParameterSource();
        in.addValue("_event_id", (Object)eventId);
        in.addValue("_user_id", (Object)userId);
        in.addValue("_group_id", (Object)groupId);
        call.executeFunction(Void.TYPE, (SqlParameterSource)in);
    }

    @Override
    public boolean activeSession(String sessionUUID) {
        int count = (Integer)this._jdbc().queryForObject(this._lookup("active_session"), Integer.class, new Object[]{sessionUUID});
        return count > 0;
    }

    @Override
    public int synchronizeJobs(List<Long> ids) {
        int count = 0;
        if (ids.size() > 0) {
            HashMap<String, List<Long>> m = new HashMap<String, List<Long>>();
            m.put("ids", ids);
            count += this._namedJdbc().update(synchronizeJobsSql + this._lookup("id_not_in"), m);
        } else {
            count += this._jdbc().update(synchronizeJobsSql);
        }
        return count;
    }

    @Override
    public List<Long> findRepoPixels(String uuid, String dirname, String basename) {
        return this._jdbc().query(this._lookup("find_repo_pixels"), (arg0, arg1) -> arg0.getLong(1), new Object[]{uuid, dirname, basename});
    }

    @Override
    public Long findRepoImageFromPixels(long id) {
        return (Long)this._jdbc().queryForObject(this._lookup("find_repo_image_from_pixels"), Long.class, new Object[]{id});
    }

    @Override
    public Long nextSessionId() {
        return (Long)this._jdbc().queryForObject(this._lookup("next_session"), Long.class);
    }

    @Override
    public Map<String, Object> repoFile(long value) {
        return this._jdbc().queryForMap(this._lookup("repo_file"), new Object[]{value});
    }

    @Override
    public long countFormat(String name) {
        return (Long)this._jdbc().queryForObject(this._lookup("count_format"), Long.class, new Object[]{name});
    }

    @Override
    @Deprecated
    public int insertFormat(String name) {
        return this._jdbc().update(insertFormatSql, new Object[]{name});
    }

    @Override
    public int closeSessions(String uuid) {
        return this._jdbc().update(this._lookup("update_session"), new Object[]{uuid});
    }

    @Override
    public long nodeId(String internal_uuid) {
        return (Long)this._jdbc().queryForObject(this._lookup("internal_uuid"), Long.class, new Object[]{internal_uuid});
    }

    @Override
    public int insertSession(Map<String, Object> params) {
        return this._namedJdbc().update(this._lookup("insert_session"), params);
    }

    @Override
    public int updateSessionUserIP(long sessionId, String userIP) {
        return this._jdbc().update(this._lookup("update_session_user_ip"), new Object[]{userIP, sessionId});
    }

    @Override
    public Long sessionId(String uuid) {
        return (Long)this._jdbc().queryForObject(this._lookup("session_id"), Long.class, new Object[]{uuid});
    }

    @Override
    public int removePassword(Long id) {
        return this._jdbc().update(this._lookup("remove_pass"), new Object[]{id});
    }

    @Override
    public Date now() {
        return (Date)this._jdbc().queryForObject(this._lookup("now"), Date.class);
    }

    @Override
    public int updateConfiguration(String key, String value) {
        return this._jdbc().update(this._lookup("update_config"), new Object[]{value, key});
    }

    @Override
    public String dbVersion() {
        return (String)this._jdbc().query(this._lookup("db_version"), (arg0, arg1) -> {
            String v = arg0.getString("currentversion");
            int p = arg0.getInt("currentpatch");
            return v + "__" + p;
        }).get(0);
    }

    @Override
    public String dbUuid() {
        return (String)this._jdbc().query(this._lookup("db_uuid"), (arg0, arg1) -> {
            String s = arg0.getString("value");
            return s;
        }).get(0);
    }

    @Override
    public long selectCurrentEventLog(String key) {
        return (Long)this._jdbc().queryForObject(logLoaderQuerySql, Long.class, new Object[]{key});
    }

    @Override
    public void setCurrentEventLog(long id, String key) {
        int count = this._jdbc().update(logLoaderUpdateSql, new Object[]{id, key});
        if (count == 0) {
            this._jdbc().update(logLoaderInsertSql, new Object[]{key, id});
        }
    }

    @Override
    public void delCurrentEventLog(String key) {
        this._jdbc().update(logLoaderDeleteSql, new Object[]{key});
    }

    @Override
    public long nextValue(String segmentValue, int incrementSize) {
        return (Long)this._jdbc().queryForObject(this._lookup("next_val"), Long.class, new Object[]{segmentValue, incrementSize});
    }

    @Override
    public long currValue(String segmentName) {
        try {
            return (Long)this._jdbc().queryForObject(this._lookup("curr_val"), Long.class, new Object[]{segmentName});
        }
        catch (EmptyResultDataAccessException erdae) {
            return -1L;
        }
    }

    @Override
    public void insertLogs(List<Object[]> batchData) {
        this._jdbc().batchUpdate(this._lookup("insert_logs"), batchData);
    }

    @Override
    public List<Map<String, Object>> roiByImage(long imageId) {
        String queryString = this._lookup("roi_by_image");
        return this._jdbc().queryForList(queryString, new Object[]{imageId});
    }

    @Override
    public List<Long> getShapeIds(long roiId) {
        return this._jdbc().query(this._lookup("shape_ids"), (RowMapper)new SqlAction.IdRowMapper(), new Object[]{roiId});
    }

    @Override
    public void setFileRepo(Collection<Long> ids, String repoId) {
        for (List idsBatch : Iterables.partition(ids, (int)256)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ids", idsBatch);
            params.put("repo", repoId);
            this._namedJdbc().update(this._lookup("set_file_repo"), params);
        }
    }

    @Override
    public void setPixelsNamePathRepo(long pixId, String name, String path, String repoId) {
        this._jdbc().update(this._lookup("update_pixels_name"), new Object[]{name, pixId});
        this._jdbc().update(this._lookup("update_pixels_path"), new Object[]{path, pixId});
        this._jdbc().update(this._lookup("update_pixels_repo"), new Object[]{repoId, pixId});
    }

    @Override
    public List<Long> getDeletedIds(String entityType) {
        String sql = this._lookup("get_delete_ids");
        RowMapper mapper = (resultSet, rowNum) -> new Long(resultSet.getString(1));
        return this._jdbc().query(sql, mapper, new Object[]{entityType});
    }

    @Override
    public void createSavepoint(String savepoint) {
        this.call("SAVEPOINT DEL", savepoint);
    }

    @Override
    public void releaseSavepoint(String savepoint) {
        this.call("RELEASE SAVEPOINT DEL", savepoint);
    }

    @Override
    public void rollbackSavepoint(String savepoint) {
        this.call("ROLLBACK TO SAVEPOINT DEL", savepoint);
    }

    private void call(String call, String savepoint) {
        this._jdbc().execute(con -> {
            con.prepareCall(call + savepoint).execute();
            return null;
        });
    }

    @Override
    public void deferConstraints() {
        this._jdbc().execute(con -> {
            Statement statement = con.createStatement();
            statement.execute("set constraints all deferred;");
            return null;
        });
    }

    @Override
    public Set<String> currentUserNames() {
        List names = this._jdbc().query(this._lookup("current_user_names"), (arg0, arg1) -> arg0.getString(1));
        return new HashSet<String>(names);
    }

    @Override
    public List<String> getPixelsNamePathRepo(long id) throws InternalException {
        try {
            return (List)this._jdbc().queryForObject(this._lookup("get_pixels_name_path_repo"), (arg0, arg1) -> {
                ArrayList<String> values = new ArrayList<String>();
                values.add(arg0.getString(1));
                values.add(arg0.getString(2));
                values.add(arg0.getString(3));
                return values;
            }, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (UncategorizedSQLException e) {
            this.handlePotentialPgArrayJarError(e);
            return null;
        }
    }

    protected void handlePotentialPgArrayJarError(UncategorizedSQLException e) {
        this.log.error(e.toString());
        throw new InternalException("Potential jdbc jar error during pgarray access (See #7432)\n" + this.printThrowable(e));
    }
}

