/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.core.codec.core;

import com.fasterxml.jackson.annotation.JsonValue;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.codec.ArrayBytesCodec;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ucar.ma2.Array;
import ucar.ma2.ArrayBoolean;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;

public abstract class BytesCodec
extends ArrayBytesCodec {
    protected abstract ByteOrder getByteOrder() throws ZarrException;

    @Override
    public Array decode(ByteBuffer chunkBytes) throws ZarrException {
        ByteOrder order = ByteOrder.BIG_ENDIAN;
        if (this.arrayMetadata.dataType.getByteCount() > 1) {
            order = this.getByteOrder();
        }
        chunkBytes.order(order);
        DataType dtype = this.arrayMetadata.dataType.getMA2DataType();
        int[] shape = this.arrayMetadata.chunkShape;
        if (dtype == DataType.BOOLEAN) {
            int size = chunkBytes.remaining();
            boolean[] bools = new boolean[size];
            for (int i = 0; i < size; ++i) {
                bools[i] = chunkBytes.get(i) != 0;
            }
            Index index = Index.factory((int[])shape);
            return Array.factory((DataType)DataType.BOOLEAN, (Index)index, (Object)bools);
        }
        return Array.factory((DataType)dtype, (int[])shape, (ByteBuffer)chunkBytes);
    }

    @Override
    public ByteBuffer encode(Array chunkArray) throws ZarrException {
        ByteOrder order = ByteOrder.BIG_ENDIAN;
        if (this.arrayMetadata.dataType.getByteCount() > 1) {
            order = this.getByteOrder();
        }
        if (chunkArray instanceof ArrayBoolean) {
            boolean[] data = (boolean[])chunkArray.copyTo1DJavaArray();
            ByteBuffer bb = ByteBuffer.allocate(data.length);
            for (boolean b : data) {
                bb.put((byte)(b ? 1 : 0));
            }
            bb.flip();
            return bb;
        }
        if (chunkArray instanceof ArrayFloat) {
            float[] data = (float[])chunkArray.copyTo1DJavaArray();
            ByteBuffer bb = ByteBuffer.allocate(data.length * 4).order(order);
            for (float f : data) {
                bb.putFloat(f);
            }
            bb.flip();
            return bb;
        }
        if (chunkArray instanceof ArrayDouble) {
            double[] data = (double[])chunkArray.copyTo1DJavaArray();
            ByteBuffer bb = ByteBuffer.allocate(data.length * 8).order(order);
            for (double d : data) {
                bb.putDouble(d);
            }
            bb.flip();
            return bb;
        }
        return chunkArray.getDataAsByteBuffer(order);
    }

    public static enum Endian {
        LITTLE("little"),
        BIG("big");

        private final String endian;

        private Endian(String endian) {
            this.endian = endian;
        }

        @JsonValue
        public String getValue() {
            return this.endian;
        }

        public ByteOrder getByteOrder() {
            switch (this) {
                case LITTLE: {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                case BIG: {
                    return ByteOrder.BIG_ENDIAN;
                }
            }
            throw new RuntimeException("Unreachable");
        }

        public static Endian nativeOrder() {
            return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? LITTLE : BIG;
        }
    }
}

