/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3;

import com.fasterxml.jackson.databind.ObjectWriter;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.Attributes;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v3.Array;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.ArrayMetadataBuilder;
import dev.zarr.zarrjava.v3.GroupMetadata;
import dev.zarr.zarrjava.v3.Node;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Group
extends dev.zarr.zarrjava.core.Group
implements Node {
    public GroupMetadata metadata;

    protected Group(@Nonnull StoreHandle storeHandle, @Nonnull GroupMetadata groupMetadata) throws IOException {
        super(storeHandle);
        this.metadata = groupMetadata;
    }

    public static Group open(@Nonnull StoreHandle storeHandle) throws IOException {
        StoreHandle metadataHandle = storeHandle.resolve("zarr.json");
        ByteBuffer metadataBytes = metadataHandle.readNonNull();
        return new Group(storeHandle, (GroupMetadata)Node.makeObjectMapper().readValue(Utils.toArray(metadataBytes), GroupMetadata.class));
    }

    public static Group open(Path path) throws IOException {
        return Group.open(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Group open(String path) throws IOException {
        return Group.open(Paths.get(path, new String[0]));
    }

    public static Group create(@Nonnull StoreHandle storeHandle, @Nonnull GroupMetadata groupMetadata) throws IOException {
        ObjectWriter objectWriter = Node.makeObjectWriter();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectWriter.writeValueAsBytes((Object)groupMetadata));
        storeHandle.resolve("zarr.json").set(metadataBytes);
        return new Group(storeHandle, groupMetadata);
    }

    public static Group create(@Nonnull StoreHandle storeHandle, @Nonnull Attributes attributes) throws IOException, ZarrException {
        return Group.create(storeHandle, new GroupMetadata(attributes));
    }

    public static Group create(@Nonnull StoreHandle storeHandle) throws IOException, ZarrException {
        return Group.create(storeHandle, GroupMetadata.defaultValue());
    }

    public static Group create(Path path, GroupMetadata groupMetadata) throws IOException, ZarrException {
        return Group.create(new FilesystemStore(path).resolve(new String[0]), groupMetadata);
    }

    public static Group create(String path, GroupMetadata groupMetadata) throws IOException, ZarrException {
        return Group.create(Paths.get(path, new String[0]), groupMetadata);
    }

    public static Group create(Path path) throws IOException, ZarrException {
        return Group.create(new FilesystemStore(path).resolve(new String[0]));
    }

    public static Group create(String path) throws IOException, ZarrException {
        return Group.create(Paths.get(path, new String[0]));
    }

    @Override
    @Nullable
    public Node get(String key) throws ZarrException {
        StoreHandle keyHandle = this.storeHandle.resolve(key);
        try {
            return Node.open(keyHandle);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Group createGroup(String key, GroupMetadata groupMetadata) throws IOException, ZarrException {
        return Group.create(this.storeHandle.resolve(key), groupMetadata);
    }

    public Group createGroup(String key, Attributes attributes) throws IOException, ZarrException {
        return Group.create(this.storeHandle.resolve(key), new GroupMetadata(attributes));
    }

    public Group createGroup(String key) throws IOException, ZarrException {
        return Group.create(this.storeHandle.resolve(key), GroupMetadata.defaultValue());
    }

    public Array createArray(String key, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(this.storeHandle.resolve(key), arrayMetadata);
    }

    public Array createArray(String key, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper) throws IOException, ZarrException {
        return Array.create(this.storeHandle.resolve(key), arrayMetadataBuilderMapper, false);
    }

    private Group writeMetadata(GroupMetadata newGroupMetadata) throws IOException {
        ObjectWriter objectWriter = Node.makeObjectWriter();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectWriter.writeValueAsBytes((Object)newGroupMetadata));
        this.storeHandle.resolve("zarr.json").set(metadataBytes);
        return new Group(this.storeHandle, newGroupMetadata);
    }

    public Group setAttributes(Attributes newAttributes) throws ZarrException, IOException {
        GroupMetadata newGroupMetadata = new GroupMetadata(newAttributes);
        return this.writeMetadata(newGroupMetadata);
    }

    public Group updateAttributes(Function<Attributes, Attributes> attributeMapper) throws ZarrException, IOException {
        return this.setAttributes(attributeMapper.apply(this.metadata.attributes));
    }

    public String toString() {
        return String.format("<v3.Group {%s}>", this.storeHandle);
    }

    @Override
    public GroupMetadata metadata() {
        return this.metadata;
    }
}

