/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.core;

import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.AbstractNode;
import dev.zarr.zarrjava.core.GroupMetadata;
import dev.zarr.zarrjava.core.Node;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Group
extends AbstractNode {
    protected Group(@Nonnull StoreHandle storeHandle) {
        super(storeHandle);
    }

    public static Group open(StoreHandle storeHandle) throws IOException, ZarrException {
        boolean isV3 = storeHandle.resolve("zarr.json").exists();
        boolean isV2 = storeHandle.resolve(".zgroup").exists();
        if (isV3 && isV2) {
            throw new ZarrException("Both Zarr v2 and v3 groups found at " + storeHandle);
        }
        if (isV3) {
            return dev.zarr.zarrjava.v3.Group.open(storeHandle);
        }
        if (isV2) {
            return dev.zarr.zarrjava.v2.Group.open(storeHandle);
        }
        throw new ZarrException("No Zarr group found at " + storeHandle);
    }

    public static Group open(Path path) throws IOException, ZarrException {
        return Group.open(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Group open(String path) throws IOException, ZarrException {
        return Group.open(Paths.get(path, new String[0]));
    }

    @Nullable
    public abstract Node get(String var1) throws ZarrException;

    public Stream<Node> list() {
        return this.storeHandle.list().map(key -> {
            try {
                return this.get((String)key);
            }
            catch (ZarrException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull);
    }

    public Node[] listAsArray() {
        try (Stream<Node> nodeStream = this.list();){
            Node[] nodeArray = (Node[])nodeStream.toArray(Node[]::new);
            return nodeArray;
        }
    }

    public abstract GroupMetadata metadata();
}

