/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import com.glencoesoftware.omero.zarr.OmeroAmazonS3ClientFactory;
import com.glencoesoftware.omero.zarr.OmeroS3FileSystem;
import com.glencoesoftware.omero.zarr.OmeroS3ReadOnlySeekableByteChannel;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.carlspring.cloud.storage.s3fs.S3ClientFactory;
import org.carlspring.cloud.storage.s3fs.S3FileSystem;
import org.carlspring.cloud.storage.s3fs.S3FileSystemProvider;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.carlspring.cloud.storage.s3fs.S3SeekableByteChannel;
import org.carlspring.cloud.storage.s3fs.attribute.S3BasicFileAttributes;
import software.amazon.awssdk.services.s3.S3Client;

public class OmeroS3FilesystemProvider
extends S3FileSystemProvider {
    private static final String ACCESS_KEY = "AWS_ACCESS_KEY_ID";
    private static final String SECRET_KEY = "AWS_SECRET_ACCESS_KEY";

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.validateUri(uri);
        Properties props = this.getProperties(uri, env);
        this.validateProperties(props);
        S3FileSystem fileSystem = this.createFileSystem(uri, props);
        return fileSystem;
    }

    private void validateProperties(Properties props) {
        Preconditions.checkArgument((props.getProperty(ACCESS_KEY) == null && props.getProperty(SECRET_KEY) == null || props.getProperty(ACCESS_KEY) != null && props.getProperty(SECRET_KEY) != null ? 1 : 0) != 0, (String)"%s and %s should both be provided or should both be omitted", (Object)ACCESS_KEY, (Object)SECRET_KEY);
    }

    private Properties getProperties(URI uri, Map<String, ?> env) {
        Properties props = this.loadAmazonProperties();
        this.addEnvProperties(props, env);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] keys = userInfo.split(":");
            props.setProperty(ACCESS_KEY, keys[0]);
            if (keys.length > 1) {
                props.setProperty(SECRET_KEY, keys[1]);
            }
        }
        return props;
    }

    public S3FileSystem createFileSystem(URI uri, Properties props) {
        return new OmeroS3FileSystem(this, this.getFileSystemKey(uri, props), this.getS3Client(uri, props), uri.getHost());
    }

    public S3Client createAmazonS3(URI uri, Map<String, ?> env) {
        Properties props = this.getProperties(uri, env);
        this.validateProperties(props);
        return this.getS3Client(uri, props);
    }

    protected S3ClientFactory getS3Factory(Properties props) {
        return new OmeroAmazonS3ClientFactory();
    }

    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
    }

    public boolean exists(S3Path path) {
        return true;
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (options.isEmpty() || options.contains(StandardOpenOption.READ)) {
            if (options.contains(StandardOpenOption.WRITE)) {
                throw new UnsupportedOperationException("Can't read and write one on channel");
            }
            return new OmeroS3ReadOnlySeekableByteChannel(s3Path, options);
        }
        return new S3SeekableByteChannel(s3Path, options, false);
    }

    private S3Path toS3Path(Path path) {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object)S3Path.class.getName());
        return (S3Path)path;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        S3Path s3path = (S3Path)path;
        S3BasicFileAttributes attrs = new S3BasicFileAttributes(s3path.getKey(), null, 0L, true, false);
        return (A)((BasicFileAttributes)type.cast(attrs));
    }
}

