/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.v2.Array;
import dev.zarr.zarrjava.v2.Group;
import dev.zarr.zarrjava.v2.codec.CodecRegistry;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface Node
extends dev.zarr.zarrjava.core.Node {
    public static ObjectMapper makeObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerSubtypes(CodecRegistry.getNamedTypes());
        return objectMapper;
    }

    public static ObjectWriter makeObjectWriter() {
        return Node.makeObjectMapper().writerWithDefaultPrettyPrinter();
    }

    public static Node open(StoreHandle storeHandle) throws IOException, ZarrException {
        boolean isGroup = storeHandle.resolve(".zgroup").exists();
        boolean isArray = storeHandle.resolve(".zarray").exists();
        if (isGroup && isArray) {
            throw new ZarrException("Store handle '" + storeHandle + "' contains both a " + ".zgroup" + " and a " + ".zarray" + " file.");
        }
        if (isGroup) {
            return Group.open(storeHandle);
        }
        if (isArray) {
            try {
                return Array.open(storeHandle);
            }
            catch (IOException e) {
                throw new ZarrException("Failed to read array metadata for store handle '" + storeHandle + "'.", e);
            }
        }
        throw new NoSuchFileException("Store handle '" + storeHandle + "' does not contain a " + ".zgroup" + " or a " + ".zarray" + " file.");
    }

    public static Node open(Path path) throws IOException, ZarrException {
        return Node.open(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Node open(String path) throws IOException, ZarrException {
        return Node.open(Paths.get(path, new String[0]));
    }
}

