/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import IceInternal.RouterInfo;
import java.util.HashMap;

public final class RouterManager {
    private HashMap<RouterPrx, RouterInfo> _table = new HashMap();

    RouterManager() {
    }

    synchronized void destroy() {
        for (RouterInfo info : this._table.values()) {
            info.destroy();
        }
        this._table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterInfo get(RouterPrx rtr) {
        if (rtr == null) {
            return null;
        }
        RouterPrx router = RouterPrxHelper.uncheckedCast(rtr.ice_router(null));
        RouterManager routerManager = this;
        synchronized (routerManager) {
            RouterInfo info = this._table.get(router);
            if (info == null) {
                info = new RouterInfo(router);
                this._table.put(router, info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterInfo erase(RouterPrx rtr) {
        RouterInfo info = null;
        if (rtr != null) {
            RouterPrx router = RouterPrxHelper.uncheckedCast(rtr.ice_router(null));
            RouterManager routerManager = this;
            synchronized (routerManager) {
                info = this._table.remove(router);
            }
        }
        return info;
    }
}

