/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Product
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 2824226005990582538L;
    private long n = 0L;
    private double value = Double.NaN;

    public void increment(double d) {
        this.value = this.n == 0L ? d : (this.value *= d);
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double evaluate(double[] values, int begin, int length) {
        double product = Double.NaN;
        if (this.test(values, begin, length)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= values[i];
            }
        }
        return product;
    }
}

