/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;

public abstract class HardWiredInterceptor
implements MethodInterceptor {
    private static final String SF = "ome.hard-wired.service-factory";
    private static final String PR = "ome.hard-wired.principal";
    private static final String RS = "ome.hard-wired.reusedSession";

    public static void configure(List<HardWiredInterceptor> hwi, OmeroContext ctx) {
        for (HardWiredInterceptor interceptor : hwi) {
            interceptor.selfConfigure(ctx);
        }
    }

    public String getName() {
        return null;
    }

    public void selfConfigure(OmeroContext context) {
        String name = this.getName();
        if (name != null) {
            context.applyBeanPropertyValues((Object)this, this.getName());
        }
    }

    public static List<HardWiredInterceptor> parse(String[] classNames) {
        ArrayList<HardWiredInterceptor> cptors = new ArrayList<HardWiredInterceptor>();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Class<?> klass = Class.forName(classNames[i]);
                cptors.add((HardWiredInterceptor)klass.newInstance());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate hard-wired interceptors:" + classNames[i], e);
            }
        }
        return Collections.unmodifiableList(cptors);
    }

    public static void initializeUserAttributes(MethodInvocation mi, ServiceFactory sf, Principal pr, AtomicBoolean reusedSession) {
        ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)mi;
        Map attrs = rmi.getUserAttributes();
        attrs.put(SF, sf);
        attrs.put(PR, pr);
        attrs.put(RS, reusedSession);
    }

    protected ServiceFactory getServiceFactory(MethodInvocation mi) {
        ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)mi;
        return (ServiceFactory)rmi.getUserAttribute(SF);
    }

    protected Principal getPrincipal(MethodInvocation mi) {
        ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)mi;
        return (Principal)rmi.getUserAttribute(PR);
    }

    protected boolean hasPassword(MethodInvocation mi) {
        ReflectiveMethodInvocation rmi = (ReflectiveMethodInvocation)mi;
        AtomicBoolean reusedSession = (AtomicBoolean)rmi.getUserAttribute(RS);
        return reusedSession == null ? true : !reusedSession.get();
    }
}

