/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.annotations.NotNull;
import ome.annotations.RolesAllowed;
import ome.annotations.Validate;
import ome.api.IContainer;
import ome.api.IMetadata;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.logic.AbstractLevel2Service;
import ome.model.IAnnotated;
import ome.model.ILink;
import ome.model.IObject;
import ome.model.acquisition.Arc;
import ome.model.acquisition.Filament;
import ome.model.acquisition.Instrument;
import ome.model.acquisition.Laser;
import ome.model.acquisition.LightEmittingDiode;
import ome.model.acquisition.LightSettings;
import ome.model.acquisition.LightSource;
import ome.model.annotations.Annotation;
import ome.model.annotations.FileAnnotation;
import ome.model.annotations.ImageAnnotationLink;
import ome.model.annotations.TagAnnotation;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.OriginalFile;
import ome.model.fs.Fileset;
import ome.model.screen.Plate;
import ome.model.screen.PlateAcquisition;
import ome.model.screen.Screen;
import ome.model.screen.Well;
import ome.parameters.Parameters;
import ome.services.query.PojosFindAnnotationsQueryDefinition;
import ome.services.query.Query;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.transaction.annotation.Transactional;

public class MetadataImpl
extends AbstractLevel2Service
implements IMetadata {
    private final String LOAD_ORIGINAL_FILE = "select p from OriginalFile as p left outer join fetch p.hasher where p.id = :id";
    private static final String LOAD_FILESET_OF_IMAGE = "SELECT id, fileset.id FROM Image WHERE fileset IS NOT NULL AND id IN (:ids)";
    private static final String LOAD_IMPORT_LOGS = "SELECT fjl.parent.id, o FROM UploadJob u, FilesetJobLink fjl, JobOriginalFileLink jol, OriginalFile o WHERE fjl.parent.id IN (:ids) AND fjl.child = jol.parent AND jol.child.id = o.id AND fjl.child = u AND o.mimetype = 'application/omero-log-file'";
    private final String FILE_TYPE = "ome.model.annotations.FileAnnotation";
    private final String TAG_TYPE = "ome.model.annotations.TagAnnotation";
    private IContainer iContainer;

    private StringBuilder createLightQuery(LightSource src, boolean idClause) {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (src instanceof Laser) {
            sb.append("select l from Laser as l ");
            sb.append("left outer join fetch l.type ");
            sb.append("left outer join fetch l.laserMedium ");
            sb.append("left outer join fetch l.pulse as pulse ");
            if (idClause) {
                sb.append("where l.id = :id");
            } else {
                sb.append("where l.instrument.id = :instrumentId");
            }
        } else if (src instanceof Filament) {
            sb.append("select l from Filament as l ");
            sb.append("left outer join fetch l.type ");
            if (idClause) {
                sb.append("where l.id = :id");
            } else {
                sb.append("where l.instrument.id = :instrumentId");
            }
        } else if (src instanceof Arc) {
            sb.append("select l from Arc as l ");
            sb.append("left outer join fetch l.type ");
            if (idClause) {
                sb.append("where l.id = :id");
            } else {
                sb.append("where l.instrument.id = :instrumentId");
            }
        } else {
            sb = null;
        }
        return sb;
    }

    private List<IObject> getAnnotation(@NotNull Class type, Set<String> include, Set<String> exclude, Class rootType, Set<Long> rootNodeIds, Parameters options) {
        StringBuilder sb = new StringBuilder();
        if (rootType == null) {
            sb.append("select ann from Annotation as ann ");
        } else if (Image.class.getName().equals(rootType.getName())) {
            sb.append("select l from ImageAnnotationLink as l ");
        } else if (Dataset.class.getName().equals(rootType.getName())) {
            sb.append("select l from DatasetAnnotationLink as l ");
        } else if (Project.class.getName().equals(rootType.getName())) {
            sb.append("select l from ProjectAnnotationLink as l ");
        } else if (Screen.class.getName().equals(rootType.getName())) {
            sb.append("select l from ScreenAnnotationLink as l ");
        } else if (Plate.class.getName().equals(rootType.getName())) {
            sb.append("select l from PlateAnnotationLink as l ");
        } else if (PlateAcquisition.class.getName().equals(rootType.getName())) {
            sb.append("select l from PlateAcquisitionAnnotationLink as l ");
        } else if (Well.class.getName().equals(rootType.getName())) {
            sb.append("select l from WellAnnotationLink as l ");
        } else if (Fileset.class.getName().equals(rootType.getName())) {
            sb.append("select l from FilesetAnnotationLink as l ");
        }
        if (rootType != null) {
            sb.append("left outer join fetch l.parent ");
            sb.append("left outer join fetch l.child as ann ");
        }
        sb.append("left outer join fetch ann.details.creationEvent ");
        sb.append("left outer join fetch ann.details.owner ");
        sb.append("where ann member of " + type.getName());
        Parameters param = new Parameters();
        Parameters po = new Parameters(options);
        if (po.getExperimenter() != null) {
            sb.append(" and ann.details.owner.id = :userId");
            param.addLong("userId", po.getExperimenter());
        }
        if (include != null && include.size() > 0) {
            sb.append(" and ann.ns is not null and ann.ns in (:include)");
            param.addSet("include", include);
        }
        if (exclude != null && exclude.size() > 0) {
            sb.append(" and (ann.ns is null or ann.ns not in (:exclude))");
            param.addSet("exclude", exclude);
        }
        if (rootNodeIds != null && rootNodeIds.size() > 0) {
            sb.append(" and l.parent.id in (:rootNodeIds)");
            param.addSet("rootNodeIds", rootNodeIds);
        }
        return this.iQuery.findAllByQuery(sb.toString(), param);
    }

    private List<IObject> getAnnotation(@NotNull Class type, Set<String> include, Set<String> exclude, Parameters options) {
        return this.getAnnotation(type, include, exclude, null, null, options);
    }

    public final Class<? extends ServiceInterface> getServiceInterface() {
        return IMetadata.class;
    }

    public final void setIContainer(IContainer iContainer) {
        this.getBeanHelper().throwIfAlreadySet(this.iContainer, iContainer);
        this.iContainer = iContainer;
    }

    private long countTaggedObjects(long tagID) {
        Parameters param = new Parameters();
        param.addId(Long.valueOf(tagID));
        StringBuilder sb = new StringBuilder();
        sb.append("select img from Image as img ");
        sb.append("left outer join fetch img.annotationLinks ail ");
        sb.append("where ail.child.id = :id");
        List l = this.iQuery.findAllByQuery(sb.toString(), param);
        long n = 0L;
        if (l != null) {
            n += (long)l.size();
        }
        sb = new StringBuilder();
        sb.append("select d from Dataset as d ");
        sb.append("left outer join fetch d.annotationLinks ail ");
        sb.append("where ail.child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null) {
            n += (long)l.size();
        }
        sb = new StringBuilder();
        sb.append("select p from Project as p ");
        sb.append("left outer join fetch p.annotationLinks ail ");
        sb.append("where ail.child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null) {
            n += (long)l.size();
        }
        sb = new StringBuilder();
        sb.append("select p from Screen as p ");
        sb.append("left outer join fetch p.annotationLinks ail ");
        sb.append("where ail.child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null) {
            n += (long)l.size();
        }
        sb = new StringBuilder();
        sb.append("select p from Plate as p ");
        sb.append("left outer join fetch p.annotationLinks ail ");
        sb.append("where ail.child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null) {
            n += (long)l.size();
        }
        return n;
    }

    private Set<IObject> loadObjects(long id, Parameters options) {
        Set p;
        Parameters po;
        Iterator i;
        HashSet<Long> ids;
        Parameters param = new Parameters();
        param.addId(Long.valueOf(id));
        StringBuilder sb = new StringBuilder();
        HashSet<IObject> result = new HashSet<IObject>();
        sb.append("select img from Image as img ");
        sb.append("left outer join fetch img.annotationLinksCountPerOwner img_a_c ");
        sb.append("left outer join fetch img.annotationLinks ail ");
        sb.append("left outer join fetch ail.child child ");
        sb.append("left outer join fetch ail.parent parent ");
        sb.append("left outer join fetch child.details.owner ownerChild ");
        sb.append("left outer join fetch parent.details.owner ownerParent ");
        sb.append("left outer join fetch img.pixels as pix ");
        sb.append("left outer join fetch pix.pixelsType as pt ");
        sb.append("where child.id = :id");
        List l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null) {
            result.addAll(l);
        }
        sb = new StringBuilder();
        sb.append("select d from Dataset as d ");
        sb.append("left outer join fetch d.annotationLinksCountPerOwner d_a_c ");
        sb.append("left outer join fetch d.annotationLinks ail ");
        sb.append("left outer join fetch ail.child child ");
        sb.append("left outer join fetch ail.parent parent ");
        sb.append("left outer join fetch child.details.owner ownerChild ");
        sb.append("left outer join fetch parent.details.owner ownerParent ");
        sb.append("where child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null) {
            result.addAll(l);
        }
        sb = new StringBuilder();
        sb.append("select pl from Plate as pl ");
        sb.append("left outer join fetch pl.annotationLinksCountPerOwner pl_a_c ");
        sb.append("left outer join fetch pl.annotationLinks ail ");
        sb.append("left outer join fetch ail.child child ");
        sb.append("left outer join fetch ail.parent parent ");
        sb.append("where child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null) {
            result.addAll(l);
        }
        sb = new StringBuilder();
        sb.append("select p from Project as p ");
        sb.append("left outer join fetch p.annotationLinksCountPerOwner p_a_c ");
        sb.append("left outer join fetch p.annotationLinks ail ");
        sb.append("left outer join fetch ail.child child ");
        sb.append("left outer join fetch ail.parent parent ");
        sb.append("left outer join fetch child.details.owner ownerChild ");
        sb.append("left outer join fetch parent.details.owner ownerParent ");
        sb.append("where child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null && l.size() > 0) {
            ids = new HashSet<Long>();
            i = l.iterator();
            while (i.hasNext()) {
                ids.add(((IObject)i.next()).getId());
            }
            po = new Parameters(options);
            po.noLeaves();
            po.noOrphan();
            p = this.iContainer.loadContainerHierarchy(Project.class, ids, po);
            result.addAll(p);
        }
        sb = new StringBuilder();
        sb.append("select s from Screen as s ");
        sb.append("left outer join fetch s.annotationLinksCountPerOwner s_a_c ");
        sb.append("left outer join fetch s.annotationLinks ail ");
        sb.append("left outer join fetch ail.child child ");
        sb.append("left outer join fetch ail.parent parent ");
        sb.append("left outer join fetch child.details.owner ownerChild ");
        sb.append("left outer join fetch parent.details.owner ownerParent ");
        sb.append("where child.id = :id");
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null && l.size() > 0) {
            ids = new HashSet();
            i = l.iterator();
            while (i.hasNext()) {
                ids.add(((IObject)i.next()).getId());
            }
            po = new Parameters(options);
            po.noLeaves();
            po.noOrphan();
            p = this.iContainer.loadContainerHierarchy(Screen.class, ids, po);
            result.addAll(p);
        }
        return result;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Instrument loadInstrument(long id) {
        StringBuilder sb = new StringBuilder();
        sb.append("select inst from Instrument as inst ");
        sb.append("left outer join fetch inst.microscope as m ");
        sb.append("left outer join fetch m.type ");
        sb.append("left outer join fetch inst.objective as o ");
        sb.append("left outer join fetch o.immersion ");
        sb.append("left outer join fetch o.correction ");
        sb.append("left outer join fetch inst.detector as d ");
        sb.append("left outer join fetch d.type ");
        sb.append("left outer join fetch inst.filter as f ");
        sb.append("left outer join fetch f.type ");
        sb.append("left outer join fetch f.transmittanceRange as trans ");
        sb.append("left outer join fetch inst.filterSet as fs ");
        sb.append("left outer join fetch fs.dichroic as dichroic ");
        sb.append("left outer join fetch inst.dichroic as di ");
        sb.append("left outer join fetch inst.otf as otf ");
        sb.append("left outer join fetch otf.pixelsType as type ");
        sb.append("left outer join fetch otf.objective as obj ");
        sb.append("left outer join fetch obj.immersion ");
        sb.append("left outer join fetch obj.correction ");
        sb.append("left outer join fetch otf.filterSet ");
        sb.append("left outer join fetch inst.lightSource as ls ");
        sb.append("where inst.id = :id ");
        Parameters params = new Parameters();
        params.addId(Long.valueOf(id));
        Instrument value = (Instrument)this.iQuery.findByQuery(sb.toString(), params);
        if (value == null) {
            return null;
        }
        Iterator i = value.iterateLightSource();
        if (i != null) {
            params = new Parameters();
            params.addLong("instrumentId", Long.valueOf(id));
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<LightSource> list = new ArrayList<LightSource>();
            while (i.hasNext()) {
                LightSource ls = (LightSource)i.next();
                if (ls instanceof LightEmittingDiode) {
                    list.add(ls);
                    continue;
                }
                String name = ls.getClass().getName();
                if (names.contains(name)) continue;
                names.add(name);
                StringBuilder builder = this.createLightQuery(ls, false);
                if (builder == null) continue;
                list.addAll(this.iQuery.findAllByQuery(builder.toString(), params));
            }
            value.clearLightSource();
            Iterator j = list.iterator();
            while (j.hasNext()) {
                value.addLightSource((LightSource)j.next());
            }
        }
        return value;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set loadChannelAcquisitionData(@NotNull @Validate(value={Long.class}) Set<Long> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append("select channel from LogicalChannel as channel ");
        sb.append("left outer join fetch channel.mode as mode ");
        sb.append("left outer join fetch channel.illumination as illumination ");
        sb.append("left outer join fetch channel.contrastMethod as cm ");
        sb.append("left outer join fetch channel.detectorSettings as ds ");
        sb.append("left outer join fetch channel.lightSourceSettings as lss ");
        sb.append("left outer join fetch lss.microbeamManipulation ");
        sb.append("left outer join fetch channel.otf as otf ");
        sb.append("left outer join fetch otf.pixelsType ");
        sb.append("left outer join fetch otf.objective as objective ");
        sb.append("left outer join fetch objective.immersion ");
        sb.append("left outer join fetch objective.correction ");
        sb.append("left outer join fetch otf.filterSet as otffilter ");
        sb.append("left outer join fetch otffilter.dichroic as otfdichroic ");
        sb.append("left outer join fetch channel.filterSet as filter ");
        sb.append("left outer join fetch filter.dichroic as dichroic ");
        sb.append("left outer join fetch filter.emissionFilterLink as efl ");
        sb.append("left outer join fetch efl.child as ef ");
        sb.append("left outer join fetch ef.transmittanceRange as efTrans ");
        sb.append("left outer join fetch ef.type as type1 ");
        sb.append("left outer join fetch filter.excitationFilterLink as exfl ");
        sb.append("left outer join fetch exfl.child as exf ");
        sb.append("left outer join fetch exf.transmittanceRange as exfTrans ");
        sb.append("left outer join fetch exf.type as type2 ");
        sb.append("left outer join fetch channel.lightPath as lp ");
        sb.append("left outer join fetch lp.dichroic as dichroic ");
        sb.append("left outer join fetch lp.emissionFilterLink as efLpl ");
        sb.append("left outer join fetch efLpl.child as efLp ");
        sb.append("left outer join fetch efLp.transmittanceRange as efLpTrans ");
        sb.append("left outer join fetch efLp.type as type3 ");
        sb.append("left outer join fetch lp.excitationFilterLink as exfLpl ");
        sb.append("left outer join fetch exfLpl.child as exfLp ");
        sb.append("left outer join fetch exfLp.transmittanceRange as exfLpTrans ");
        sb.append("left outer join fetch exfLp.type as type4 ");
        sb.append("left outer join fetch ds.detector as detector ");
        sb.append("left outer join fetch detector.type ");
        sb.append("left outer join fetch ds.binning as binning ");
        sb.append("left outer join fetch lss.lightSource as light ");
        sb.append("left outer join fetch light.instrument as instrument ");
        sb.append("where channel.id in (:ids)");
        List list = this.iQuery.findAllByQuery(sb.toString(), new Parameters().addIds(ids));
        for (LogicalChannel channel : list) {
            LightSource src;
            LightSettings light = channel.getLightSourceSettings();
            if (light == null || (src = light.getLightSource()) instanceof LightEmittingDiode || (sb = this.createLightQuery(src, true)) == null) continue;
            Parameters params = new Parameters();
            params.addId(src.getId());
            src = (LightSource)this.iQuery.findByQuery(sb.toString(), params);
            if (src instanceof Laser) {
                Laser laser = (Laser)src;
                LightSource pump = laser.getPump();
                if (pump == null || pump instanceof LightEmittingDiode) continue;
                params = new Parameters();
                params.addId(pump.getId());
                sb = this.createLightQuery(pump, true);
                if (sb != null) {
                    laser.setPump((LightSource)this.iQuery.findByQuery(sb.toString(), params));
                }
                light.setLightSource((LightSource)laser);
                continue;
            }
            light.setLightSource(src);
        }
        return new HashSet(list);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public <T extends IObject, A extends Annotation> Map<Long, Set<A>> loadAnnotations(Class<T> rootNodeType, Set<Long> rootNodeIds, Set<String> annotationTypes, Set<Long> annotatorIds, Parameters options) {
        HashMap<Long, Set<A>> map = new HashMap<Long, Set<A>>();
        if (rootNodeIds.size() == 0) {
            return map;
        }
        if (!IAnnotated.class.isAssignableFrom(rootNodeType)) {
            throw new ApiUsageException("Class parameter for loadAnnotation() must be a subclass of ome.model.IAnnotated");
        }
        Parameters po = new Parameters();
        Query q = this.getQueryFactory().lookup(PojosFindAnnotationsQueryDefinition.class.getName(), po.addIds(rootNodeIds).addClass(rootNodeType).addSet("annotatorIds", annotatorIds));
        List l = (List)this.iQuery.execute(q);
        this.iQuery.clear();
        for (IAnnotated annotated : new HashSet(l)) {
            Long id = annotated.getId();
            HashSet set = (HashSet)map.get(id);
            if (set == null) {
                set = new HashSet();
                map.put(id, set);
            }
            List list = annotated.linkedAnnotationList();
            ArrayList<Annotation> supported = new ArrayList<Annotation>();
            if (list != null) {
                if (annotationTypes != null && annotationTypes.size() > 0) {
                    for (Annotation object : list) {
                        if (!annotationTypes.contains(object.getClass().getName())) continue;
                        supported.add(object);
                    }
                } else {
                    supported.addAll(list);
                }
            } else {
                supported.addAll(list);
            }
            for (Annotation object : supported) {
                FileAnnotation fa;
                if (!(object instanceof FileAnnotation) || (fa = (FileAnnotation)object).getFile() == null) continue;
                OriginalFile of = (OriginalFile)this.iQuery.findByQuery("select p from OriginalFile as p left outer join fetch p.hasher where p.id = :id", new Parameters().addId(fa.getFile().getId()));
                fa.setFile(of);
            }
            set.addAll(supported);
        }
        return map;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public <A extends Annotation> Set<A> loadSpecifiedAnnotations(@NotNull Class type, Set<String> include, Set<String> exclude, Parameters options) {
        Iterator<IObject> i;
        List<IObject> list = this.getAnnotation(type, include, exclude, options);
        if ("ome.model.annotations.FileAnnotation".equals(type.getName()) && list != null) {
            i = list.iterator();
            ArrayList<FileAnnotation> toRemove = new ArrayList<FileAnnotation>();
            while (i.hasNext()) {
                FileAnnotation fa = (FileAnnotation)i.next();
                if (fa.getFile() != null) {
                    OriginalFile of = (OriginalFile)this.iQuery.findByQuery("select p from OriginalFile as p left outer join fetch p.hasher where p.id = :id", new Parameters().addId(fa.getFile().getId()));
                    fa.setFile(of);
                    continue;
                }
                toRemove.add(fa);
            }
            if (toRemove.size() > 0) {
                list.removeAll(toRemove);
            }
        }
        if (list == null) {
            return new HashSet();
        }
        HashSet<Annotation> set = new HashSet<Annotation>(list.size());
        i = list.iterator();
        while (i.hasNext()) {
            set.add((Annotation)i.next());
        }
        return set;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Long countSpecifiedAnnotations(@NotNull Class type, Set<String> include, Set<String> exclude, Parameters options) {
        List<IObject> list = this.getAnnotation(type, include, exclude, options);
        if (list != null) {
            return new Long(list.size());
        }
        return -1L;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public <A extends Annotation> Set<A> loadAnnotation(@NotNull @Validate(value={Long.class}) Set<Long> annotationIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ann from Annotation as ann ");
        sb.append("left outer join fetch ann.details.creationEvent ");
        sb.append("left outer join fetch ann.details.owner ");
        sb.append("where ann.id in (:ids)");
        List list = this.iQuery.findAllByQuery(sb.toString(), new Parameters().addIds(annotationIds));
        if (list == null) {
            return new HashSet();
        }
        for (Annotation object : list) {
            FileAnnotation fa;
            if (!(object instanceof FileAnnotation) || (fa = (FileAnnotation)object).getFile() == null) continue;
            IObject of = this.iQuery.findByQuery("select p from OriginalFile as p left outer join fetch p.hasher where p.id = :id", new Parameters().addId(fa.getFile().getId()));
            fa.setFile((OriginalFile)of);
        }
        return new HashSet(list);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Map<Long, Set<IObject>> loadTagContent(@NotNull @Validate(value={Long.class}) Set<Long> tagIds, Parameters options) {
        HashMap<Long, Set<IObject>> m = new HashMap<Long, Set<IObject>>();
        for (Long id : tagIds) {
            m.put(id, this.loadObjects(id, options));
        }
        return m;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set<IObject> loadTagSets(Parameters options) {
        List l;
        HashSet<IObject> result = new HashSet<IObject>();
        Parameters po = new Parameters(options);
        Parameters param = new Parameters();
        StringBuilder sb = new StringBuilder();
        param.addString("include", "openmicroscopy.org/omero/insight/tagset");
        sb.append("select tag from TagAnnotation as tag ");
        sb.append("left outer join fetch tag.annotationLinks as l ");
        sb.append("left outer join fetch l.parent as parent ");
        sb.append("left outer join fetch l.child as child ");
        sb.append("left outer join fetch child.details.owner as ownerChild ");
        sb.append("left outer join fetch parent.details.owner as ownerParent ");
        sb.append("left outer join fetch tag.details.owner as tagOwner ");
        sb.append("where tag.ns is not null and tag.ns = :include ");
        sb.append("and (l is null or child member of ome.model.annotations.TagAnnotation)");
        if (po.isExperimenter()) {
            sb.append(" and tagOwner.id = :userID");
            param.addLong("userID", po.getExperimenter());
        }
        if ((l = this.iQuery.findAllByQuery(sb.toString(), param)) != null) {
            result.addAll(l);
        }
        if (po.isOrphan()) {
            ArrayList<Long> children = new ArrayList<Long>();
            if (l != null) {
                for (TagAnnotation tag : l) {
                    if (tag.sizeOfAnnotationLinks() <= 0) continue;
                    List list = tag.linkedAnnotationList();
                    Iterator k = list.iterator();
                    while (k.hasNext()) {
                        Long id = ((IObject)k.next()).getId();
                        if (children.contains(id)) continue;
                        children.add(id);
                    }
                }
            }
            sb = new StringBuilder();
            param = new Parameters();
            param.addString("include", "openmicroscopy.org/omero/insight/tagset");
            sb.append("select ann from TagAnnotation as ann");
            sb.append(" where ((ann.ns is null) or (ann.ns is not null and ann.ns != :include)) ");
            if (children.size() > 0) {
                sb.append(" and ann.id not in (:ids)");
                param.addList("ids", children);
            }
            if (po.isExperimenter()) {
                sb.append(" and ann.details.owner.id = :userID");
                param.addLong("userID", po.getExperimenter());
            }
            if ((l = this.iQuery.findAllByQuery(sb.toString(), param)) != null) {
                result.addAll(l);
            }
        }
        return result;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Map getTaggedObjectsCount(@NotNull @Validate(value={Long.class}) Set<Long> tagIds, Parameters options) {
        HashMap<Long, Long> counts = new HashMap<Long, Long>();
        for (Long id : tagIds) {
            counts.put(id, this.countTaggedObjects(id));
        }
        return counts;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set<IObject> loadAnnotationsUsedNotOwned(@NotNull Class annotationType, long userID) {
        IObject o;
        HashSet<IObject> result = new HashSet<IObject>();
        String type = annotationType.getName();
        ArrayList<Long> ids = new ArrayList<Long>();
        Parameters param = new Parameters();
        param.addLong("userID", Long.valueOf(userID));
        StringBuffer sb = new StringBuffer();
        sb.append("select link from ImageAnnotationLink as link ");
        sb.append("left outer join fetch link.child child ");
        sb.append("left outer join fetch child.details.owner as co ");
        sb.append("left outer join fetch link.details.owner as lo ");
        sb.append("where co.id != :userID and lo.id = :userID and child member of " + type);
        List l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null && l.size() > 0) {
            for (ImageAnnotationLink link : l) {
                o = link.getChild();
                if (ids.contains(o.getId())) continue;
                result.add(o);
                ids.add(o.getId());
            }
        }
        sb = new StringBuffer();
        sb.append("select link from DatasetAnnotationLink as link ");
        sb.append("left outer join fetch link.child child ");
        sb.append("left outer join fetch child.details.owner as co ");
        sb.append("left outer join fetch link.details.owner as lo ");
        sb.append("where co.id != :userID and lo.id = :userID and child member of " + type);
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null && l.size() > 0) {
            for (ImageAnnotationLink link : l) {
                o = link.getChild();
                if (ids.contains(o.getId())) continue;
                result.add(o);
                ids.add(o.getId());
            }
        }
        sb = new StringBuffer();
        sb.append("select link from ProjectAnnotationLink as link ");
        sb.append("left outer join fetch link.child child ");
        sb.append("left outer join fetch child.details.owner as co ");
        sb.append("left outer join fetch link.details.owner as lo ");
        sb.append("where co.id != :userID and lo.id = :userID and child member of " + type);
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null && l.size() > 0) {
            for (ImageAnnotationLink link : l) {
                o = link.getChild();
                if (ids.contains(o.getId())) continue;
                result.add(o);
                ids.add(o.getId());
            }
        }
        sb = new StringBuffer();
        sb.append("select link from ScreenAnnotationLink as link ");
        sb.append("left outer join fetch link.child child ");
        sb.append("left outer join fetch child.details.owner as co ");
        sb.append("left outer join fetch link.details.owner as lo ");
        sb.append("where co.id != :userID and lo.id = :userID and child member of " + annotationType.getName());
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null && l.size() > 0) {
            for (ImageAnnotationLink link : l) {
                o = link.getChild();
                if (ids.contains(o.getId())) continue;
                result.add(o);
                ids.add(o.getId());
            }
        }
        sb = new StringBuffer();
        sb.append("select link from PlateAnnotationLink as link ");
        sb.append("left outer join fetch link.child child ");
        sb.append("left outer join fetch child.details.owner as co ");
        sb.append("left outer join fetch link.details.owner as lo ");
        sb.append("where co.id != :userID and lo.id = :userID and child member of " + annotationType.getName());
        l = this.iQuery.findAllByQuery(sb.toString(), param);
        if (l != null && l.size() > 0) {
            for (ImageAnnotationLink link : l) {
                o = link.getChild();
                if (ids.contains(o.getId())) continue;
                result.add(o);
                ids.add(o.getId());
            }
        }
        return result;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Long countAnnotationsUsedNotOwned(@NotNull Class annotationType, long userID) {
        Set<IObject> s = this.loadAnnotationsUsedNotOwned(annotationType, userID);
        if (s != null) {
            return new Long(s.size());
        }
        return -1L;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public <A extends Annotation> Map<Long, Set<A>> loadSpecifiedAnnotationsLinkedTo(@NotNull Class type, Set<String> include, Set<String> exclude, @NotNull Class rootNodeType, @NotNull @Validate(value={Long.class}) Set<Long> rootNodeIds, Parameters options) {
        List<IObject> list = this.getAnnotation(type, include, exclude, rootNodeType, rootNodeIds, options);
        HashMap<Long, Set<A>> map = new HashMap<Long, Set<A>>(rootNodeIds.size());
        if (list == null) {
            return map;
        }
        for (ILink iLink : list) {
            FileAnnotation fa;
            Long parentID = iLink.getParent().getId();
            HashSet<Annotation> set = (HashSet<Annotation>)map.get(parentID);
            if (set == null) {
                set = new HashSet<Annotation>();
                map.put(parentID, set);
            }
            Annotation ann = (Annotation)iLink.getChild();
            if ("ome.model.annotations.FileAnnotation".equals(type.getName()) && (fa = (FileAnnotation)ann).getFile() != null) {
                OriginalFile of = (OriginalFile)this.iQuery.findByQuery("select p from OriginalFile as p left outer join fetch p.hasher where p.id = :id", new Parameters().addId(fa.getFile().getId()));
                fa.setFile(of);
            }
            set.add(ann);
        }
        return map;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Map<Long, Set<IObject>> loadLogFiles(@NotNull Class<? extends IObject> rootNodeType, @Validate(value={Long.class}) Set<Long> ids) {
        Set filesetIds;
        HashMultimap rootIdByFileset;
        if (Image.class.isAssignableFrom(rootNodeType)) {
            rootIdByFileset = HashMultimap.create();
            if (CollectionUtils.isNotEmpty(ids)) {
                for (Object[] result : this.iQuery.projection(LOAD_FILESET_OF_IMAGE, new Parameters().addIds((Collection)ids))) {
                    Long imageId = (Long)result[0];
                    Long filesetId = (Long)result[1];
                    rootIdByFileset.put((Object)filesetId, (Object)imageId);
                }
            }
        } else {
            if (!Fileset.class.isAssignableFrom(rootNodeType)) {
                throw new ApiUsageException("can load log files only by Fileset or Image");
            }
            rootIdByFileset = null;
        }
        HashMultimap map = HashMultimap.create();
        Set set = filesetIds = rootIdByFileset == null ? ids : rootIdByFileset.keySet();
        if (CollectionUtils.isNotEmpty((Collection)filesetIds)) {
            for (Object[] result : this.iQuery.projection(LOAD_IMPORT_LOGS, new Parameters().addIds((Collection)filesetIds))) {
                Long filesetId = (Long)result[0];
                OriginalFile logFile = (OriginalFile)result[1];
                Set mapKeys = rootIdByFileset == null ? Collections.singleton(filesetId) : rootIdByFileset.get((Object)filesetId);
                for (Long mapKey : mapKeys) {
                    map.put((Object)mapKey, (Object)logFile);
                }
            }
        }
        return new HashMap<Long, Set<IObject>>(Multimaps.asMap((SetMultimap)map));
    }
}

