/*
 * Decompiled with CFR 0.152.
 */
package ome.security.policy;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.security.policy.Policy;
import ome.security.policy.PolicyService;
import ome.tools.spring.OnContextRefreshedEventListener;
import ome.util.Utils;
import org.springframework.context.event.ContextRefreshedEvent;

public class DefaultPolicyService
extends OnContextRefreshedEventListener
implements PolicyService {
    private final Set<Class<IObject>> types = new HashSet<Class<IObject>>();
    private final ListMultimap<String, Policy> policies = ArrayListMultimap.create();

    @Override
    public void handleContextRefreshedEvent(ContextRefreshedEvent event) {
        for (Policy policy : event.getApplicationContext().getBeansOfType(Policy.class).values()) {
            this.policies.put((Object)policy.getName(), (Object)policy);
            this.types.addAll(policy.getTypes());
        }
    }

    @Override
    public boolean isRestricted(String name, IObject obj) {
        if (name == null) {
            return false;
        }
        for (Policy check : this.policies.get((Object)name)) {
            if (!check.isRestricted(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkRestriction(String name, IObject obj) {
        for (Policy check : this.policies.get((Object)name)) {
            check.checkRestriction(obj);
        }
    }

    @Override
    public Set<String> listAllRestrictions() {
        return this.policies.keySet();
    }

    @Override
    public Set<String> listActiveRestrictions(IObject obj) {
        if (this.filterObject(obj)) {
            return Collections.emptySet();
        }
        HashSet<String> rv = new HashSet<String>();
        for (Map.Entry entry : this.policies.entries()) {
            if (!((Policy)entry.getValue()).isRestricted(obj)) continue;
            rv.add((String)entry.getKey());
        }
        return rv;
    }

    protected boolean filterObject(IObject obj) {
        if (obj == null) {
            return true;
        }
        return !this.types.contains(Utils.trueClass(obj.getClass()));
    }
}

