/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions.events;

import java.util.ArrayList;
import java.util.List;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.util.messages.InternalMessage;

public class ChangeSecurityContextEvent
extends InternalMessage {
    final List<String> cancellations = new ArrayList<String>();
    private final String sessionUuid;
    private final IObject previous;
    private final IObject next;
    private static final long serialVersionUID = 1L;

    public ChangeSecurityContextEvent(Object source, String sessionUuid, IObject previous, IObject next) {
        super(source);
        this.sessionUuid = sessionUuid;
        this.previous = previous;
        this.next = next;
    }

    public synchronized String getUuid() {
        return this.sessionUuid;
    }

    public synchronized void cancel(String message) {
        this.cancellations.add(message);
    }

    public synchronized void throwIfCancelled() {
        if (this.cancellations.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("SecurityContext change cancelled:\n");
            for (String str : this.cancellations) {
                sb.append(str);
                sb.append("\n");
            }
            throw new SecurityViolation(sb.toString());
        }
    }
}

