/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions.state;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.event.CacheEventListener;
import ome.conditions.ApiUsageException;
import ome.conditions.RemovedSessionException;
import ome.conditions.SessionTimeoutException;
import ome.services.messages.DestroySessionMessage;
import ome.services.sessions.SessionCallback;
import ome.services.sessions.SessionContext;
import ome.services.sessions.events.UserGroupUpdateEvent;
import ome.services.sessions.state.CacheFactory;
import ome.system.OmeroContext;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class SessionCache
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SessionCache.class);
    private final Map<String, Data> sessions;
    private final AtomicReference<State> state = new AtomicReference<State>(new State());
    private long forceUpdateInterval = 1800000L;
    private CacheManager ehmanager;
    private final Map<String, Set<SessionCallback>> sessionCallbackMap;
    private final AtomicReference<StaleCacheListener> staleCacheListener = new AtomicReference();
    private final AtomicBoolean active = new AtomicBoolean();
    private OmeroContext context;

    public SessionCache() {
        MapMaker mapMaker = new MapMaker();
        this.sessions = mapMaker.makeMap();
        this.sessionCallbackMap = mapMaker.makeMap();
    }

    public void setCacheManager(CacheManager manager) {
        this.ehmanager = manager;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.context = (OmeroContext)ctx;
    }

    public void setUpdateInterval(long milliseconds) {
        this.forceUpdateInterval = milliseconds;
    }

    public void setStaleCacheListener(StaleCacheListener staleCacheListener) {
        this.staleCacheListener.set(staleCacheListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSessionCallback(String session, SessionCallback cb) {
        Map<String, Set<SessionCallback>> map = this.sessionCallbackMap;
        synchronized (map) {
            Set<SessionCallback> set = this.sessionCallbackMap.get(session);
            if (set == null) {
                set = new HashSet<SessionCallback>();
                this.sessionCallbackMap.put(session, set);
            }
            return set.add(cb);
        }
    }

    public boolean removeSessionCallback(String session, SessionCallback cb) {
        return null != this.sessionCallbackMap.remove(session);
    }

    public void putSession(String uuid, SessionContext sessionContext) {
        Data data = new Data(sessionContext);
        this.sessions.put(uuid, data);
        Slf4JStopWatch sw = new Slf4JStopWatch("omero.session");
        this.addSessionCallback(uuid, new SessionCallback.SimpleCloseCallback((StopWatch)sw){
            final /* synthetic */ StopWatch val$sw;
            {
                this.val$sw = stopWatch;
            }

            @Override
            public void close() {
                this.val$sw.stop();
            }
        });
    }

    public void refresh(String uuid, SessionContext replacement) {
        Data data = this.getDataNullOrThrowOnTimeout(uuid, true);
        this.refresh(uuid, data, replacement);
    }

    private void refresh(String uuid, Data data, SessionContext replacement) {
        Data fresh = new Data(data, replacement, false);
        this.sessions.put(uuid, fresh);
    }

    public SessionContext getSessionContext(String uuid) {
        return this.getSessionContext(uuid, false);
    }

    public SessionContext getSessionContext(String uuid, boolean quietly) {
        if (uuid == null) {
            throw new ApiUsageException("Uuid cannot be null.");
        }
        Data data = this.getDataNullOrThrowOnTimeout(uuid, true);
        if (!quietly) {
            this.sessions.put(uuid, new Data(data));
        }
        return data.sessionContext;
    }

    public Map<String, Object> getSessionData(String uuid, boolean quietly) {
        if (uuid == null) {
            throw new ApiUsageException("Uuid cannot be null.");
        }
        Data data = this.getDataNullOrThrowOnTimeout(uuid, true);
        if (!quietly) {
            this.sessions.put(uuid, new Data(data));
        }
        return new ImmutableMap.Builder().put((Object)"class", (Object)this.getClass().getName()).put((Object)"sessionContext", (Object)data.sessionContext).put((Object)"hitCount", (Object)data.hitCount).put((Object)"lastAccessTime", (Object)data.lastAccessTime).build();
    }

    private Data getDataNullOrThrowOnTimeout(String uuid, boolean strict) {
        Data data = this.sessions.get(uuid);
        if (data == null) {
            if (strict) {
                throw new RemovedSessionException("No context for " + uuid);
            }
            return null;
        }
        long lastAccess = data.lastAccessTime;
        long hits = data.hitCount;
        SessionContext ctx = data.sessionContext;
        long now = System.currentTimeMillis();
        long start = ctx.getSession().getStarted().getTime();
        long timeToIdle = ctx.getSession().getTimeToIdle();
        long timeToLive = ctx.getSession().getTimeToLive();
        if (lastAccess == 0L) {
            lastAccess = start;
        }
        long alive = now - start;
        long idle = now - lastAccess;
        if (0L < timeToLive && timeToLive < alive) {
            String reason = this.reason("timeToLive", lastAccess, hits, start, timeToLive, alive - timeToLive);
            if (strict) {
                throw new SessionTimeoutException(reason, (Object)ctx);
            }
            return null;
        }
        if (0L < timeToIdle && timeToIdle < idle) {
            String reason = this.reason("timeToIdle", lastAccess, hits, start, timeToIdle, idle - timeToIdle);
            if (strict) {
                throw new SessionTimeoutException(reason, (Object)ctx);
            }
            return null;
        }
        return data;
    }

    private String reason(String why, long lastAccess, long hits, long start, long setting, long exceeded) {
        return String.format("Session (started=%s, hits=%s, last access=%s) exceeded %s (%s) by %s ms", new Timestamp(start), hits, new Timestamp(lastAccess), why, setting, exceeded);
    }

    public void removeSession(String uuid) {
        this.internalRemove(uuid, "Remove session called");
    }

    private void internalRemove(String uuid, String reason) {
        if (!this.sessions.containsKey(uuid)) {
            log.warn("Session not in cache: " + uuid);
            return;
        }
        log.info("Destroying session " + uuid + " due to : " + reason);
        Set<SessionCallback> cbs = this.sessionCallbackMap.get(uuid);
        if (cbs != null) {
            for (SessionCallback cb : cbs) {
                try {
                    cb.close();
                }
                catch (Exception e) {
                    String msg = "SessionCallback %s throw exception for session %s";
                    log.warn(String.format("SessionCallback %s throw exception for session %s", cb, uuid), (Throwable)e);
                }
            }
        }
        try {
            this.context.publishEvent((ApplicationEvent)new DestroySessionMessage(this, uuid));
        }
        catch (RuntimeException re) {
            String msg = "Session listener threw an exception for session %s";
            log.warn(String.format("Session listener threw an exception for session %s", uuid), (Throwable)re);
        }
        this.ehmanager.removeCache("memory:" + uuid);
        this.ehmanager.removeCache("ondisk:" + uuid);
        this.sessions.remove(uuid);
    }

    public Set<String> getIds() {
        return this.sessions.keySet();
    }

    public Ehcache inMemoryCache(String uuid) {
        this.getDataNullOrThrowOnTimeout(uuid, true);
        String key = "memory:" + uuid;
        return this.createCache(key, true, 0);
    }

    public Ehcache onDiskCache(String uuid) {
        this.getDataNullOrThrowOnTimeout(uuid, true);
        String key = "ondisk:" + uuid;
        return this.createCache(key, false, 100);
    }

    protected Ehcache createCache(String key, boolean inMemory, int maxInMemory) {
        Ehcache cache = null;
        try {
            cache = this.ehmanager.getEhcache(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cache == null) {
            CacheFactory factory = new CacheFactory();
            factory.setBeanName(key);
            factory.setCacheManager(this.ehmanager);
            factory.setOverflowToDisk(!inMemory);
            factory.setMaxElementsInMemory(maxInMemory);
            factory.setMaxElementsOnDisk(0);
            factory.setDiskPersistent(false);
            factory.setTimeToIdle(0);
            factory.setTimeToLive(0);
            cache = factory.createCache(new CacheEventListener[0]);
        }
        return cache;
    }

    public long getLastUpdated() {
        return this.state.get().lastUpdateRun;
    }

    public void updateEvent(UserGroupUpdateEvent ugue) {
        long time = 0L;
        time = ugue == null || ugue.getTimestamp() > System.currentTimeMillis() ? System.currentTimeMillis() : ugue.getTimestamp();
        State old = this.state.get();
        this.state.set(new State(old, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate() {
        if (!this.state.get().checkNeedsUpdate(this.forceUpdateInterval)) {
            return;
        }
        if (!this.active.compareAndSet(false, true)) {
            return;
        }
        try {
            Set<String> ids = this.sessions.keySet();
            log.info("Synchronizing session cache. Count = " + ids.size());
            Slf4JStopWatch sw = new Slf4JStopWatch();
            for (String id : ids) {
                this.reload(id);
            }
            sw.stop("omero.sessions.synchronization");
            log.info(String.format("Synchronization took %s ms.", sw.getElapsedTime()));
        }
        catch (Exception e) {
            log.error("Error synchronizing cache", (Throwable)e);
        }
        finally {
            this.active.set(false);
        }
    }

    public void reload(String id) {
        StaleCacheListener listener = this.staleCacheListener.get();
        if (listener == null) {
            log.error("Null stale cache listener!");
            return;
        }
        Data data = null;
        try {
            data = this.getDataNullOrThrowOnTimeout(id, false);
            if (data == null) {
                this.internalRemove(id, "Timeout");
                return;
            }
        }
        catch (Exception e) {
            log.warn("Removing session on get error of " + id, (Throwable)e);
            this.internalRemove(id, "Get error");
        }
        try {
            SessionContext ctx = data.sessionContext;
            SessionContext replacement = listener.reload(ctx);
            if (replacement == null) {
                this.internalRemove(id, "Replacement null");
            } else {
                this.refresh(id, data, replacement);
            }
        }
        catch (Exception e) {
            int count = data.error.incrementAndGet();
            if (count > Data.MAX_ERROR) {
                log.warn("Removing session on reload error of " + id, (Throwable)e);
                this.internalRemove(id, "Reload error");
            }
            log.warn(count + "error(s) on reload of " + id, (Throwable)e);
        }
    }

    private static class State {
        final long lastUpdateRun;
        final long lastUpdateRequest;

        State() {
            this.lastUpdateRun = System.currentTimeMillis();
            this.lastUpdateRequest = this.lastUpdateRun - 1L;
        }

        State(State old, long request) {
            this.lastUpdateRun = old.lastUpdateRun;
            this.lastUpdateRequest = request;
        }

        boolean checkNeedsUpdate(long forceUpdateInterval) {
            if (this.lastUpdateRun < 0L) {
                return false;
            }
            if (this.lastUpdateRun <= this.lastUpdateRequest) {
                return true;
            }
            long timed = System.currentTimeMillis() - forceUpdateInterval;
            return this.lastUpdateRun <= timed;
        }
    }

    private static class Data {
        public static final Integer MAX_ERROR = 3;
        final AtomicInteger error = new AtomicInteger(0);
        final SessionContext sessionContext;
        final long lastAccessTime;
        final long hitCount;

        Data(SessionContext sc) {
            this(sc, System.currentTimeMillis(), 1L);
        }

        Data(Data old) {
            this(old, true);
        }

        Data(Data old, boolean reset) {
            this(old, old.sessionContext, reset);
        }

        Data(Data old, SessionContext ctx, boolean reset) {
            this(ctx, reset ? System.currentTimeMillis() : old.lastAccessTime, old.hitCount + 1L);
        }

        Data(SessionContext sc, long last, long count) {
            this.sessionContext = sc;
            this.lastAccessTime = last;
            this.hitCount = count;
            sc.getSession().getDetails().setContexts(null);
        }
    }

    public static interface StaleCacheListener {
        public SessionContext reload(SessionContext var1);
    }
}

