/*
 * Decompiled with CFR 0.152.
 */
package ome.system.utests;

import java.util.Properties;
import ome.system.PreferenceContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Ignore;
import org.testng.annotations.Test;

@Test(groups={"ticket:800"})
public class PrefsTest {
    public static final String testDefault = "test_default";
    PreferenceContext ctx;
    String oldDefault;

    @Test
    public void testSimple() {
        this.ctx = new PreferenceContext();
        System.setProperty("test", "ok");
        Assert.assertEquals((String)this.ctx.getProperty("test"), (String)"ok");
    }

    @Test
    public void testSystemOverridesLocals() {
        String key = "localsOverrideSystem";
        System.setProperty(key, "false");
        Properties p = new Properties();
        p.setProperty(key, "true");
        this.ctx = new PreferenceContext();
        this.ctx.setProperties(p);
        Assert.assertEquals((String)this.ctx.getProperty(key), (String)"false");
    }

    @Test
    public void testLocalsOverrideFiles() {
        String key = "localsOverridesFiles";
        Properties p = new Properties();
        p.setProperty(key, "true");
        this.ctx = new PreferenceContext();
        this.ctx.setProperties(p);
        this.ctx.setIgnoreResourceNotFound(false);
        this.ctx.setLocations(new Resource[]{new ClassPathResource("ome/system/utests/Prefs.properties")});
        Assert.assertEquals((String)this.ctx.getProperty(key), (String)"true");
    }

    @Test(groups={"broken"})
    public void testSystemOverridesFiles() {
        String key = "systemOverridesFiles";
        System.setProperty(key, "true");
        this.ctx = new PreferenceContext();
        this.ctx.setIgnoreResourceNotFound(false);
        this.ctx.setLocations(new Resource[]{new ClassPathResource("ome/system/utests/Prefs.properties")});
        Assert.assertEquals((String)this.ctx.getProperty(key), (String)"true");
    }

    @Test
    public void testMissingFilesOk() {
        this.ctx = new PreferenceContext();
        this.ctx.setLocations(new Resource[]{new ClassPathResource("DOES_NOT_EXIST")});
        this.ctx.getProperty("test");
    }

    @Ignore(value="To re-enable when we sort out version handling")
    @Test
    public void testOmeroVersion() {
        this.ctx = new PreferenceContext();
        this.ctx.setLocation((Resource)new ClassPathResource("omero.properties"));
        String v = this.ctx.getProperty("omero.version");
        Assert.assertNotNull((Object)v);
        Assert.assertTrue((v.length() > 0 ? 1 : 0) != 0);
    }
}

